/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.Node;
import de.fub.bytecode.classfile.StackMapEntry;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute
implements Node {
    private int map_length;
    private StackMapEntry[] map;

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.map_length);
        int n = 0;
        while (n < this.map_length) {
            this.map[n].dump(dataOutputStream);
            ++n;
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.map = stackMapEntryArray;
        this.map_length = stackMapEntryArray == null ? 0 : stackMapEntryArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap(");
        int n = 0;
        while (n < this.map_length) {
            stringBuffer.append(this.map[n].toString());
            if (n < this.map_length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.map = new StackMapEntry[this.map_length];
        int n = 0;
        while (n < this.map_length) {
            stackMap.map[n] = this.map[n].copy();
            ++n;
        }
        stackMap.constant_pool = constantPool;
        return stackMap;
    }

    public final void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }

    public StackMap(int n, int n2, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n, n2, constantPool);
        this.setStackMap(stackMapEntryArray);
    }

    StackMap(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (StackMapEntry[])null, constantPool);
        this.map_length = dataInputStream.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        int n3 = 0;
        while (n3 < this.map_length) {
            this.map[n3] = new StackMapEntry(dataInputStream, constantPool);
            ++n3;
        }
    }
}

