/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.IndexedInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        String string = constantPool.constantToString(constant);
        if (constant instanceof ConstantClass) {
            string = string.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + string;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.setIndex(byteSequence.readUnsignedShort());
        this.length = (short)3;
    }

    public final int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        ConstantPool constantPool = constantPoolGen.getConstantPool();
        String string = constantPool.getConstantString(this.index, (byte)7);
        if (!string.startsWith("[")) {
            string = "L" + string + ";";
        }
        return Type.getType(string);
    }

    CPInstruction() {
    }

    protected CPInstruction(short s, int n) {
        super(s, (short)3);
        this.setIndex(n);
    }
}

