/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionTargeter;
import de.fub.bytecode.generic.ObjectType;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle start_pc;
    private InstructionHandle end_pc;
    private InstructionHandle handler_pc;
    private ObjectType catch_type;

    public final CodeException getCodeException(ConstantPoolGen constantPoolGen) {
        return new CodeException(this.start_pc.getPosition(), this.end_pc.getPosition() + this.end_pc.getInstruction().getLength(), this.handler_pc.getPosition(), this.catch_type == null ? 0 : constantPoolGen.addClass(this.catch_type));
    }

    public final void setStartPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start_pc, instructionHandle, this);
        this.start_pc = instructionHandle;
    }

    public final void setEndPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end_pc, instructionHandle, this);
        this.end_pc = instructionHandle;
    }

    public final void setHandlerPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.handler_pc, instructionHandle, this);
        this.handler_pc = instructionHandle;
    }

    public final void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start_pc == instructionHandle) {
            bl = true;
            this.setStartPC(instructionHandle2);
        }
        if (this.end_pc == instructionHandle) {
            bl = true;
            this.setEndPC(instructionHandle2);
        }
        if (this.handler_pc == instructionHandle) {
            bl = true;
            this.setHandlerPC(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + "}");
        }
    }

    public final boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start_pc == instructionHandle || this.end_pc == instructionHandle || this.handler_pc == instructionHandle;
    }

    public final void setCatchType(ObjectType objectType) {
        this.catch_type = objectType;
    }

    public final ObjectType getCatchType() {
        return this.catch_type;
    }

    public final InstructionHandle getStartPC() {
        return this.start_pc;
    }

    public final InstructionHandle getEndPC() {
        return this.end_pc;
    }

    public final InstructionHandle getHandlerPC() {
        return this.handler_pc;
    }

    public final String toString() {
        return "CodeExceptionGen(" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + ")";
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public CodeExceptionGen(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        this.setStartPC(instructionHandle);
        this.setEndPC(instructionHandle2);
        this.setHandlerPC(instructionHandle3);
        this.catch_type = objectType;
    }
}

