/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantCP;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantDouble;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantFloat;
import de.fub.bytecode.classfile.ConstantInteger;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantLong;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.MethodGen;
import de.fub.bytecode.generic.ObjectType;
import java.util.Hashtable;

public class ConstantPoolGen {
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    protected int size = 1024;
    protected Constant[] constants = new Constant[this.size];
    protected int index = 1;
    private Hashtable string_table = new Hashtable();
    private Hashtable class_table = new Hashtable();
    private Hashtable utf8_table = new Hashtable();
    private Hashtable n_a_t_table = new Hashtable();
    private Hashtable cp_table = new Hashtable();

    protected void adjustSize() {
        if (this.index + 3 >= this.size) {
            Constant[] constantArray = this.constants;
            this.size *= 2;
            this.constants = new Constant[this.size];
            System.arraycopy(constantArray, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String string) {
        Index index = (Index)this.string_table.get(string);
        return index != null ? index.index : -1;
    }

    public int addString(String string) {
        int n = this.lookupString(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantUtf8 constantUtf8 = new ConstantUtf8(string);
        ConstantString constantString = new ConstantString(this.index);
        this.constants[this.index++] = constantUtf8;
        n = this.index;
        this.constants[this.index++] = constantString;
        this.string_table.put(string, new Index(n));
        return n;
    }

    public int lookupClass(String string) {
        Index index = (Index)this.class_table.get(string.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private final int addClass_(String string) {
        int n = this.lookupClass(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string));
        n = this.index;
        this.constants[this.index++] = constantClass;
        this.class_table.put(string, new Index(n));
        return n;
    }

    public int addClass(String string) {
        return this.addClass_(string.replace('.', '/'));
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass_(arrayType.getSignature());
    }

    public int lookupInteger(int n) {
        int n2 = 1;
        while (n2 < this.index) {
            ConstantInteger constantInteger;
            if (this.constants[n2] instanceof ConstantInteger && (constantInteger = (ConstantInteger)this.constants[n2]).getBytes() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int addInteger(int n) {
        int n2 = this.lookupInteger(n);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return n2;
    }

    public int lookupFloat(float f) {
        int n = 1;
        while (n < this.index) {
            ConstantFloat constantFloat;
            if (this.constants[n] instanceof ConstantFloat && (constantFloat = (ConstantFloat)this.constants[n]).getBytes() == f) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int addFloat(float f) {
        int n = this.lookupFloat(f);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantFloat(f);
        return n;
    }

    public int lookupUtf8(String string) {
        Index index = (Index)this.utf8_table.get(string);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String string) {
        int n = this.lookupUtf8(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantUtf8(string);
        this.utf8_table.put(string, new Index(n));
        return n;
    }

    public int lookupLong(long l) {
        int n = 1;
        while (n < this.index) {
            ConstantLong constantLong;
            if (this.constants[n] instanceof ConstantLong && (constantLong = (ConstantLong)this.constants[n]).getBytes() == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int addLong(long l) {
        int n = this.lookupLong(l);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantLong(l);
        this.index += 2;
        return n;
    }

    public int lookupDouble(double d) {
        int n = 1;
        while (n < this.index) {
            ConstantDouble constantDouble;
            if (this.constants[n] instanceof ConstantDouble && (constantDouble = (ConstantDouble)this.constants[n]).getBytes() == d) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int addDouble(double d) {
        int n = this.lookupDouble(d);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantDouble(d);
        this.index += 2;
        return n;
    }

    public int lookupNameAndType(String string, String string2) {
        Index index = (Index)this.n_a_t_table.get(string + NAT_DELIM + string2);
        return index != null ? index.index : -1;
    }

    public int addNameAndType(String string, String string2) {
        int n = this.lookupNameAndType(string, string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addUtf8(string);
        int n3 = this.addUtf8(string2);
        n = this.index;
        this.constants[this.index++] = new ConstantNameAndType(n2, n3);
        this.n_a_t_table.put(string + NAT_DELIM + string2, new Index(n));
        return n;
    }

    public int lookupMethodref(String string, String string2, String string3) {
        Index index = (Index)this.cp_table.get(string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen methodGen) {
        return this.lookupMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addMethodref(String string, String string2, String string3) {
        int n = this.lookupMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addNameAndType(string2, string3);
        int n3 = this.addClass(string);
        n = this.index;
        this.constants[this.index++] = new ConstantMethodref(n3, n2);
        this.cp_table.put(string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3, new Index(n));
        return n;
    }

    public int addMethodref(MethodGen methodGen) {
        return this.addMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupInterfaceMethodref(String string, String string2, String string3) {
        Index index = (Index)this.cp_table.get(string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen methodGen) {
        return this.lookupInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addInterfaceMethodref(String string, String string2, String string3) {
        int n = this.lookupInterfaceMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(n2, n3);
        this.cp_table.put(string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3, new Index(n));
        return n;
    }

    public int addInterfaceMethodref(MethodGen methodGen) {
        return this.addInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupFieldref(String string, String string2, String string3) {
        Index index = (Index)this.cp_table.get(string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String string, String string2, String string3) {
        int n = this.lookupFieldref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantFieldref(n2, n3);
        this.cp_table.put(string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3, new Index(n));
        return n;
    }

    public Constant getConstant(int n) {
        return this.constants[n];
    }

    public void setConstant(int n, Constant constant) {
        this.constants[n] = constant;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] constantArray = new Constant[this.index];
        System.arraycopy(this.constants, 0, constantArray, 0, this.index);
        return new ConstantPool(constantArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < this.index) {
            stringBuffer.append(n + ")" + this.constants[n] + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public int addConstant(Constant constant, ConstantPoolGen constantPoolGen) {
        Constant[] constantArray = constantPoolGen.getConstantPool().getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getBytes());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getBytes());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getBytes(), constantUtf82.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string = constantUtf8.getBytes().replace('/', '.');
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string2 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string3 = constantUtf8.getBytes();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string, string2, string3);
                    }
                    case 10: {
                        return this.addMethodref(string, string2, string3);
                    }
                    case 9: {
                        return this.addFieldref(string, string2, string3);
                    }
                }
                throw new RuntimeException("Unknown constant type " + constant);
            }
        }
        throw new RuntimeException("Unknown constant type " + constant);
    }

    public ConstantPoolGen(Constant[] constantArray) {
        if (constantArray.length > this.size) {
            this.size = constantArray.length;
            this.constants = new Constant[this.size];
        }
        System.arraycopy(constantArray, 0, this.constants, 0, constantArray.length);
        if (constantArray.length > 0) {
            this.index = constantArray.length;
        }
        int n = 1;
        while (n < this.index) {
            Constant constant;
            Constant constant2;
            Constant constant3;
            Constant constant4 = this.constants[n];
            if (constant4 instanceof ConstantString) {
                constant3 = (ConstantString)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantString)constant3).getStringIndex()];
                this.string_table.put(((ConstantUtf8)constant2).getBytes(), new Index(n));
            } else if (constant4 instanceof ConstantClass) {
                constant3 = (ConstantClass)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantClass)constant3).getNameIndex()];
                this.class_table.put(((ConstantUtf8)constant2).getBytes(), new Index(n));
            } else if (constant4 instanceof ConstantNameAndType) {
                constant3 = (ConstantNameAndType)constant4;
                constant2 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getNameIndex()];
                constant = (ConstantUtf8)this.constants[((ConstantNameAndType)constant3).getSignatureIndex()];
                this.n_a_t_table.put(((ConstantUtf8)constant2).getBytes() + NAT_DELIM + ((ConstantUtf8)constant).getBytes(), new Index(n));
            } else if (constant4 instanceof ConstantUtf8) {
                constant3 = (ConstantUtf8)constant4;
                this.utf8_table.put(((ConstantUtf8)constant3).getBytes(), new Index(n));
            } else if (constant4 instanceof ConstantCP) {
                constant3 = (ConstantCP)constant4;
                constant2 = (ConstantClass)this.constants[((ConstantCP)constant3).getClassIndex()];
                constant = (ConstantNameAndType)this.constants[((ConstantCP)constant3).getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constants[((ConstantClass)constant2).getNameIndex()];
                String string = constantUtf8.getBytes().replace('/', '.');
                constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getNameIndex()];
                String string2 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getSignatureIndex()];
                String string3 = constantUtf8.getBytes();
                String string4 = METHODREF_DELIM;
                if (constant4 instanceof ConstantInterfaceMethodref) {
                    string4 = IMETHODREF_DELIM;
                } else if (constant4 instanceof ConstantFieldref) {
                    string4 = FIELDREF_DELIM;
                }
                this.cp_table.put(string + string4 + string2 + string4 + string3, new Index(n));
            }
            ++n;
        }
    }

    public ConstantPoolGen(ConstantPool constantPool) {
        this(constantPool.getConstantPool());
    }

    public ConstantPoolGen() {
    }

    private static class Index {
        int index;

        Index(int n) {
            this.index = n;
        }
    }
}

