/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantObject;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.FieldGenOrMethodGen;
import de.fub.bytecode.generic.FieldObserver;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.Type;
import java.util.Enumeration;
import java.util.Vector;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;
    private Vector observers;

    private final void setValue(int n) {
        ConstantPool constantPool = this.cp.getConstantPool();
        Constant constant = constantPool.getConstant(n);
        this.value = ((ConstantObject)((Object)constant)).getConstantValue(constantPool);
    }

    public void setInitValue(String string) {
        this.checkType(new ObjectType("java.lang.String"));
        if (string != null) {
            this.value = string;
        }
    }

    public void setInitValue(long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = new Long(l);
        }
    }

    public void setInitValue(int n) {
        this.checkType(Type.INT);
        if (n != 0) {
            this.value = new Integer(n);
        }
    }

    public void setInitValue(short s) {
        this.checkType(Type.SHORT);
        if (s != 0) {
            this.value = new Integer(s);
        }
    }

    public void setInitValue(char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = new Integer(c);
        }
    }

    public void setInitValue(byte by) {
        this.checkType(Type.BYTE);
        if (by != 0) {
            this.value = new Integer(by);
        }
    }

    public void setInitValue(boolean bl) {
        this.checkType(Type.BOOLEAN);
        if (bl) {
            this.value = new Integer(1);
        }
    }

    public void setInitValue(float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = new Float(f);
        }
    }

    public void setInitValue(double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = new Double(d);
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private final void checkType(Type type) {
        if (this.type == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!this.type.equals(type)) {
            throw new ClassGenException("Types are not compatible: " + this.type + " vs. " + type);
        }
    }

    public Field getField() {
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        if (this.value != null) {
            this.checkType(this.type);
            int n3 = this.addConstant();
            this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, n3, this.cp.getConstantPool()));
        }
        return new Field(this.access_flags, n, n2, this.getAttributes(), this.cp.getConstantPool());
    }

    private final int addConstant() {
        switch (this.type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return this.cp.addInteger((Integer)this.value);
            }
            case 6: {
                return this.cp.addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return this.cp.addDouble((Double)this.value);
            }
            case 11: {
                return this.cp.addLong((Long)this.value);
            }
            case 14: {
                return this.cp.addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + this.type.getType());
    }

    public String getSignature() {
        return this.type.getSignature();
    }

    public void addObserver(FieldObserver fieldObserver) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.addElement(fieldObserver);
    }

    public void removeObserver(FieldObserver fieldObserver) {
        if (this.observers != null) {
            this.observers.removeElement(fieldObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((FieldObserver)enumeration.nextElement()).notify(this);
            }
        }
    }

    public String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String string = Utility.accessToString(this.access_flags);
        string = string.equals("") ? "" : string + " ";
        String string2 = this.type.toString();
        String string3 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string + string2 + " " + string3);
        String string4 = this.getInitValue();
        if (string4 != null) {
            stringBuffer.append(" = " + string4);
        }
        return stringBuffer.toString();
    }

    public FieldGen copy(ConstantPoolGen constantPoolGen) {
        FieldGen fieldGen = (FieldGen)this.clone();
        fieldGen.setConstantPool(constantPoolGen);
        return fieldGen;
    }

    public FieldGen(int n, Type type, String string, ConstantPoolGen constantPoolGen) {
        this.setAccessFlags(n);
        this.setType(type);
        this.setName(string);
        this.setConstantPool(constantPoolGen);
    }

    public FieldGen(Field field, ConstantPoolGen constantPoolGen) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), constantPoolGen);
        Attribute[] attributeArray = field.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            if (attributeArray[n] instanceof ConstantValue) {
                this.setValue(((ConstantValue)attributeArray[n]).getConstantValueIndex());
            } else {
                this.addAttribute(attributeArray[n]);
            }
            ++n;
        }
    }
}

