/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeConstraint;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class FindPattern {
    private static final int OFFSET = Short.MAX_VALUE;
    private static final int NO_OPCODES = 256;
    private static final String[] patterns = new String[]{"instruction", "branchinstruction", "if_icmp__", "if__", "push", "iload__", "aload__", "fload__", "dload__", "lload__", "istore__", "astore__", "fstore__", "dstore__", "lstore__", "invokeinstruction", "returninstruction", "ifinstruction"};
    private static String[] pattern_map;
    private InstructionList il;
    private String il_string;
    private InstructionHandle[] handles;
    private int match_length;
    private int matched_from;

    public final void reread() {
        int n = this.il.getLength();
        char[] cArray = new char[n];
        this.handles = this.il.getInstructionHandles();
        this.match_length = -1;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = FindPattern.makeChar(this.handles[n2].getInstruction().getOpcode());
            ++n2;
        }
        this.il_string = new String(cArray);
    }

    private static final String getPattern(String string) {
        short s = 0;
        while (s < patterns.length) {
            if (string.equals(patterns[s])) {
                return pattern_map[s];
            }
            ++s;
        }
        s = 0;
        while (s < 256) {
            if (string.equals(Constants.OPCODE_NAMES[s])) {
                return new String(new char[]{FindPattern.makeChar(s)});
            }
            s = (short)(s + 1);
        }
        return null;
    }

    private static final String makePattern(String string) {
        String string2 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        StringBuffer stringBuffer2 = null;
        try {
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                switch (c) {
                    case '`': {
                        if (bl) {
                            throw new ClassGenException("` within `' block.");
                        }
                        stringBuffer2 = new StringBuffer();
                        bl = true;
                        break;
                    }
                    case '\'': {
                        if (!bl) {
                            throw new ClassGenException("' without starting `.");
                        }
                        bl = false;
                        String string3 = stringBuffer2.toString();
                        String string4 = FindPattern.getPattern(string3);
                        if (string4 == null) {
                            throw new ClassGenException("Unknown instruction pattern: \"" + string3 + "\"" + " at index " + n2);
                        }
                        stringBuffer.append(string4);
                        break;
                    }
                    default: {
                        if (bl) {
                            stringBuffer2.append(c);
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public final InstructionHandle search(String string, InstructionHandle instructionHandle, CodeConstraint codeConstraint) {
        String string2 = FindPattern.makePattern(string);
        int n = -1;
        this.matched_from = -1;
        this.match_length = -1;
        int n2 = 0;
        while (n2 < this.handles.length) {
            if (this.handles[n2] == instructionHandle) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new ClassGenException("Instruction handle " + instructionHandle + " not found in instruction list.");
        }
        try {
            RE rE = new RE((Object)string2);
            REMatch rEMatch = rE.getMatch((Object)this.il_string, n);
            if (rEMatch != null) {
                this.matched_from = rEMatch.getStartIndex();
                this.match_length = rEMatch.getEndIndex() - this.matched_from;
                if (codeConstraint == null || codeConstraint.checkCode(this.getMatch())) {
                    return this.handles[this.matched_from];
                }
            }
        }
        catch (REException rEException) {
            System.err.println((Object)rEException);
        }
        return null;
    }

    public final InstructionHandle search(String string) {
        return this.search(string, this.il.getStart(), null);
    }

    public final InstructionHandle search(String string, InstructionHandle instructionHandle) {
        return this.search(string, instructionHandle, null);
    }

    public final InstructionHandle search(String string, CodeConstraint codeConstraint) {
        return this.search(string, this.il.getStart(), codeConstraint);
    }

    public final int getMatchLength() {
        return this.match_length;
    }

    public final InstructionHandle[] getMatch() {
        if (this.match_length == -1) {
            throw new ClassGenException("Nothing matched.");
        }
        InstructionHandle[] instructionHandleArray = new InstructionHandle[this.match_length];
        System.arraycopy(this.handles, this.matched_from, instructionHandleArray, 0, this.match_length);
        return instructionHandleArray;
    }

    public final void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
        this.reread();
    }

    private static final String pattern2string(String string) {
        return FindPattern.pattern2string(string, true);
    }

    private static final String pattern2string(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= Short.MAX_VALUE) {
                if (bl) {
                    stringBuffer.append(Constants.OPCODE_NAMES[c - Short.MAX_VALUE]);
                } else {
                    stringBuffer.append(c - Short.MAX_VALUE);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final char makeChar(short s) {
        return (char)(s + Short.MAX_VALUE);
    }

    private static final void appendPatterns(StringBuffer stringBuffer, short s, short s2) {
        short s3 = s;
        while (s3 <= s2) {
            stringBuffer.append(FindPattern.makeChar(s3));
            if (s3 < s2) {
                stringBuffer.append('|');
            }
            s3 = (short)(s3 + 1);
        }
    }

    public final InstructionList getInstructionList() {
        return this.il;
    }

    public FindPattern(InstructionList instructionList) {
        this.il = instructionList;
        this.reread();
    }

    static {
        StringBuffer stringBuffer = new StringBuffer("(");
        short s = 0;
        while (s < 256) {
            if (Constants.NO_OF_OPERANDS[s] != -1) {
                stringBuffer.append(FindPattern.makeChar(s));
                if (s < 255) {
                    stringBuffer.append('|');
                }
            }
            s = (short)(s + 1);
        }
        stringBuffer.append(')');
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)153, (short)171);
        stringBuffer.append('|');
        FindPattern.appendPatterns(stringBuffer, (short)198, (short)201);
        stringBuffer.append(')');
        String string2 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)159, (short)164);
        stringBuffer.append(')');
        String string3 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)153, (short)158);
        stringBuffer.append(')');
        String string4 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)1, (short)20);
        stringBuffer.append(')');
        String string5 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)26, (short)29);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)21));
        stringBuffer.append(')');
        String string6 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)42, (short)45);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)25));
        stringBuffer.append(')');
        String string7 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)34, (short)37);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)23));
        stringBuffer.append(')');
        String string8 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)38, (short)41);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)24));
        stringBuffer.append(')');
        String string9 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)30, (short)33);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)22));
        stringBuffer.append(')');
        String string10 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)59, (short)62);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)54));
        stringBuffer.append(')');
        String string11 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)75, (short)78);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)58));
        stringBuffer.append(')');
        String string12 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)67, (short)70);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)56));
        stringBuffer.append(')');
        String string13 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)71, (short)74);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)57));
        stringBuffer.append(')');
        String string14 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)63, (short)66);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)55));
        stringBuffer.append(')');
        String string15 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)182, (short)185);
        stringBuffer.append(')');
        String string16 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)172, (short)177);
        stringBuffer.append(')');
        String string17 = stringBuffer.toString();
        stringBuffer = new StringBuffer("(");
        FindPattern.appendPatterns(stringBuffer, (short)153, (short)166);
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)198));
        stringBuffer.append('|');
        stringBuffer.append(FindPattern.makeChar((short)199));
        stringBuffer.append(')');
        String string18 = stringBuffer.toString();
        pattern_map = new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18};
    }
}

