/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ALOAD;
import de.fub.bytecode.generic.ANEWARRAY;
import de.fub.bytecode.generic.ASTORE;
import de.fub.bytecode.generic.AllocationInstruction;
import de.fub.bytecode.generic.ArithmeticInstruction;
import de.fub.bytecode.generic.ArrayInstruction;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.CHECKCAST;
import de.fub.bytecode.generic.ClassGen;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.DLOAD;
import de.fub.bytecode.generic.DSTORE;
import de.fub.bytecode.generic.FLOAD;
import de.fub.bytecode.generic.FSTORE;
import de.fub.bytecode.generic.FieldInstruction;
import de.fub.bytecode.generic.GETFIELD;
import de.fub.bytecode.generic.GETSTATIC;
import de.fub.bytecode.generic.GOTO;
import de.fub.bytecode.generic.GOTO_W;
import de.fub.bytecode.generic.IFEQ;
import de.fub.bytecode.generic.IFGE;
import de.fub.bytecode.generic.IFGT;
import de.fub.bytecode.generic.IFLE;
import de.fub.bytecode.generic.IFLT;
import de.fub.bytecode.generic.IFNE;
import de.fub.bytecode.generic.IFNONNULL;
import de.fub.bytecode.generic.IFNULL;
import de.fub.bytecode.generic.IF_ACMPEQ;
import de.fub.bytecode.generic.IF_ACMPNE;
import de.fub.bytecode.generic.IF_ICMPEQ;
import de.fub.bytecode.generic.IF_ICMPGE;
import de.fub.bytecode.generic.IF_ICMPGT;
import de.fub.bytecode.generic.IF_ICMPLE;
import de.fub.bytecode.generic.IF_ICMPLT;
import de.fub.bytecode.generic.IF_ICMPNE;
import de.fub.bytecode.generic.ILOAD;
import de.fub.bytecode.generic.INVOKEINTERFACE;
import de.fub.bytecode.generic.INVOKESPECIAL;
import de.fub.bytecode.generic.INVOKESTATIC;
import de.fub.bytecode.generic.INVOKEVIRTUAL;
import de.fub.bytecode.generic.ISTORE;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.InvokeInstruction;
import de.fub.bytecode.generic.JSR;
import de.fub.bytecode.generic.JSR_W;
import de.fub.bytecode.generic.LLOAD;
import de.fub.bytecode.generic.LSTORE;
import de.fub.bytecode.generic.LocalVariableInstruction;
import de.fub.bytecode.generic.MULTIANEWARRAY;
import de.fub.bytecode.generic.NEW;
import de.fub.bytecode.generic.NEWARRAY;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.PUSH;
import de.fub.bytecode.generic.PUTFIELD;
import de.fub.bytecode.generic.PUTSTATIC;
import de.fub.bytecode.generic.ReferenceType;
import de.fub.bytecode.generic.ReturnInstruction;
import de.fub.bytecode.generic.StackInstruction;
import de.fub.bytecode.generic.Type;

public class InstructionFactory
implements InstructionConstants {
    private static MethodObject[] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}, 1), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG}, 1)};
    protected ClassGen cg;
    protected ConstantPoolGen cp;

    public InvokeInstruction createInvoke(String string, String string2, Type type, Type[] typeArray, short s) {
        int n = 0;
        String string3 = Type.getMethodSignature(type, typeArray);
        int n2 = 0;
        while (n2 < typeArray.length) {
            n += typeArray[n2].getSize();
            ++n2;
        }
        int n3 = s == 185 ? this.cp.addInterfaceMethodref(string, string2, string3) : this.cp.addMethodref(string, string2, string3);
        switch (s) {
            case 183: {
                return new INVOKESPECIAL(n3);
            }
            case 182: {
                return new INVOKEVIRTUAL(n3);
            }
            case 184: {
                return new INVOKESTATIC(n3);
            }
            case 185: {
                return new INVOKEINTERFACE(n3, n + 1);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + s);
    }

    public InstructionList createPrintln(String string) {
        InstructionList instructionList = new InstructionList();
        int n = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int n2 = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        instructionList.append(new GETSTATIC(n));
        instructionList.append(new PUSH(this.cp, string));
        instructionList.append(new INVOKEVIRTUAL(n2));
        return instructionList;
    }

    private final InvokeInstruction createInvoke(MethodObject methodObject, short s) {
        return this.createInvoke(methodObject.class_name, methodObject.name, methodObject.result_type, methodObject.arg_types, s);
    }

    private static final boolean isString(Type type) {
        return type instanceof ObjectType && ((ObjectType)type).getClassName().equals("java.lang.String");
    }

    public Instruction createAppend(Type type) {
        byte by = type.getType();
        if (InstructionFactory.isString(type)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (by) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[by], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new RuntimeException("Oops: No append for this type? " + type);
    }

    public FieldInstruction createFieldAccess(String string, String string2, Type type, short s) {
        String string3 = type.getSignature();
        int n = this.cp.addFieldref(string, string2, string3);
        switch (s) {
            case 180: {
                return new GETFIELD(n);
            }
            case 181: {
                return new PUTFIELD(n);
            }
            case 178: {
                return new GETSTATIC(n);
            }
            case 179: {
                return new PUTSTATIC(n);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + s);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    public static ReturnInstruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.IRETURN;
            }
            case 6: {
                return InstructionConstants.FRETURN;
            }
            case 7: {
                return InstructionConstants.DRETURN;
            }
            case 11: {
                return InstructionConstants.LRETURN;
            }
            case 12: {
                return InstructionConstants.RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    private static final ArithmeticInstruction createBinaryIntOp(char c, String string) {
        switch (c) {
            case '-': {
                return InstructionConstants.ISUB;
            }
            case '+': {
                return InstructionConstants.IADD;
            }
            case '%': {
                return InstructionConstants.IREM;
            }
            case '*': {
                return InstructionConstants.IMUL;
            }
            case '/': {
                return InstructionConstants.IDIV;
            }
            case '&': {
                return InstructionConstants.IAND;
            }
            case '|': {
                return InstructionConstants.IOR;
            }
            case '^': {
                return InstructionConstants.IXOR;
            }
            case '<': {
                return InstructionConstants.ISHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConstants.IUSHR : InstructionConstants.ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string);
    }

    private static final ArithmeticInstruction createBinaryLongOp(char c, String string) {
        switch (c) {
            case '-': {
                return InstructionConstants.LSUB;
            }
            case '+': {
                return InstructionConstants.LADD;
            }
            case '%': {
                return InstructionConstants.LREM;
            }
            case '*': {
                return InstructionConstants.LMUL;
            }
            case '/': {
                return InstructionConstants.LDIV;
            }
            case '&': {
                return InstructionConstants.LAND;
            }
            case '|': {
                return InstructionConstants.LOR;
            }
            case '^': {
                return InstructionConstants.LXOR;
            }
            case '<': {
                return InstructionConstants.LSHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConstants.LUSHR : InstructionConstants.LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + string);
    }

    private static final ArithmeticInstruction createBinaryFloatOp(char c) {
        switch (c) {
            case '-': {
                return InstructionConstants.FSUB;
            }
            case '+': {
                return InstructionConstants.FADD;
            }
            case '*': {
                return InstructionConstants.FMUL;
            }
            case '/': {
                return InstructionConstants.FDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c);
    }

    private static final ArithmeticInstruction createBinaryDoubleOp(char c) {
        switch (c) {
            case '-': {
                return InstructionConstants.DSUB;
            }
            case '+': {
                return InstructionConstants.DADD;
            }
            case '*': {
                return InstructionConstants.DMUL;
            }
            case '/': {
                return InstructionConstants.DDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + c);
    }

    public static ArithmeticInstruction createBinaryOperation(String string, Type type) {
        char c = string.toCharArray()[0];
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(c, string);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(c, string);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(c);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(c);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static StackInstruction createPop(int n) {
        return n == 2 ? InstructionConstants.POP2 : InstructionConstants.POP;
    }

    public static StackInstruction createDup(int n) {
        return n == 2 ? InstructionConstants.DUP2 : InstructionConstants.DUP;
    }

    public static StackInstruction createDup_2(int n) {
        return n == 2 ? InstructionConstants.DUP2_X2 : InstructionConstants.DUP_X2;
    }

    public static StackInstruction createDup_1(int n) {
        return n == 2 ? InstructionConstants.DUP2_X1 : InstructionConstants.DUP_X1;
    }

    public static LocalVariableInstruction createStore(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(n);
            }
            case 6: {
                return new FSTORE(n);
            }
            case 7: {
                return new DSTORE(n);
            }
            case 11: {
                return new LSTORE(n);
            }
            case 13: 
            case 14: {
                return new ASTORE(n);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static LocalVariableInstruction createLoad(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(n);
            }
            case 6: {
                return new FLOAD(n);
            }
            case 7: {
                return new DLOAD(n);
            }
            case 11: {
                return new LLOAD(n);
            }
            case 13: 
            case 14: {
                return new ALOAD(n);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BALOAD;
            }
            case 5: {
                return InstructionConstants.CALOAD;
            }
            case 9: {
                return InstructionConstants.SALOAD;
            }
            case 10: {
                return InstructionConstants.IALOAD;
            }
            case 6: {
                return InstructionConstants.FALOAD;
            }
            case 7: {
                return InstructionConstants.DALOAD;
            }
            case 11: {
                return InstructionConstants.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BASTORE;
            }
            case 5: {
                return InstructionConstants.CASTORE;
            }
            case 9: {
                return InstructionConstants.SASTORE;
            }
            case 10: {
                return InstructionConstants.IASTORE;
            }
            case 6: {
                return InstructionConstants.FASTORE;
            }
            case 7: {
                return InstructionConstants.DASTORE;
            }
            case 11: {
                return InstructionConstants.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public Instruction createCast(Type type, Type type2) {
        if (type instanceof BasicType && type2 instanceof BasicType) {
            byte by = type2.getType();
            int n = type.getType();
            if (by == 11 && (n == 5 || n == 8 || n == 9)) {
                n = 10;
            }
            String[] stringArray = new String[]{"C", "F", "D", "B", "S", "I", "L"};
            String string = "de.fub.bytecode.generic." + stringArray[n - 5] + "2" + stringArray[by - 5];
            Instruction instruction = null;
            try {
                instruction = (Instruction)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not find instruction: " + string);
            }
            return instruction;
        }
        if (type instanceof ReferenceType && type2 instanceof ReferenceType) {
            if (type2 instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)type2));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)type2).getClassName()));
        }
        throw new RuntimeException("Can not cast " + type + " to " + type2);
    }

    public GETFIELD createGetField(String string, String string2, Type type) {
        return new GETFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public GETSTATIC createGetStatic(String string, String string2, Type type) {
        return new GETSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public PUTFIELD createPutField(String string, String string2, Type type) {
        return new PUTFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public PUTSTATIC createPutStatic(String string, String string2, Type type) {
        return new PUTSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public CHECKCAST createCheckCast(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)referenceType));
    }

    public NEW createNew(ObjectType objectType) {
        return new NEW(this.cp.addClass(objectType));
    }

    public NEW createNew(String string) {
        return this.createNew(new ObjectType(string));
    }

    public AllocationInstruction createNewArray(Type type, short s) {
        if (s == 1) {
            if (type instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)type));
            }
            if (type instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)type));
            }
            return new NEWARRAY(((BasicType)type).getType());
        }
        ArrayType arrayType = type instanceof ArrayType ? (ArrayType)type : new ArrayType(type, (int)s);
        return new MULTIANEWARRAY(this.cp.addArrayClass(arrayType), s);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.ICONST_0;
            }
            case 6: {
                return InstructionConstants.FCONST_0;
            }
            case 7: {
                return InstructionConstants.DCONST_0;
            }
            case 11: {
                return InstructionConstants.LCONST_0;
            }
            case 12: {
                return InstructionConstants.NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static BranchInstruction createBranchInstruction(short s, InstructionHandle instructionHandle) {
        switch (s) {
            case 153: {
                return new IFEQ(instructionHandle);
            }
            case 154: {
                return new IFNE(instructionHandle);
            }
            case 155: {
                return new IFLT(instructionHandle);
            }
            case 156: {
                return new IFGE(instructionHandle);
            }
            case 157: {
                return new IFGT(instructionHandle);
            }
            case 158: {
                return new IFLE(instructionHandle);
            }
            case 159: {
                return new IF_ICMPEQ(instructionHandle);
            }
            case 160: {
                return new IF_ICMPNE(instructionHandle);
            }
            case 161: {
                return new IF_ICMPLT(instructionHandle);
            }
            case 162: {
                return new IF_ICMPGE(instructionHandle);
            }
            case 163: {
                return new IF_ICMPGT(instructionHandle);
            }
            case 164: {
                return new IF_ICMPLE(instructionHandle);
            }
            case 165: {
                return new IF_ACMPEQ(instructionHandle);
            }
            case 166: {
                return new IF_ACMPNE(instructionHandle);
            }
            case 167: {
                return new GOTO(instructionHandle);
            }
            case 168: {
                return new JSR(instructionHandle);
            }
            case 198: {
                return new IFNULL(instructionHandle);
            }
            case 199: {
                return new IFNONNULL(instructionHandle);
            }
            case 200: {
                return new GOTO_W(instructionHandle);
            }
            case 201: {
                return new JSR_W(instructionHandle);
            }
        }
        throw new RuntimeException("Invalid opcode: " + s);
    }

    public void setClassGen(ClassGen classGen) {
        this.cg = classGen;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public InstructionFactory(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        this.cg = classGen;
        this.cp = constantPoolGen;
    }

    public InstructionFactory(ClassGen classGen) {
        this(classGen, classGen.getConstantPool());
    }

    public InstructionFactory(ConstantPoolGen constantPoolGen) {
        this(null, constantPoolGen);
    }

    private static class MethodObject {
        Type[] arg_types;
        Type result_type;
        String[] arg_names;
        String class_name;
        String name;
        int access;

        MethodObject(String string, String string2, Type type, Type[] typeArray, int n) {
            this.class_name = string;
            this.name = string2;
            this.result_type = type;
            this.arg_types = typeArray;
            this.access = n;
        }
    }
}

