/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionTargeter;
import de.fub.bytecode.generic.Visitor;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class InstructionHandle
implements Serializable {
    private static InstructionHandle ih_list = null;
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private Vector targeters;
    private Hashtable attributes;
    private static /* synthetic */ Class class$Lde$fub$bytecode$generic$BranchHandle;

    public final InstructionHandle getNext() {
        return this.next;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        if (instruction == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != (class$Lde$fub$bytecode$generic$BranchHandle != null ? class$Lde$fub$bytecode$generic$BranchHandle : (class$Lde$fub$bytecode$generic$BranchHandle = InstructionHandle.class$("de.fub.bytecode.generic.BranchHandle"))) && instruction instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + instruction + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = instruction;
    }

    public Instruction swapInstruction(Instruction instruction) {
        Instruction instruction2 = this.instruction;
        this.instruction = instruction;
        return instruction2;
    }

    static final InstructionHandle getInstructionHandle(Instruction instruction) {
        if (ih_list == null) {
            return new InstructionHandle(instruction);
        }
        InstructionHandle instructionHandle = ih_list;
        ih_list = instructionHandle.next;
        instructionHandle.setInstruction(instruction);
        return instructionHandle;
    }

    protected int updatePosition(int n, int n2) {
        this.i_position += n;
        return 0;
    }

    public int getPosition() {
        return this.i_position;
    }

    void setPosition(int n) {
        this.i_position = n;
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.removeAllElements();
        }
    }

    public void removeTargeter(InstructionTargeter instructionTargeter) {
        this.targeters.removeElement(instructionTargeter);
    }

    public void addTargeter(InstructionTargeter instructionTargeter) {
        if (this.targeters == null) {
            this.targeters = new Vector();
        }
        if (!this.targeters.contains(instructionTargeter)) {
            this.targeters.addElement(instructionTargeter);
        }
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return null;
        }
        Object[] objectArray = new InstructionTargeter[this.targeters.size()];
        this.targeters.copyInto(objectArray);
        return objectArray;
    }

    public String toString(boolean bl) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(bl);
    }

    public String toString() {
        return this.toString(true);
    }

    public void addAttribute(Object object, Object object2) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(3);
        }
        this.attributes.put(object, object2);
    }

    public void removeAttribute(Object object) {
        if (this.attributes != null) {
            this.attributes.remove(object);
        }
    }

    public Object getAttribute(Object object) {
        if (this.attributes != null) {
            return this.attributes.get(object);
        }
        return null;
    }

    public void accept(Visitor visitor) {
        this.instruction.accept(visitor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected InstructionHandle(Instruction instruction) {
        this.setInstruction(instruction);
    }
}

