/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.ExceptionThrower;
import de.fub.bytecode.generic.FieldOrMethod;
import de.fub.bytecode.generic.StackConsumer;
import de.fub.bytecode.generic.StackProducer;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        StringTokenizer stringTokenizer = new StringTokenizer(constantPool.constantToString(constant));
        return Constants.OPCODE_NAMES[this.opcode] + " " + stringTokenizer.nextToken().replace('.', '/') + stringTokenizer.nextToken();
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        String string = this.getSignature(constantPoolGen);
        Type[] typeArray = Type.getArgumentTypes(string);
        int n = this.opcode == 184 ? 0 : 1;
        int n2 = typeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n += typeArray[n3].getSize();
            ++n3;
        }
        return n;
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen).getSize();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen);
    }

    public String getMethodName(ConstantPoolGen constantPoolGen) {
        return this.getName(constantPoolGen);
    }

    public Type getReturnType(ConstantPoolGen constantPoolGen) {
        return Type.getReturnType(this.getSignature(constantPoolGen));
    }

    public Type[] getArgumentTypes(ConstantPoolGen constantPoolGen) {
        return Type.getArgumentTypes(this.getSignature(constantPoolGen));
    }

    public abstract Class[] getExceptions();

    InvokeInstruction() {
    }

    protected InvokeInstruction(short s, int n) {
        super(s, n);
    }
}

