/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionTargeter;
import de.fub.bytecode.generic.NamedAndTyped;
import de.fub.bytecode.generic.Type;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n = this.start.getPosition();
        int n2 = this.end.getPosition() - n;
        int n3 = constantPoolGen.addUtf8(this.name);
        int n4 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n, n2, n3, n4, this.index, constantPoolGen.getConstantPool());
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start, instructionHandle, this);
        this.start = instructionHandle;
    }

    public void setEnd(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end, instructionHandle, this);
        this.end = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start == instructionHandle) {
            bl = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(cloneNotSupportedException);
            return null;
        }
    }

    public void setSlot(int n) {
        this.index = n;
    }

    public int getSlot() {
        return this.index;
    }

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Invalid index index: " + n);
        }
        this.name = string;
        this.type = type;
        this.index = n;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
    }
}

