/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.IndexedInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.ReturnaddressType;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.generic.TypedInstruction;
import de.fub.bytecode.generic.Visitor;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private boolean wide;
    private int index;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.wide) {
            dataOutputStream.writeShort(this.index);
        } else {
            dataOutputStream.writeByte(this.index);
        }
    }

    private final void setWide() {
        this.wide = this.index > 255;
        this.length = this.wide ? (short)4 : (short)2;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.wide = bl;
        if (bl) {
            this.index = byteSequence.readUnsignedShort();
            this.length = (short)4;
        } else {
            this.index = byteSequence.readUnsignedByte();
            this.length = (short)2;
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
        this.setWide();
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return ReturnaddressType.NO_TARGET;
    }

    public void accept(Visitor visitor) {
        visitor.visitRET(this);
    }

    RET() {
    }

    public RET(int n) {
        super((short)169, (short)2);
        this.setIndex(n);
    }
}

