/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.Repository;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.Type;

public class ReferenceType
extends Type {
    public boolean isCastableTo(Type type) {
        if (this.equals(Type.NULL)) {
            return true;
        }
        return this.isAssignmentCompatibleWith(type);
    }

    public boolean isAssignmentCompatibleWith(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        ReferenceType referenceType = (ReferenceType)type;
        if (this.equals(Type.NULL)) {
            return true;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesClass()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.instanceOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface() && Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                return true;
            }
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface()) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
                if (this.equals(referenceType)) {
                    return true;
                }
                if (Repository.implementationOf(((ObjectType)this).getClassName(), ((ObjectType)referenceType).getClassName())) {
                    return true;
                }
            }
        }
        if (this instanceof ArrayType) {
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesClass() && referenceType.equals(Type.OBJECT)) {
                return true;
            }
            if (referenceType instanceof ArrayType) {
                Type type2 = ((ArrayType)this).getElementType();
                Type type3 = ((ArrayType)this).getElementType();
                if (type2 instanceof BasicType && type3 instanceof BasicType && type2.equals(type3)) {
                    return true;
                }
                if (type3 instanceof ReferenceType && type2 instanceof ReferenceType && ((ReferenceType)type2).isAssignmentCompatibleWith((ReferenceType)type3)) {
                    return true;
                }
            }
            if (referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
                int n = 0;
                while (n < Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS.length) {
                    if (referenceType.equals(new ObjectType(Constants.INTERFACES_IMPLEMENTED_BY_ARRAYS[n]))) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        return false;
    }

    public ReferenceType firstCommonSuperclass(ReferenceType referenceType) {
        if (this.equals(Type.NULL)) {
            return referenceType;
        }
        if (referenceType.equals(Type.NULL)) {
            return this;
        }
        if (this.equals(referenceType)) {
            return this;
        }
        if (this instanceof ArrayType || referenceType instanceof ArrayType) {
            return Type.OBJECT;
        }
        if (this instanceof ObjectType && ((ObjectType)this).referencesInterface() || referenceType instanceof ObjectType && ((ObjectType)referenceType).referencesInterface()) {
            return Type.OBJECT;
        }
        ObjectType objectType = (ObjectType)this;
        ObjectType objectType2 = (ObjectType)referenceType;
        JavaClass[] javaClassArray = Repository.getSuperClasses(objectType.getClassName());
        JavaClass[] javaClassArray2 = Repository.getSuperClasses(objectType2.getClassName());
        if (javaClassArray == null || javaClassArray2 == null) {
            return null;
        }
        JavaClass[] javaClassArray3 = new JavaClass[javaClassArray.length + 1];
        JavaClass[] javaClassArray4 = new JavaClass[javaClassArray2.length + 1];
        System.arraycopy(javaClassArray, 0, javaClassArray3, 1, javaClassArray.length);
        System.arraycopy(javaClassArray2, 0, javaClassArray4, 1, javaClassArray2.length);
        javaClassArray3[0] = Repository.lookupClass(objectType.getClassName());
        javaClassArray4[0] = Repository.lookupClass(objectType2.getClassName());
        int n = 0;
        while (n < javaClassArray4.length) {
            int n2 = 0;
            while (n2 < javaClassArray3.length) {
                if (javaClassArray3[n2].equals(javaClassArray4[n])) {
                    return new ObjectType(javaClassArray3[n2].getClassName());
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    protected ReferenceType(byte by, String string) {
        super(by, string);
    }

    ReferenceType() {
        super((byte)14, "<null object>");
    }
}

