/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.CompoundInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.LOOKUPSWITCH;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private Select instruction;
    private int match_length;

    private final void fillup(int n, InstructionHandle instructionHandle) {
        int n2 = this.match_length + this.match_length * n;
        int[] nArray = new int[n2];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n2];
        int n3 = 1;
        nArray[0] = this.match[0];
        instructionHandleArray[0] = this.targets[0];
        int n4 = 1;
        while (n4 < this.match_length) {
            int n5 = this.match[n4 - 1];
            int n6 = this.match[n4] - n5;
            int n7 = 1;
            while (n7 < n6) {
                nArray[n3] = n5 + n7;
                instructionHandleArray[n3] = instructionHandle;
                ++n3;
                ++n7;
            }
            nArray[n3] = this.match[n4];
            instructionHandleArray[n3] = this.targets[n4];
            ++n3;
            ++n4;
        }
        this.match = new int[n3];
        this.targets = new InstructionHandle[n3];
        System.arraycopy(nArray, 0, this.match, 0, n3);
        System.arraycopy(instructionHandleArray, 0, this.targets, 0, n3);
    }

    private final void sort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.match[(n + n2) / 2];
        while (true) {
            if (this.match[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < this.match[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = this.match[n3];
                this.match[n3] = this.match[n4];
                this.match[n4] = n6;
                InstructionHandle instructionHandle = this.targets[n3];
                this.targets[n3] = this.targets[n4];
                this.targets[n4] = instructionHandle;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sort(n, n4);
        }
        if (n3 < n2) {
            this.sort(n3, n2);
        }
    }

    private final boolean matchIsOrdered(int n) {
        int n2 = 1;
        while (n2 < this.match_length) {
            if (this.match[n2] - this.match[n2 - 1] > n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle, int n) {
        this.match = (int[])nArray.clone();
        this.targets = (InstructionHandle[])instructionHandleArray.clone();
        this.match_length = nArray.length;
        if (this.match_length < 2) {
            this.instruction = new TABLESWITCH(nArray, instructionHandleArray, instructionHandle);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(n)) {
                this.fillup(n, instructionHandle);
                this.instruction = new TABLESWITCH(this.match, this.targets, instructionHandle);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, instructionHandle);
            }
        }
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        this(nArray, instructionHandleArray, instructionHandle, 1);
    }
}

