/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.util;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantUtf8;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.InnerClass;
import de.fub.bytecode.classfile.InnerClasses;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.SourceFile;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.util.Class2HTML;
import de.fub.bytecode.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class AttributeHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private int attr_count = 0;
    private ConstantHTML constant_html;
    private ConstantPool constant_pool;

    private final String codeLink(int n, int n2) {
        return "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n + "\" TARGET=Code>" + n + "</A>";
    }

    final void close() {
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    final void writeAttribute(Attribute attribute, String string) throws IOException {
        this.writeAttribute(attribute, string, 0);
    }

    final void writeAttribute(Attribute attribute, String string, int n) throws IOException {
        byte by = attribute.getTag();
        if (by == -1) {
            return;
        }
        ++this.attr_count;
        if (this.attr_count % 2 == 0) {
            this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.file.println("<H4><A NAME=\"" + string + "\">" + this.attr_count + " " + Constants.ATTRIBUTE_NAMES[by] + "</A></H4>");
        switch (by) {
            case 2: {
                Code code = (Code)attribute;
                Attribute[] attributeArray = code.getAttributes();
                this.file.print("<UL><LI>Maximum stack size = " + code.getMaxStack() + "</LI>\n<LI>Number of local variables = " + code.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.class_name + "_code.html#method" + n + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] codeExceptionArray = code.getExceptionTable();
                int n2 = codeExceptionArray.length;
                if (n2 <= 0) break;
                this.file.print("<P><B>Exceptions handled</B><UL>");
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = codeExceptionArray[n3].getCatchType();
                    this.file.print("<LI>");
                    if (n4 != 0) {
                        this.file.print(this.constant_html.referenceConstant(n4));
                    } else {
                        this.file.print("Any Exception");
                    }
                    this.file.print("<BR>(Ranging from lines " + this.codeLink(codeExceptionArray[n3].getStartPC(), n) + " to " + this.codeLink(codeExceptionArray[n3].getEndPC(), n) + ", handled at line " + this.codeLink(codeExceptionArray[n3].getHandlerPC(), n) + ")</LI>");
                    ++n3;
                }
                this.file.print("</UL>");
                break;
            }
            case 1: {
                int n5 = ((ConstantValue)attribute).getConstantValueIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n5 + "\" TARGET=\"ConstantPool\">Constant value index(" + n5 + ")</A></UL>\n");
                break;
            }
            case 0: {
                int n6 = ((SourceFile)attribute).getSourceFileIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n6 + "\" TARGET=\"ConstantPool\">Source file index(" + n6 + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] nArray = ((ExceptionTable)attribute).getExceptionIndexTable();
                this.file.print("<UL>");
                int n7 = 0;
                while (n7 < nArray.length) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_cp.html#cp" + nArray[n7] + "\" TARGET=\"ConstantPool\">Exception class index(" + nArray[n7] + ")</A>\n");
                    ++n7;
                }
                this.file.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] lineNumberArray = ((LineNumberTable)attribute).getLineNumberTable();
                this.file.print("<P>");
                int n8 = 0;
                while (n8 < lineNumberArray.length) {
                    this.file.print("(" + lineNumberArray[n8].getStartPC() + ",&nbsp;" + lineNumberArray[n8].getLineNumber() + ")");
                    if (n8 < lineNumberArray.length - 1) {
                        this.file.print(", ");
                    }
                    ++n8;
                }
                break;
            }
            case 5: {
                LocalVariable[] localVariableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                this.file.print("<UL>");
                int n9 = 0;
                while (n9 < localVariableArray.length) {
                    int n10 = localVariableArray[n9].getSignatureIndex();
                    String string2 = ((ConstantUtf8)this.constant_pool.getConstant(n10, (byte)1)).getBytes();
                    string2 = Utility.signatureToString(string2, false);
                    int n11 = localVariableArray[n9].getStartPC();
                    int n12 = n11 + localVariableArray[n9].getLength();
                    this.file.println("<LI>" + Class2HTML.referenceType(string2) + "&nbsp;<B>" + localVariableArray[n9].getName() + "</B> in slot %" + localVariableArray[n9].getIndex() + "<BR>Valid from lines " + "<A HREF=\"" + this.class_name + "_code.html#code" + n + "@" + n11 + "\" TARGET=Code>" + n11 + "</A> to " + "<A HREF=\"" + this.class_name + "_code.html#code" + n + "@" + n12 + "\" TARGET=Code>" + n12 + "</A></LI>");
                    ++n9;
                }
                this.file.print("</UL>\n");
                break;
            }
            case 6: {
                InnerClass[] innerClassArray = ((InnerClasses)attribute).getInnerClasses();
                this.file.print("<UL>");
                int n13 = 0;
                while (n13 < innerClassArray.length) {
                    int n14 = innerClassArray[n13].getInnerNameIndex();
                    String string3 = n14 > 0 ? ((ConstantUtf8)this.constant_pool.getConstant(n14, (byte)1)).getBytes() : "&lt;anonymous&gt;";
                    String string4 = Utility.accessToString(innerClassArray[n13].getInnerAccessFlags());
                    this.file.print("<LI><FONT COLOR=\"#FF0000\">" + string4 + "</FONT> " + this.constant_html.referenceConstant(innerClassArray[n13].getInnerClassIndex()) + " in&nbsp;class " + this.constant_html.referenceConstant(innerClassArray[n13].getOuterClassIndex()) + " named " + string3 + "</LI>\n");
                    ++n13;
                }
                this.file.print("</UL>\n");
                break;
            }
            default: {
                this.file.print("<P>" + attribute.toString());
            }
        }
        this.file.println("</TD></TR>");
        this.file.flush();
    }

    AttributeHTML(String string, String string2, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_attributes.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }
}

