/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.util;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantCP;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantFieldref;
import de.fub.bytecode.classfile.ConstantInterfaceMethodref;
import de.fub.bytecode.classfile.ConstantMethodref;
import de.fub.bytecode.classfile.ConstantNameAndType;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.classfile.ConstantString;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.util.Class2HTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class ConstantHTML
implements Constants {
    private String class_name;
    private String class_package;
    private ConstantPool constant_pool;
    private PrintWriter file;
    private String[] constant_ref;
    private Constant[] constants;
    private Method[] methods;

    final String referenceConstant(int n) {
        return this.constant_ref[n];
    }

    private final void writeConstant(int n) {
        byte by = this.constants[n].getTag();
        this.file.println("<H4> <A NAME=cp" + n + ">" + n + "</A> " + Constants.CONSTANT_NAMES[by] + "</H4>");
        switch (by) {
            case 10: 
            case 11: {
                int n2;
                int n3;
                Object object;
                if (by == 10) {
                    object = (ConstantMethodref)this.constant_pool.getConstant(n, (byte)10);
                    n3 = ((ConstantCP)object).getClassIndex();
                    n2 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    object = (ConstantInterfaceMethodref)this.constant_pool.getConstant(n, (byte)11);
                    n3 = ((ConstantCP)object).getClassIndex();
                    n2 = ((ConstantCP)object).getNameAndTypeIndex();
                }
                object = this.constant_pool.constantToString(n2, (byte)12);
                String string = Class2HTML.toHTML((String)object);
                String string2 = this.constant_pool.constantToString(n3, (byte)7);
                String string3 = Utility.compactClassName(string2);
                string3 = Utility.compactClassName(string2);
                string3 = Utility.compactClassName(string3, this.class_package + ".", true);
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n2, (byte)12);
                String string4 = this.constant_pool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                String string5 = Utility.methodSignatureReturnType(string4, false);
                String string6 = Class2HTML.referenceType(string5);
                StringBuffer stringBuffer = new StringBuffer("(");
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringBuffer.append(Class2HTML.referenceType(stringArray[n4]));
                    if (n4 < stringArray.length - 1) {
                        stringBuffer.append(",&nbsp;");
                    }
                    ++n4;
                }
                stringBuffer.append(")");
                String string7 = stringBuffer.toString();
                String string8 = string2.equals(this.class_name) ? "<A HREF=\"" + this.class_name + "_code.html#method" + this.getMethodNumber((String)object + string4) + "\" TARGET=Code>" + string + "</A>" : "<A HREF=\"" + string2 + ".html" + "\" TARGET=_top>" + string3 + "</A>." + string;
                this.constant_ref[n] = string6 + "&nbsp;<A HREF=\"" + this.class_name + "_cp.html#cp" + n3 + "\" TARGET=Constants>" + string3 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string + "</A>&nbsp;" + string7;
                this.file.println("<P><TT>" + string6 + "&nbsp;" + string8 + string7 + "&nbsp;</TT>\n<UL>" + "<LI><A HREF=\"#cp" + n3 + "\">Class index(" + n3 + ")</A>\n" + "<LI><A HREF=\"#cp" + n2 + "\">NameAndType index(" + n2 + ")</A></UL>");
                break;
            }
            case 9: {
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n, (byte)9);
                int n5 = constantFieldref.getClassIndex();
                int n6 = constantFieldref.getNameAndTypeIndex();
                String string = this.constant_pool.constantToString(n5, (byte)7);
                String string9 = Utility.compactClassName(string);
                string9 = Utility.compactClassName(string9, this.class_package + ".", true);
                String string10 = this.constant_pool.constantToString(n6, (byte)12);
                String string11 = string.equals(this.class_name) ? "<A HREF=\"" + string + "_methods.html#field" + string10 + "\" TARGET=Methods>" + string10 + "</A>" : "<A HREF=\"" + string + ".html\" TARGET=_top>" + string9 + "</A>." + string10 + "\n";
                this.constant_ref[n] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n5 + "\" TARGET=Constants>" + string9 + "</A>.<A HREF=\"" + this.class_name + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string10 + "</A>";
                this.file.println("<P><TT>" + string11 + "</TT><BR>\n" + "<UL>" + "<LI><A HREF=\"#cp" + n5 + "\">Class(" + n5 + ")</A><BR>\n" + "<LI><A HREF=\"#cp" + n6 + "\">NameAndType(" + n6 + ")</A></UL>");
                break;
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)this.constant_pool.getConstant(n, (byte)7);
                int n7 = constantClass.getNameIndex();
                String string = this.constant_pool.constantToString(n, by);
                String string12 = Utility.compactClassName(string);
                string12 = Utility.compactClassName(string12, this.class_package + ".", true);
                String string13 = "<A HREF=\"" + string + ".html\" TARGET=_top>" + string12 + "</A>";
                this.constant_ref[n] = "<A HREF=\"" + this.class_name + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string12 + "</A>";
                this.file.println("<P><TT>" + string13 + "</TT><UL>" + "<LI><A HREF=\"#cp" + n7 + "\">Name index(" + n7 + ")</A></UL>\n");
                break;
            }
            case 8: {
                ConstantString constantString = (ConstantString)this.constant_pool.getConstant(n, (byte)8);
                int n8 = constantString.getStringIndex();
                String string = Class2HTML.toHTML(this.constant_pool.constantToString(n, by));
                this.file.println("<P><TT>" + string + "</TT><UL>" + "<LI><A HREF=\"#cp" + n8 + "\">Name index(" + n8 + ")</A></UL>\n");
                break;
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constant_pool.getConstant(n, (byte)12);
                int n9 = constantNameAndType.getNameIndex();
                int n10 = constantNameAndType.getSignatureIndex();
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n, by)) + "</TT><UL>" + "<LI><A HREF=\"#cp" + n9 + "\">Name index(" + n9 + ")</A>\n" + "<LI><A HREF=\"#cp" + n10 + "\">Signature index(" + n10 + ")</A></UL>\n");
                break;
            }
            default: {
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constant_pool.constantToString(n, by)) + "</TT>\n");
            }
        }
    }

    private final int getMethodNumber(String string) {
        int n = 0;
        while (n < this.methods.length) {
            String string2 = this.methods[n].getName() + this.methods[n].getSignature();
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    ConstantHTML(String string, String string2, String string3, Method[] methodArray, ConstantPool constantPool) throws IOException {
        this.class_name = string2;
        this.class_package = string3;
        this.constant_pool = constantPool;
        this.methods = methodArray;
        this.constants = constantPool.getConstantPool();
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_cp.html"));
        this.constant_ref = new String[this.constants.length];
        this.constant_ref[0] = "&lt;unknown&gt;";
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        int n = 1;
        while (n < this.constants.length) {
            if (n % 2 == 0) {
                this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
            } else {
                this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
            }
            if (this.constants[n] != null) {
                this.writeConstant(n);
            }
            this.file.print("</TD></TR>\n");
            ++n;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }
}

