/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.util;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.classfile.Utility;
import de.fub.bytecode.util.AttributeHTML;
import de.fub.bytecode.util.Class2HTML;
import de.fub.bytecode.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class MethodHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private ConstantHTML constant_html;
    private AttributeHTML attribute_html;

    private final void writeField(Field field) throws IOException {
        String string = Utility.signatureToString(field.getSignature());
        String string2 = field.getName();
        String string3 = Utility.accessToString(field.getAccessFlags());
        string3 = Utility.replace(string3, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string3 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string) + "</TD><TD><A NAME=\"field" + string2 + "\">" + string2 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            this.attribute_html.writeAttribute(attributeArray[n], string2 + "@" + n);
            ++n;
        }
        n = 0;
        while (n < attributeArray.length) {
            if (attributeArray[n].getTag() == 1) {
                String string4 = ((ConstantValue)attributeArray[n]).toString();
                this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + string2 + "@" + n + "\" TARGET=\"Attributes\">" + string4 + "</TD>\n");
                break;
            }
            ++n;
        }
        this.file.println("</TR>");
    }

    private final void writeMethod(Method method, int n) throws IOException {
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string4 = Utility.replace(string4, " ", "&nbsp;");
        String string5 = Class2HTML.toHTML(string3);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n + ">" + string4 + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(string2) + "</TD><TD>" + "<A HREF=" + this.class_name + "_code.html#method" + n + " TARGET=Code>" + string5 + "</A></TD>\n<TD>(");
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.file.print(Class2HTML.referenceType(stringArray[n2]));
            if (n2 < stringArray.length - 1) {
                this.file.print(", ");
            }
            ++n2;
        }
        this.file.print(")</TD></TR>");
        n2 = 0;
        while (n2 < attributeArray.length) {
            int n3;
            Object[] objectArray;
            this.attribute_html.writeAttribute(attributeArray[n2], "method" + n + "@" + n2, n);
            byte by = attributeArray[n2].getTag();
            if (by == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n2]).getExceptionIndexTable();
                n3 = 0;
                while (n3 < objectArray.length) {
                    this.file.print(this.constant_html.referenceConstant((int)objectArray[n3]));
                    if (n3 < objectArray.length - 1) {
                        this.file.print(", ");
                    }
                    ++n3;
                }
                this.file.println("</TD></TR>");
            } else if (by == 2) {
                objectArray = ((Code)attributeArray[n2]).getAttributes();
                n3 = 0;
                while (n3 < objectArray.length) {
                    this.attribute_html.writeAttribute(objectArray[n3], "method" + n + "@" + n2 + "@" + n3, n);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    MethodHTML(String string, String string2, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML) throws IOException {
        this.class_name = string2;
        this.attribute_html = attributeHTML;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        int n = 0;
        while (n < fieldArray.length) {
            this.writeField(fieldArray[n]);
            ++n;
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        n = 0;
        while (n < methodArray.length) {
            this.writeMethod(methodArray[n], n);
            ++n;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }
}

