/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import mscedit.BMSC;
import mscedit.Divider;
import mscedit.DividerGraphic;
import mscedit.EditorCanvas;
import mscedit.Glyph;
import mscedit.Instance;
import mscedit.InstanceGraphic;
import mscedit.Link;
import mscedit.MessageGraphic;
import mscedit.NegativeMessageGraphic;
import mscedit.XMLGui;

class BMSCEditorCanvas
extends EditorCanvas {
    private BMSC o_msc;
    private Vector o_instance_glyphs;
    private Vector o_message_glyphs;
    private Vector o_divider_glyphs;

    public BMSCEditorCanvas() {
    }

    public BMSCEditorCanvas(XMLGui xMLGui, String string) {
        this.o_msc = new BMSC(string);
        this.o_gui = xMLGui;
        this.rebuild();
        this.setBackground(Color.white);
    }

    public BMSCEditorCanvas(XMLGui xMLGui, BMSC bMSC) {
        this.o_msc = bMSC;
        this.o_gui = xMLGui;
        this.rebuild();
    }

    public Dimension getPreferredSize() {
        double d = Glyph.getScale();
        return new Dimension((int)((double)(this.o_instance_glyphs.size() * 100) * d), (int)((double)(this.o_msc.getLastTimeIndex() * 25 + 150) * d));
    }

    public BMSC getBMSC() {
        return this.o_msc;
    }

    public void rebuild() {
        this.o_instance_glyphs = new Vector();
        this.o_message_glyphs = new Vector();
        this.o_divider_glyphs = new Vector();
        if (this.o_msc != null) {
            Object object;
            Object object2;
            List list;
            List list2 = this.o_msc.getInstances();
            if (list2 != null) {
                int n = 0;
                while (n < list2.size()) {
                    this.o_instance_glyphs.add(new InstanceGraphic(((Instance)list2.get(n)).getName(), n, this.o_msc.getLastTimeIndex()));
                    ++n;
                }
            }
            if ((list = this.o_msc.getLinks()) != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (Link)object2.next();
                    if (((Link)object).isNegative()) {
                        this.o_message_glyphs.add(new NegativeMessageGraphic(((Link)object).getName(), this.locate(((Link)object).getFrom()), this.locate(((Link)object).getTo()), ((Link)object).getTimeIndex()));
                        continue;
                    }
                    this.o_message_glyphs.add(new MessageGraphic(((Link)object).getName(), this.locate(((Link)object).getFrom()), this.locate(((Link)object).getTo()), ((Link)object).getTimeIndex()));
                }
            }
            if ((object2 = this.o_msc.getDividers()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    this.o_divider_glyphs.add(new DividerGraphic(((Divider)object.next()).getTimeIndex(), this.o_msc.getInstances().size()));
                }
            }
        }
        this.repaint();
    }

    void addInstance(String string) {
        this.o_msc.addInstance(string);
    }

    void addLink(String string, String string2, int n) {
        this.o_gui.addLink(string, string2, (n - 50) / 25);
    }

    void addNegativeLink(String string, String string2, int n) {
        this.o_gui.addNegativeLink(string, string2, (n - 50) / 25);
    }

    void addDivider(int n) {
        this.o_msc.addDivider((n - 50) / 25);
        this.o_gui.setAddDividerMode(false);
        this.setCursor(new Cursor(0));
        this.rebuild();
    }

    void moveMessage(String string, int n) {
        this.o_msc.changeTimeIndex(string, n);
    }

    void moveDivider(int n, int n2) {
        this.o_msc.moveDivider(n, n2);
    }

    void addLink(String string, String string2, String string3, int n) {
        this.o_msc.addLink(string, string2, string3, n);
    }

    void addNegativeLink(String string, String string2, String string3, int n) {
        this.o_msc.addNegativeLink(string, string2, string3, n);
    }

    void delete() {
        if (this.o_selected == null) {
            int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this bMSC?", "Delete bMSC?", 0);
            if (n == 0) {
                this.o_gui.deleteBMSC(this.o_msc.getName());
            }
            this.rebuild();
            return;
        }
        if (this.o_selected instanceof MessageGraphic) {
            String string = this.getSelectionName();
            this.o_msc.deleteLink(this.getSelectionId());
            List list = this.o_msc.getLinks();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bl |= ((Link)iterator.next()).getName().equals(string);
            }
            if (!bl) {
                this.o_gui.removeFromMsgAlphabet(string);
            }
        } else if (this.o_selected instanceof DividerGraphic) {
            this.o_msc.deleteDivider(Integer.parseInt(this.o_selected.getId()));
        } else if (this.o_selected instanceof InstanceGraphic) {
            this.o_msc.deleteInstance(this.getSelectionId());
        }
    }

    void changeLinkName(String string, String string2) {
        this.o_msc.changeLinkName(string, string2);
    }

    void reverseSelectedLink() {
        this.o_msc.reverseLink(this.getSelectionId());
    }

    void negateSelectedLink() {
        this.o_msc.negateLink(this.getSelectionId());
    }

    void tidy() {
        this.o_msc.tidy();
    }

    boolean inAddLinkMode() {
        return this.o_gui.inAddLinkMode();
    }

    boolean inAddDividerMode() {
        return this.o_gui.inAddDividerMode();
    }

    boolean addPositive() {
        return this.o_gui.addPositive();
    }

    String getInstanceAt(int n, int n2) {
        Iterator iterator = this.o_instance_glyphs.iterator();
        while (iterator.hasNext()) {
            InstanceGraphic instanceGraphic = (InstanceGraphic)iterator.next();
            if (!instanceGraphic.contains(n, n2)) continue;
            return instanceGraphic.getName();
        }
        return null;
    }

    Glyph getMessageAt(int n, int n2) {
        Object object;
        Object object2;
        Iterator iterator = this.o_message_glyphs.iterator();
        while (iterator.hasNext()) {
            object2 = (MessageGraphic)iterator.next();
            if (!((Glyph)object2).contains(n, n2)) continue;
            return object2;
        }
        object2 = this.o_divider_glyphs.iterator();
        while (object2.hasNext()) {
            object = (DividerGraphic)object2.next();
            if (!((Glyph)object).contains(n, n2)) continue;
            return object;
        }
        object = this.o_instance_glyphs.iterator();
        while (object.hasNext()) {
            InstanceGraphic instanceGraphic = (InstanceGraphic)object.next();
            if (!instanceGraphic.contains(n, n2)) continue;
            return instanceGraphic;
        }
        return null;
    }

    void showPopup(MouseEvent mouseEvent) {
        this.o_gui.showPopup(mouseEvent);
    }

    private int locate(String string) {
        int n = 0;
        while (n < this.o_instance_glyphs.size()) {
            if (((InstanceGraphic)this.o_instance_glyphs.get(n)).getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void fileDraw(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics2D.setColor(Color.black);
        Iterator iterator = this.o_instance_glyphs.iterator();
        while (iterator.hasNext()) {
            object2 = (Glyph)iterator.next();
            if (object2 == this.o_selected) {
                graphics.setColor(Color.red);
                ((Glyph)object2).draw(graphics);
                graphics.setColor(Color.black);
                continue;
            }
            ((Glyph)object2).draw(graphics);
        }
        object2 = this.o_message_glyphs.iterator();
        while (object2.hasNext()) {
            object = (Glyph)object2.next();
            if (object == this.o_selected) {
                graphics.setColor(Color.red);
                ((Glyph)object).draw(graphics);
                graphics.setColor(Color.black);
                continue;
            }
            ((Glyph)object).draw(graphics);
        }
        object = this.o_divider_glyphs.iterator();
        while (object.hasNext()) {
            Glyph glyph = (Glyph)object.next();
            if (glyph == this.o_selected) {
                graphics.setColor(Color.red);
                glyph.draw(graphics);
                graphics.setColor(Color.black);
                continue;
            }
            glyph.draw(graphics);
        }
    }
}

