/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Iterator;
import java.util.Set;
import synthesis.ConstraintSynthesiser;
import synthesis.ControllerSynthesiser;
import synthesis.ImplementationSynthesiser;
import synthesis.MyOutput;
import synthesis.Specification;
import synthesis.SpecificationLoader;

public class ImpliedScenarioSynthesiser {
    private LTSOutput o;

    public ImpliedScenarioSynthesiser(LTSOutput lTSOutput) {
        this.o = lTSOutput;
    }

    public String run(mscedit.Specification specification) {
        Specification specification2;
        boolean bl = false;
        SpecificationLoader specificationLoader = new SpecificationLoader();
        try {
            specification2 = specificationLoader.getSpecification(specification, this.o);
            if (bl) {
                this.o.outln("Specification Loaded!");
            }
        }
        catch (Exception exception) {
            this.o.outln("Error loading specification");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.synthesiseEverything(specification2, stringBuffer, this.o);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.o.outln(exception.toString());
            this.o.outln("Error synthesising FSP specification");
            return null;
        }
    }

    public void synthesiseEverything(Specification specification, StringBuffer stringBuffer, LTSOutput lTSOutput) throws Exception {
        if (specification.containsConditions()) {
            throw new Exception("State labels are not allowed!");
        }
        MyOutput myOutput = new MyOutput(stringBuffer);
        long l = System.currentTimeMillis();
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("//--------------------------- Coordinator --------------------------");
        myOutput.println("//------------------------------------------------------------------");
        ControllerSynthesiser controllerSynthesiser = new ControllerSynthesiser();
        int n = controllerSynthesiser.synthesise(specification, myOutput, "Coordinator", lTSOutput);
        lTSOutput.outln("Coordinator model synthesis time: " + (System.currentTimeMillis() - l) + "ms. Nodes: " + n);
        l = System.currentTimeMillis();
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("//----------------------- Constraint Model -------------------");
        myOutput.println("//------------------------------------------------------------------");
        ConstraintSynthesiser constraintSynthesiser = new ConstraintSynthesiser();
        constraintSynthesiser.printConstraints(myOutput, specification, "ConstraintModel", lTSOutput);
        lTSOutput.outln("Constraint model synthesis time: " + (System.currentTimeMillis() - l) + "ms.");
        l = System.currentTimeMillis();
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("//------------------------ Architecture Model ----------------------");
        myOutput.println("//------------------------------------------------------------------");
        specification.AddScenarioMessages();
        Set set = specification.getScenarioMessages();
        String string = this.BuildHide(set);
        ImplementationSynthesiser implementationSynthesiser = new ImplementationSynthesiser();
        implementationSynthesiser.synthesise(specification, myOutput, "WCoordAct", "ComponentsWCoordAct", lTSOutput);
        String string2 = "||ArchitectureModel = (";
        boolean bl = true;
        Iterator iterator = specification.components().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            myOutput.println("deterministic ||" + string3 + " = " + string3 + "WCoordAct\\{" + string + "}.");
            if (!bl) {
                string2 = string2 + " || ";
            } else {
                bl = false;
            }
            string2 = string2 + string3;
        }
        string2 = string2 + ").";
        myOutput.println(string2);
        myOutput.println("");
        specification.RemoveScenarioMessages();
        lTSOutput.outln("Architecture behaviour model synthesis time: " + (System.currentTimeMillis() - l) + "ms.");
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("//----------------------------- Trace Model ------------------------");
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("deterministic ||TraceModel = (ComponentsWCoordAct || Coordinator) \\{" + string + "}.");
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("//---------------------- Properties & Checks -----------------------");
        myOutput.println("//------------------------------------------------------------------");
        myOutput.println("||ConstrainedArchitectureModel = (ArchitectureModel || ConstraintModel).");
        myOutput.println("property ||PTraceModel= TraceModel.");
        myOutput.println("property ||PConstraintModel = ConstraintModel.");
        myOutput.println("||ConsistencyCheck = (TraceModel|| PConstraintModel).");
        myOutput.println("||ImpliedScenarioCheck = (PTraceModel || ConstrainedArchitectureModel).");
    }

    private String BuildHide(Set set) {
        String string = "";
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }
}

