/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import synthesis.AltProduction;
import synthesis.BasicMSC;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.Grammar;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Production;
import synthesis.Specification;
import synthesis.StringIterator;
import synthesis.StringRelation;
import synthesis.StringSet;

public class Synthesiser {
    static final String SYSNAME = "Synthesiser (with state labels)";
    static final String SYSVERSION = "v1.3";
    static final String INIT = "Init";
    static final String FINAL = "Final";
    static final String TAU = "_tau";
    static final String ENDPREFIX = "E_";
    static final String BEGINPREFIX = "B_";
    static final String CONDPREFIX = "C_";
    boolean LateSemantics;

    public Synthesiser(boolean bl) {
        this.LateSemantics = bl;
    }

    public void synthesiseFSP(Specification specification, StringBuffer stringBuffer, LTSOutput lTSOutput) throws Exception {
        MyOutput myOutput = new MyOutput(stringBuffer);
        long l = System.currentTimeMillis();
        myOutput.println("//Automatically generated by Synthesiser (with state labels) v1.3");
        if (specification != null) {
            this.getFSPSpecification(specification, myOutput);
            long l2 = System.currentTimeMillis() - l;
            lTSOutput.outln("Total synthesis time: " + l2 + " milliseconds.");
        }
    }

    public void getFSPSpecification(Specification specification, MyOutput myOutput) throws Exception {
        String string = "||System = (";
        boolean bl = true;
        Iterator iterator = specification.components().iterator();
        StringRelation stringRelation = this.getCommonIsContinuationOfRelation(specification);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!bl) {
                string = string + " || ";
            } else {
                bl = false;
            }
            string = string + string2;
            Map map = specification.getComponentInstances(string2);
            StringRelation stringRelation2 = this.getIsContinuationOfRelation(stringRelation, map);
            Set set = this.getAltProductions(this.getFSPProductions(this.getProductions(map), stringRelation2));
            this.cleanUp(string2, set);
            this.outputFSP(string2, set, myOutput);
        }
        string = string + ").";
        myOutput.println(string);
    }

    public void printhMSCs(MyOutput myOutput, Specification specification) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string = "deterministic DetHMSC = (";
        Iterator iterator = specification.getContinuationsInit().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            object3 = (BasicMSC)iterator.next();
            if (bl) {
                bl = false;
            } else {
                string = string + " | ";
            }
            string = string + "init -> " + ((BasicMSC)object3).name;
        }
        string = string + "),";
        myOutput.println(string);
        iterator = specification.getbMSCs().iterator();
        bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
                myOutput.println(string);
            }
            object3 = (BasicMSC)iterator.next();
            object2 = specification.getContinuations((BasicMSC)object3).iterator();
            if (object2.hasNext()) {
                string = ((BasicMSC)object3).name + " = (";
                boolean bl2 = true;
                while (object2.hasNext()) {
                    object = (BasicMSC)object2.next();
                    if (bl2) {
                        bl2 = false;
                    } else {
                        string = string + " | ";
                    }
                    string = string + "_" + ((BasicMSC)object3).name + " -> " + ((BasicMSC)object).name;
                }
                string = string + ")";
                continue;
            }
            string = ((BasicMSC)object3).name + " = STOP";
        }
        string = string + ".";
        myOutput.println(string);
        myOutput.println("property ||HSMC = DetHMSC\\{init}.");
        object3 = "deterministic ||ComposedHMSC = (";
        bl = true;
        iterator = specification.components().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string = "deterministic ||Det" + (String)object2 + " = DetHMSC@{";
            if (bl) {
                bl = false;
            } else {
                object3 = (String)object3 + " || ";
            }
            object3 = (String)object3 + "Det" + (String)object2;
            Map map = specification.getComponentInstances((String)object2);
            object = map.keySet().iterator();
            boolean bl3 = true;
            while (object.hasNext()) {
                String string2 = (String)object.next();
                Instance instance = (Instance)map.get(string2);
                if (instance.size() <= 0) continue;
                if (bl3) {
                    bl3 = false;
                } else {
                    string = string + ", ";
                }
                string = string + "_" + string2;
            }
            string = string + "}.";
            myOutput.println(string);
        }
        object3 = (String)object3 + ").";
        myOutput.println((String)object3);
        myOutput.println("||Check = (HSMC || ComposedHMSC).");
    }

    private Set getProductions(Map map) {
        HashSet<Production> hashSet = new HashSet<Production>();
        Iterator iterator = map.keySet().iterator();
        Production production = new Production();
        while (iterator.hasNext()) {
            Event event;
            String string = (String)iterator.next();
            ListIterator listIterator = ((Instance)map.get(string)).iterator();
            if (listIterator.hasNext()) {
                event = (Event)listIterator.next();
                if (event instanceof ConditionEvent) {
                    if (event.getLabel().equals(INIT)) {
                        production.add(event.getLabel());
                    } else {
                        production.add(CONDPREFIX + event.getLabel());
                    }
                } else {
                    production.add(BEGINPREFIX + string);
                    listIterator = ((Instance)map.get(string)).iterator();
                }
            }
            boolean bl = false;
            while (listIterator.hasNext()) {
                event = (Event)listIterator.next();
                if (event instanceof ConditionEvent) {
                    if (!bl) {
                        production.add(TAU);
                    }
                    String string2 = event.getLabel().equals(INIT) ? event.getLabel() : CONDPREFIX + event.getLabel();
                    production.add(string2);
                    hashSet.add(production);
                    production = new Production();
                    production.add(string2);
                    bl = false;
                    continue;
                }
                production.add(event.getLabel());
                bl = true;
            }
            if (bl) {
                production.add(ENDPREFIX + string);
                hashSet.add(production);
            }
            production = new Production();
        }
        return hashSet;
    }

    private Set getFSPProductions(Set set, StringRelation stringRelation) {
        HashSet hashSet = new HashSet();
        HashSet<Production> hashSet2 = new HashSet<Production>();
        StringIterator stringIterator = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            StringSet stringSet = stringRelation.getImage(production.first());
            if (stringSet.isEmpty()) {
                stringSet = new StringSet();
                stringSet.add(production.first());
                stringIterator = stringSet.stringIterator();
            } else {
                stringIterator = stringSet.stringIterator();
            }
            while (stringIterator.hasNext()) {
                String string = stringIterator.nextString();
                Production production2 = (Production)production.clone();
                production2.set(0, string);
                hashSet2.add(production2);
            }
        }
        return hashSet2;
    }

    private Set getAltProductions(Set set) {
        HashSet<AltProduction> hashSet = new HashSet<AltProduction>();
        AltProduction altProduction = new AltProduction("");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            Iterator iterator2 = hashSet.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                altProduction = (AltProduction)iterator2.next();
                if (!production.first().equals(altProduction.first)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                altProduction = new AltProduction(production.first());
                altProduction.addAlternative(production);
                hashSet.add(altProduction);
                continue;
            }
            bl = false;
            Iterator iterator3 = altProduction.getAlternatives().iterator();
            while (iterator3.hasNext()) {
                Production production2 = (Production)iterator3.next();
                if (!production.equals(production2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            altProduction.addAlternative(production);
        }
        return hashSet;
    }

    private void cleanUp(String string, Set set) {
        Grammar grammar = new Grammar(set, INIT);
        boolean bl = true;
        String string2 = "";
        int n = 0;
        while (bl) {
            ++n;
            bl = grammar.removeUnreachableNonTerminals();
            boolean bl2 = grammar.removeTrivialProductions();
            bl = bl || bl2;
            bl2 = grammar.removeRecursiveAlternatives();
            bl = bl || bl2;
            bl2 = grammar.replaceTrivialAlternatives();
            bl = bl || bl2;
            bl2 = grammar.removeDuplicateAlternatives();
            bl = bl || bl2;
            bl2 = grammar.removeEquivalentProductions();
            boolean bl3 = bl = bl || bl2;
        }
    }

    private void outputFSP(String string, Set set, MyOutput myOutput) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 6;
        String string2 = "\t\t\t\t\t\t";
        int n2 = 4;
        if (this.LateSemantics) {
            myOutput.print("deterministic ");
        }
        myOutput.print("minimal " + string);
        myOutput.print(" = Init");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AltProduction altProduction = (AltProduction)iterator.next();
            myOutput.println(",");
            myOutput.print(altProduction.first);
            int n3 = 1;
            while (n3 < n - altProduction.first.length() / n2) {
                myOutput.print("\t");
                ++n3;
            }
            Iterator iterator2 = altProduction.getAlternatives().iterator();
            if (iterator2.hasNext()) {
                myOutput.print(" = (");
                boolean bl3 = true;
                while (iterator2.hasNext()) {
                    if (bl3) {
                        bl3 = false;
                    } else {
                        myOutput.println(" | ");
                        myOutput.print(string2);
                    }
                    Production production = (Production)iterator2.next();
                    int n4 = 1;
                    while (n4 < production.size()) {
                        String string3 = production.get(n4);
                        if (string3.equals(TAU)) {
                            bl2 = true;
                        }
                        myOutput.print(string3);
                        if (n4 < production.size() - 1) {
                            myOutput.print(" -> ");
                        }
                        ++n4;
                    }
                    boolean bl4 = bl = bl || production.last().equals(FINAL);
                }
                myOutput.print(")");
                continue;
            }
            myOutput.print("=STOP");
        }
        if (bl) {
            myOutput.println(",");
            myOutput.print(FINAL);
            int n5 = 1;
            while (n5 < n - FINAL.length() / n2) {
                myOutput.print("\t");
                ++n5;
            }
            myOutput.println(" = (_tau->STOP)\\{_tau}.");
        } else if (bl2) {
            myOutput.println("\\{_tau}.");
        } else {
            myOutput.println(".");
        }
        myOutput.println("");
    }

    private StringRelation getIsContinuationOfRelation(StringRelation stringRelation, Map map) {
        Iterator iterator = map.keySet().iterator();
        StringRelation stringRelation2 = (StringRelation)stringRelation.clone();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Instance instance = (Instance)map.get(string);
            if (instance.size() > 0) {
                Event event = instance.get(0);
                if (event instanceof ConditionEvent) {
                    if (event.getLabel().equals(INIT)) {
                        stringRelation2.add(event.getLabel(), BEGINPREFIX + string);
                        stringRelation2.add(BEGINPREFIX + string, event.getLabel());
                    } else {
                        stringRelation2.add(CONDPREFIX + event.getLabel(), BEGINPREFIX + string);
                        stringRelation2.add(BEGINPREFIX + string, CONDPREFIX + event.getLabel());
                    }
                }
                if (!((event = instance.get(instance.size() - 1)) instanceof ConditionEvent)) continue;
                if (event.getLabel().equals(INIT)) {
                    stringRelation2.add(ENDPREFIX + string, event.getLabel());
                    stringRelation2.add(event.getLabel(), ENDPREFIX + string);
                    continue;
                }
                stringRelation2.add(ENDPREFIX + string, CONDPREFIX + event.getLabel());
                stringRelation2.add(CONDPREFIX + event.getLabel(), ENDPREFIX + string);
                continue;
            }
            stringRelation2.add(ENDPREFIX + string, BEGINPREFIX + string);
        }
        stringRelation2.transitiveClosure();
        return stringRelation2;
    }

    private StringRelation getCommonIsContinuationOfRelation(Specification specification) {
        Map map = this.buildBMSCRelation(specification);
        StringRelation stringRelation = this.buildRelation(map, specification);
        return stringRelation;
    }

    private Map buildBMSCRelation(Specification specification) {
        HashMap hashMap = new HashMap();
        Iterator iterator = specification.getbMSCs().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            if (!hashMap.containsKey(basicMSC)) {
                hashMap.put(basicMSC, new HashSet());
            }
            Iterator iterator2 = specification.getContinuations(basicMSC).iterator();
            while (iterator2.hasNext()) {
                BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
                if (!hashMap.containsKey(basicMSC2)) {
                    hashMap.put(basicMSC2, new HashSet());
                }
                ((Set)hashMap.get(basicMSC2)).add(basicMSC);
            }
        }
        return hashMap;
    }

    private StringRelation buildRelation(Map map, Specification specification) {
        StringRelation stringRelation = new StringRelation();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            String string = BEGINPREFIX + basicMSC.name;
            String string2 = ENDPREFIX + basicMSC.name;
            stringRelation.add(string, string);
            stringRelation.add(string2, string2);
            Iterator iterator2 = ((Set)map.get(basicMSC)).iterator();
            while (iterator2.hasNext()) {
                BasicMSC basicMSC2 = (BasicMSC)iterator2.next();
                stringRelation.add(string, ENDPREFIX + basicMSC2.name);
            }
            if (!specification.getContinuationsInit().contains(basicMSC)) continue;
            stringRelation.add(string, INIT);
        }
        this.addFinal(stringRelation, specification);
        stringRelation.add(INIT, INIT);
        return stringRelation;
    }

    private void addFinal(StringRelation stringRelation, Specification specification) {
        Iterator iterator = specification.getContinuationsFinal().iterator();
        while (iterator.hasNext()) {
            BasicMSC basicMSC = (BasicMSC)iterator.next();
            stringRelation.add(FINAL, ENDPREFIX + basicMSC.name);
        }
    }
}

