/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import ic.doc.extension.Animator;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import webplugin.Action;
import webplugin.Environment;

public class WebPlugin
extends LTSAPlugin {
    private static final int s_port = 1235;
    private static final String s_datafile = "conditions.xml";
    private List o_toolbar_buttons;
    private ServerThread o_server;
    private Boolean o_running;
    private ServerSocket o_server_socket;

    public WebPlugin() {
    }

    public WebPlugin(LTSA lTSA) {
        super(lTSA);
    }

    public void initialise() {
        this.o_running = new Boolean(false);
        this.o_toolbar_buttons = new ArrayList();
        this.createButtons();
    }

    public String getName() {
        return "Web Animator";
    }

    public boolean addAsTab() {
        return false;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public boolean addMenusToMenuBar() {
        return false;
    }

    public boolean useOwnMenuBar() {
        return false;
    }

    private void createButtons() {
        ImageIcon imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/webplugin/icon/web.gif"));
        LTSAButton lTSAButton = new LTSAButton(imageIcon, "Start animator", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebPlugin.this.toggle_animator();
            }
        });
        this.o_toolbar_buttons.add(lTSAButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggle_animator() {
        Boolean bl = this.o_running;
        synchronized (bl) {
            if (!this.o_running.booleanValue()) {
                LTSA lTSA = this.getLTSA();
                Animator animator = lTSA.getAnimator();
                System.out.println("*** Starting webserver ***");
                try {
                    this.o_server_socket = new ServerSocket(1235);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to create new server socket." + iOException);
                }
                this.o_server = new ServerThread(animator, this.o_server_socket);
                this.o_server.start();
            } else {
                System.out.println("*** Stopping webserver ***");
                try {
                    this.o_server_socket.close();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to close socket." + iOException);
                }
                this.o_server.stop();
            }
            this.o_running = new Boolean(this.o_running == false);
        }
    }

    class RequestHandler
    extends Thread {
        private ServerThread o_server;
        private Socket o_client;
        private Animator o_anim;
        private Environment o_env;
        private BitSet o_actions;
        private String o_role;
        private boolean o_error = false;

        RequestHandler(Socket socket, Animator animator, Environment environment, ServerThread serverThread) {
            this.o_client = socket;
            this.o_anim = animator;
            this.o_env = environment;
            this.o_server = serverThread;
        }

        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.o_client.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() != 0) {
                        if (!string.startsWith("GET")) continue;
                        if (string.indexOf("?") > -1) {
                            this.processrequest(string);
                            this.writeOutXML();
                            return;
                        }
                        String string2 = string.substring(string.indexOf("/"), string.indexOf(" HTTP")).trim();
                        if (!string2.trim().equals("") && !string2.trim().equals("/")) {
                            this.serveFile(string2.substring(1));
                            return;
                        }
                        this.writeOutXML();
                        return;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }

        private boolean userActionPossible() {
            String[] stringArray = this.o_anim.getMenuNames();
            boolean bl = false;
            int n = 1;
            while (n < stringArray.length) {
                Action action = this.o_env.getAction(stringArray[n]);
                bl |= this.o_env.getUserActions().contains(stringArray[n]) && this.o_server.getState().get(n);
                ++n;
            }
            return bl;
        }

        private boolean systemActionPossible() {
            String[] stringArray = this.o_anim.getMenuNames();
            boolean bl = false;
            int n = 1;
            while (n < stringArray.length) {
                bl |= !this.o_env.getUserActions().contains(stringArray[n]) && this.o_server.getState().get(n);
                ++n;
            }
            return bl;
        }

        private boolean actionPossibleForRole(String string) {
            String[] stringArray = this.o_anim.getMenuNames();
            boolean bl = false;
            int n = 1;
            while (n < stringArray.length) {
                bl |= this.isPossibleActionForRole(stringArray[n], string) && this.o_server.getState().get(n);
                ++n;
            }
            return bl;
        }

        private boolean isPossibleActionForRole(String string, String string2) {
            List list = this.o_env.getActionsForRole(string2);
            return list.contains(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void serveFile(String var1_1) {
            block13: {
                block12: {
                    var2_2 = null;
                    var3_3 = null;
                    try {
                        try {
                            var4_4 = new File(WebPlugin.this.getLTSA().getCurrentDirectory() + System.getProperty("file.separator") + var1_1);
                            var5_6 = new byte[10000];
                            var2_2 = new FileInputStream(var4_4);
                            var3_3 = new PrintStream(this.o_client.getOutputStream());
                            if (!var4_4.exists()) {
                                this.notFound(var1_1);
                                var10_7 = null;
                                break block12;
                            }
                            var6_15 = var1_1.substring(var1_1.lastIndexOf("."));
                            var7_16 = var6_15.equals("jpg") != false ? "image/jpeg" : (var6_15.equals("jpeg") != false ? "image/jpeg" : (var6_15.equals("gif") != false ? "image/gif" : (var6_15.equals("png") != false ? "image/png" : (var6_15.equals("html") != false ? "text/html" : "unknown/unknown"))));
                            var3_3.print("HTTP/1.0 200\nContent-Type: " + var7_16 + "\n\n");
                            while ((var8_17 = var2_2.read(var5_6)) > 0) {
                                var3_3.write(var5_6, 0, var8_17);
                            }
                            break block13;
                        }
                        catch (Exception var4_5) {
                            System.err.println(var4_5);
                            var10_9 = null;
                            try {
                                var2_2.close();
                                var3_3.flush();
                                var3_3.close();
                                return;
                            }
                            catch (Exception var11_13) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var9_18) {
                        var10_10 = null;
                        ** try [egrp 2[TRYBLOCK] [5 : 285->300)] { 
lbl36:
                        // 1 sources

                        var2_2.close();
                        var3_3.flush();
                        var3_3.close();
                        throw var9_18;
lbl40:
                        // 1 sources

                        catch (Exception var11_14) {
                            // empty catch block
                        }
                        throw var9_18;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [5 : 285->300)] { 
lbl45:
                // 1 sources

                var2_2.close();
                var3_3.flush();
                var3_3.close();
                return;
lbl49:
                // 1 sources

                catch (Exception var11_11) {
                    // empty catch block
                }
                return;
            }
            var10_8 = null;
            try {}
            catch (Exception var11_12) {}
            var2_2.close();
            var3_3.flush();
            var3_3.close();
            return;
        }

        private void notFound(String string) {
            System.out.println("404 - file " + string + " not found.");
        }

        private void writeOutXML() {
            try {
                Object object;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.o_client.getInputStream()));
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.o_client.getOutputStream()));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
                String[] stringArray = this.o_anim.getMenuNames();
                if (this.o_error) {
                    printWriter2.println("<error />");
                    this.o_error = false;
                } else {
                    printWriter2.println("<state>");
                    printWriter2.println("<header />");
                    printWriter2.println("<env>");
                    object = this.o_env.getDataKeys().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        printWriter2.println("  <" + string + ">" + this.o_env.get(string) + "</" + string + ">");
                    }
                    printWriter2.println("</env>");
                    int n = 0;
                    while (n < stringArray.length - 1) {
                        System.err.println(n + " : " + stringArray[n] + " : " + this.o_server.getState().get(n));
                        ++n;
                    }
                    int n2 = 1;
                    while (n2 < stringArray.length) {
                        if (this.o_server.getState().get(n2) && this.isPossibleActionForRole(stringArray[n2], this.o_role)) {
                            printWriter2.println("<transition>\n  <name>" + stringArray[n2] + "</name>\n  <number>" + n2 + "</number>\n</transition>");
                        }
                        ++n2;
                    }
                    printWriter2.println("<footer />\n</state>");
                }
                printWriter2.flush();
                System.out.println("Generated the following XML : \n" + byteArrayOutputStream.toString());
                object = new ByteArrayOutputStream();
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer(new StreamSource(new File(WebPlugin.this.getLTSA().getCurrentDirectory() + System.getProperty("file.separator") + "stylesheet.xsl")));
                    transformer.transform(new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), new StreamResult((OutputStream)object));
                }
                catch (TransformerException transformerException) {
                    System.err.println(transformerException);
                }
                printWriter.print("HTTP/1.0 200\nContent-Type: text/plain\n\n");
                printWriter.println(((ByteArrayOutputStream)object).toString());
                printWriter.close();
                bufferedReader.close();
                this.o_client.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processrequest(String string) {
            int n;
            int n2;
            ArrayList<Integer> arrayList;
            String[] stringArray;
            int n3 = -1;
            String string2 = string.substring(string.indexOf("?") + 1);
            string2 = string2.substring(0, string2.indexOf(" "));
            StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), "&");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = stringTokenizer.nextToken().split("=");
                if (stringArray.length <= 1) continue;
                stringArray[0] = URLDecoder.decode(stringArray[0]);
                stringArray[1] = URLDecoder.decode(stringArray[1]);
                if (stringArray[0].equals("role")) {
                    this.o_role = stringArray[1];
                }
                if (stringArray[0].indexOf(".") > -1) {
                    stringArray[0] = stringArray[0].substring(0, stringArray[0].indexOf("."));
                }
                arrayList = (ArrayList<Integer>)stringArray[0].toCharArray();
                n2 = 1;
                n = 0;
                while (n < ((ArrayList<E>)arrayList).length) {
                    n2 &= Character.isLetter(arrayList[n]);
                    ++n;
                }
                if (n2 != 0) {
                    this.o_env.put(stringArray[0], stringArray[1]);
                    continue;
                }
                try {
                    n3 = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            stringArray = this.o_anim.getMenuNames();
            if (this.o_anim.isError()) return;
            if (n3 <= -1) return;
            if (!this.o_server.getState().get(n3)) {
                System.out.println("***************************************");
                System.out.println("**              ERROR                **");
                System.out.println("***************************************");
                this.o_error = true;
                return;
            }
            this.o_server.setState(this.o_anim.menuStep(n3));
            arrayList = this.o_env.getAction(stringArray[n3]);
            ((Action)((Object)arrayList)).execute();
            while (this.systemActionPossible()) {
                try {
                    block17: {
                        arrayList = new ArrayList<Integer>();
                        n2 = 1;
                        while (true) {
                            if (n2 >= stringArray.length) {
                                if (arrayList.size() <= 1) break;
                                int n4 = (int)Math.round(Math.random() * (double)arrayList.size());
                                if (n4 < 0) {
                                    n4 = 0;
                                }
                                if (n4 >= arrayList.size()) {
                                    n4 = arrayList.size() - 1;
                                }
                                n = (Integer)arrayList.get(n4);
                                break block17;
                            }
                            Action action = this.o_env.getAction(stringArray[n2]);
                            if (this.o_server.getState().get(n2) && action.isValid() && !this.o_env.getUserActions().contains(stringArray[n2])) {
                                arrayList.add(new Integer(n2));
                            }
                            ++n2;
                        }
                        if (arrayList.size() == 0) {
                            return;
                        }
                        n = (Integer)arrayList.get(0);
                    }
                    this.o_server.setState(this.o_anim.menuStep(n));
                    Action action = this.o_env.getAction(stringArray[n]);
                    action.execute();
                    Thread.sleep(action.getTime());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    class ServerThread
    extends Thread {
        private ServerSocket o_ss;
        private Animator o_anim;
        private BitSet o_actions;
        private Environment o_env;
        private ArrayList o_request_handlers = new ArrayList();

        public ServerThread(Animator animator, ServerSocket serverSocket) {
            this.o_anim = animator;
            this.o_ss = serverSocket;
            this.o_env = new Environment(WebPlugin.this.getLTSA().getCurrentDirectory() + System.getProperty("file.separator") + WebPlugin.s_datafile);
        }

        public synchronized BitSet getState() {
            return this.o_actions;
        }

        public synchronized void setState(BitSet bitSet) {
            this.o_actions = bitSet;
        }

        public void run() {
            this.o_actions = this.o_anim.initialise(null);
            try {
                while (WebPlugin.this.o_running.booleanValue()) {
                    Socket socket = this.o_ss.accept();
                    RequestHandler requestHandler = new RequestHandler(socket, this.o_anim, this.o_env, this);
                    requestHandler.start();
                    Iterator iterator = this.o_request_handlers.iterator();
                    while (iterator.hasNext()) {
                        Thread thread = (Thread)iterator.next();
                        thread.interrupt();
                    }
                    this.o_request_handlers.add(requestHandler);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }
}

