/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.PrefixTree;
import java.util.Enumeration;
import java.util.Vector;

public class Alphabet {
    PrefixTree root = null;
    String[] myAlpha;
    CompactState sm;
    public int maxLevel = 0;

    public Alphabet(CompactState compactState) {
        this.sm = compactState;
        this.myAlpha = new String[compactState.alphabet.length];
        int n = 0;
        while (n < compactState.alphabet.length) {
            this.myAlpha[n] = compactState.alphabet[n];
            ++n;
        }
        this.sort(this.myAlpha, 1);
        int n2 = 1;
        while (n2 < this.myAlpha.length) {
            this.root = PrefixTree.addName(this.root, this.myAlpha[n2]);
            ++n2;
        }
        if (this.root != null) {
            this.maxLevel = this.root.maxDepth();
        }
    }

    public Alphabet(String[] stringArray) {
        if (stringArray.length > 1) {
            this.sort(stringArray, 0);
        }
        int n = 0;
        while (n < stringArray.length) {
            this.root = PrefixTree.addName(this.root, stringArray[n]);
            ++n;
        }
    }

    public Alphabet(Vector vector) {
        this(vector.toArray(new String[vector.size()]));
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return this.root.toString();
    }

    public void print(LTSOutput lTSOutput, int n) {
        lTSOutput.outln("Process:\n\t" + this.sm.name);
        lTSOutput.outln("Alphabet:");
        if (this.root == null) {
            lTSOutput.outln("\t{}");
            return;
        }
        if (n == 0) {
            lTSOutput.outln("\t" + this.root.toString());
        } else {
            lTSOutput.out("\t{ ");
            Vector vector = new Vector();
            this.root.getStrings(vector, n - 1, null);
            Enumeration enumeration = vector.elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!bl) {
                    lTSOutput.out("\t  ");
                }
                if (enumeration.hasMoreElements()) {
                    lTSOutput.outln(string + ",");
                } else {
                    lTSOutput.outln(string);
                }
                bl = false;
            }
            lTSOutput.outln("\t}");
        }
    }

    private void sort(String[] stringArray, int n) {
        int n2 = n;
        while (n2 < stringArray.length - 1) {
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < stringArray.length) {
                if (stringArray[n4].compareTo(stringArray[n3]) < 0) {
                    n3 = n4;
                }
                ++n4;
            }
            String string = stringArray[n2];
            stringArray[n2] = stringArray[n3];
            stringArray[n3] = string;
            ++n2;
        }
    }
}

