/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import java.util.Enumeration;
import java.util.Vector;

public class CounterExample {
    protected CompositeState mach;
    protected Vector errorTrace = null;

    public CounterExample(CompositeState compositeState) {
        this.mach = compositeState;
    }

    public void print(LTSOutput lTSOutput) {
        EventState eventState = new EventState(0, 0);
        int n = EventState.search(eventState, this.mach.composition.states, 0, -1, this.mach.composition.endseq);
        this.errorTrace = null;
        switch (n) {
            case 1: {
                lTSOutput.outln("No deadlocks/errors");
                break;
            }
            case 0: {
                lTSOutput.outln("Trace to DEADLOCK:");
                this.errorTrace = EventState.getPath(eventState.path, this.mach.composition.alphabet);
                this.printPath(lTSOutput, this.errorTrace);
                break;
            }
            case -1: {
                this.errorTrace = EventState.getPath(eventState.path, this.mach.composition.alphabet);
                String string = this.findComponent(this.errorTrace);
                lTSOutput.outln("Trace to property violation in " + string + ":");
                this.printPath(lTSOutput, this.errorTrace);
            }
        }
    }

    private void printPath(LTSOutput lTSOutput, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            lTSOutput.outln("\t" + (String)enumeration.nextElement());
        }
    }

    private String findComponent(Vector vector) {
        Enumeration enumeration = this.mach.machines.elements();
        while (enumeration.hasMoreElements()) {
            CompactState compactState = (CompactState)enumeration.nextElement();
            if (!compactState.isErrorTrace(vector)) continue;
            return compactState.name;
        }
        return "?";
    }

    public Vector getErrorTrace() {
        return this.errorTrace;
    }
}

