/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyHashProg;
import ic.doc.ltsa.lts.MyHashProgEntry;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.MyStack;
import ic.doc.ltsa.lts.ProgressTest;
import ic.doc.ltsa.lts.StateCodec;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class ProgressCheck {
    public static boolean strongFairFlag = true;
    private Automata mach;
    private Stack stack;
    int id = 0;
    int ncomp = 0;
    LTSOutput output;
    int violation = 0;
    boolean hasERROR = false;
    static final int Maxviolation = 10;
    String tnames;
    int accept = 0;
    boolean progress;
    private int sccId;
    private int nTrans;
    Vector errorTrace;
    Vector cycleTrace;

    public ProgressCheck(Automata automata, LTSOutput lTSOutput) {
        this.mach = automata;
        this.output = lTSOutput;
    }

    public void doProgressCheck() {
        this.progress = true;
        this.output.outln("Progress Check...");
        long l = System.currentTimeMillis();
        ProgressTest.initTests(this.mach.getAlphabet());
        this.stack = new Stack();
        this.findCC();
        long l2 = System.currentTimeMillis();
        if (this.hasERROR) {
            this.output.outln("Safety property violation detected - check safety.");
        } else if (this.violation == 0) {
            this.output.outln("No progress violations detected.");
        } else if (this.violation > 10) {
            this.output.outln("More than 10 violations");
        }
        this.output.outln("Progress Check in: " + (l2 - l) + "ms");
    }

    public void doLTLCheck() {
        this.progress = false;
        this.output.outln("LTL Property Check...");
        long l = System.currentTimeMillis();
        this.accept = this.acceptLabel(this.mach.getAlphabet());
        if (this.accept == 0) {
            this.output.outln("No labeled acceptance states.");
            return;
        }
        this.stack = new Stack();
        this.findCC();
        long l2 = System.currentTimeMillis();
        if (this.hasERROR) {
            this.output.outln("Safety property violation detected - check safety.");
        } else if (this.violation == 0) {
            this.output.outln("No LTL Property violations detected.");
        } else if (this.violation > 10) {
            this.output.outln("More than 10 violations");
        }
        this.output.outln("LTL Property Check in: " + (l2 - l) + "ms");
    }

    public int numberComponents() {
        return this.ncomp;
    }

    private void findCC() {
        MyHashProg myHashProg = new MyHashProg();
        MyStack myStack = new MyStack();
        this.mach.setStackChecker(myHashProg);
        this.sccId = 0;
        this.nTrans = 0;
        byte[] byArray = this.mach.START();
        myStack.push(byArray);
        myHashProg.add(byArray, null);
        while (!myStack.empty()) {
            MyHashProgEntry myHashProgEntry = myHashProg.get(myStack.peek());
            while (myHashProgEntry.isReturn || myHashProgEntry.isProcessed) {
                if (myHashProgEntry.isReturn && !myHashProgEntry.isProcessed) {
                    myHashProgEntry.isProcessed = true;
                    if (myHashProgEntry.parent != null) {
                        myHashProgEntry.parent.low = Math.min(myHashProgEntry.parent.low, myHashProgEntry.low);
                    }
                    if (myHashProgEntry.low == myHashProgEntry.dfn && this.component(myHashProg, this.stack, myHashProgEntry.key)) {
                        return;
                    }
                }
                myStack.pop();
                if (myStack.empty()) {
                    this.outStatistics(this.sccId, this.nTrans);
                    return;
                }
                myHashProgEntry = myHashProg.get(myStack.peek());
            }
            myHashProgEntry.dfn = ++this.sccId;
            myHashProgEntry.low = this.sccId;
            if (this.sccId % 10000 == 0) {
                this.outStatistics(this.sccId, this.nTrans);
            }
            this.stack.push(myHashProgEntry.key);
            myHashProgEntry.isReturn = true;
            MyList myList = this.mach.getTransitions(myHashProgEntry.key);
            while (!myList.empty()) {
                ++this.nTrans;
                if (myList.getTo() == null) {
                    this.hasERROR = true;
                    return;
                }
                if (this.accept == 0 || myList.getAction() != this.accept) {
                    MyHashProgEntry myHashProgEntry2 = myHashProg.get(myList.getTo());
                    if (myHashProgEntry2 == null) {
                        myHashProg.add(myList.getTo(), myHashProgEntry);
                        myStack.push(myList.getTo());
                    } else if (myHashProgEntry2.dfn == 0) {
                        myHashProgEntry2.parent = myHashProgEntry;
                        myStack.push(myList.getTo());
                    } else if (myHashProgEntry2.dfn < myHashProgEntry.dfn) {
                        myHashProgEntry.low = Math.min(myHashProgEntry2.dfn, myHashProgEntry.low);
                    }
                }
                myList.next();
            }
        }
        this.outStatistics(this.sccId, this.nTrans);
    }

    private void outhse(MyHashProgEntry myHashProgEntry) {
        this.output.outln("state: " + myHashProgEntry.key + " dfn: " + myHashProgEntry.dfn + " low: " + myHashProgEntry.low + " ret " + myHashProgEntry.isReturn);
    }

    private boolean component(MyHashProg myHashProg, Stack stack, byte[] byArray) {
        Object object;
        byte[] byArray2;
        ++this.ncomp;
        boolean bl = false;
        Stack stack2 = new Stack();
        BitSet bitSet = new BitSet(this.mach.getAlphabet().length);
        do {
            stack2.push(stack.pop());
            byArray2 = (byte[])stack2.peek();
            object = this.mach.getTransitions(byArray2);
            while (!((MyList)object).empty()) {
                int n = ((MyList)object).getAction();
                if (n == this.accept) {
                    bl = true;
                }
                bitSet.set(n);
                ((MyList)object).next();
            }
        } while (!StateCodec.equals(byArray2, byArray));
        if (this.progress) {
            if (this.missing(bitSet) && this.terminalComponent(myHashProg, stack2)) {
                this.outStatistics(this.sccId, this.nTrans);
                this.printCycle(stack2, bitSet, byArray);
                return true;
            }
        } else if (bl) {
            if (!strongFairFlag) {
                if (this.nontrivial(stack2)) {
                    this.outStatistics(this.sccId, this.nTrans);
                    this.printCounterExample(stack2, byArray);
                    return true;
                }
            } else if (this.terminalComponent(myHashProg, stack2)) {
                this.outStatistics(this.sccId, this.nTrans);
                this.printCounterExample(null, byArray);
                return true;
            }
        }
        object = stack2.elements();
        while (object.hasMoreElements()) {
            byte[] byArray3 = (byte[])object.nextElement();
            MyHashProgEntry myHashProgEntry = myHashProg.get(byArray3);
            myHashProgEntry.dfn = Integer.MAX_VALUE;
        }
        return false;
    }

    private boolean missing(BitSet bitSet) {
        int n = this.mach.getAlphabet().length;
        if (ProgressTest.noTests()) {
            int n2 = 1;
            while (n2 < n) {
                if (!bitSet.get(n2)) {
                    return true;
                }
                ++n2;
            }
        } else {
            this.tnames = null;
            Enumeration enumeration = ProgressTest.tests.elements();
            while (enumeration.hasMoreElements()) {
                ProgressTest progressTest = (ProgressTest)enumeration.nextElement();
                if (progressTest.cset == null) {
                    if (!this.contains_none_of(n, bitSet, progressTest.pset)) continue;
                    if (this.tnames == null) {
                        this.tnames = progressTest.name;
                        continue;
                    }
                    this.tnames = this.tnames + " " + progressTest.name;
                    continue;
                }
                if (this.contains_none_of(n, bitSet, progressTest.pset) || !this.contains_none_of(n, bitSet, progressTest.cset)) continue;
                this.tnames = this.tnames == null ? progressTest.name : this.tnames + " " + progressTest.name;
            }
            if (this.tnames != null) {
                return true;
            }
        }
        return false;
    }

    private boolean contains_none_of(int n, BitSet bitSet, BitSet bitSet2) {
        int n2 = 1;
        while (n2 < n) {
            if (bitSet.get(n2) && bitSet2.get(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean terminalComponent(MyHashProg myHashProg, Vector vector) {
        Object object;
        Object object2;
        BitSet bitSet = new BitSet(10001);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (byte[])enumeration.nextElement();
            object = myHashProg.get((byte[])object2);
            bitSet.set(((MyHashProgEntry)object).dfn);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (byte[])object2.nextElement();
            MyList myList = this.mach.getTransitions((byte[])object);
            while (!myList.empty()) {
                if (myList.getTo() == null) {
                    this.hasERROR = true;
                    return false;
                }
                MyHashProgEntry myHashProgEntry = myHashProg.get(myList.getTo());
                if (myHashProgEntry == null) {
                    return false;
                }
                if (myHashProgEntry.dfn == 0) {
                    return false;
                }
                if (myHashProgEntry.dfn == Integer.MAX_VALUE) {
                    return false;
                }
                if (!bitSet.get(myHashProgEntry.dfn)) {
                    return false;
                }
                myList.next();
            }
        }
        return true;
    }

    private boolean inComponent(Vector vector, byte[] byArray) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray2 = (byte[])enumeration.nextElement();
            if (!StateCodec.equals(byArray2, byArray)) continue;
            return true;
        }
        return false;
    }

    private boolean nontrivial(Vector vector) {
        if (vector.size() > 1) {
            return true;
        }
        byte[] byArray = (byte[])vector.elementAt(0);
        MyList myList = this.mach.getTransitions(byArray);
        while (!myList.empty()) {
            int n = myList.getAction();
            if ((n != this.accept || this.accept == 0) && StateCodec.equals(byArray, myList.getTo())) {
                return true;
            }
            myList.next();
        }
        return false;
    }

    private void printSet(BitSet bitSet, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.mach.getAlphabet();
        int n = 1;
        while (n < stringArray.length) {
            if (bl && !bitSet.get(n) || !bl && bitSet.get(n)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        this.output.outln("\t" + new Alphabet(vector).toString());
    }

    Vector getErrorTrace() {
        if (this.errorTrace == null) {
            return null;
        }
        if (this.cycleTrace != null) {
            this.errorTrace.addAll(this.cycleTrace);
            this.errorTrace.addAll(this.cycleTrace);
        }
        return this.errorTrace;
    }

    private void printCycle(Stack stack, BitSet bitSet, byte[] byArray) {
        ++this.violation;
        if (this.violation > 10) {
            return;
        }
        this.errorTrace = this.getRootTrace(byArray);
        if (this.errorTrace == null) {
            return;
        }
        this.cycleTrace = this.getCycleTrace(null, byArray);
        if (ProgressTest.noTests()) {
            this.output.outln("Progress violation for actions: ");
            this.printSet(bitSet, true);
        } else {
            this.output.outln("Progress violation: " + this.tnames);
        }
        this.output.outln("Trace to terminal set of states:");
        this.printTrace(this.errorTrace);
        this.output.outln("Cycle in terminal set:");
        this.printTrace(this.cycleTrace);
        this.output.outln("Actions in terminal set:");
        this.printSet(bitSet, false);
    }

    private void printCounterExample(Stack stack, byte[] byArray) {
        ++this.violation;
        if (this.violation > 10) {
            return;
        }
        this.errorTrace = this.getRootTrace(byArray);
        if (this.errorTrace == null) {
            return;
        }
        this.cycleTrace = this.getCycleTrace(stack, byArray);
        this.output.outln("Violation of LTL property: " + this.mach.getAlphabet()[this.accept]);
        this.output.outln("Trace to terminal set of states:");
        this.printTrace(this.errorTrace);
        this.output.outln("Cycle in terminal set:");
        this.printTrace(this.cycleTrace);
    }

    Vector getRootTrace(byte[] byArray) {
        this.output.outln("Finding trace to cycle...");
        Vector vector = this.mach.getTraceToState(this.mach.START(), byArray);
        if (vector == null) {
            this.hasERROR = true;
        }
        return vector;
    }

    Vector getCycleTrace(Vector vector, byte[] byArray) {
        this.output.outln("Finding trace in cycle...");
        Vector vector2 = null;
        MyList myList = this.mach.getTransitions(byArray);
        byte[] byArray2 = null;
        int n = 0;
        while (!myList.empty()) {
            n = myList.getAction();
            if (n == this.accept && this.accept != 0 || this.stateLabel(n)) {
                myList.next();
                continue;
            }
            byArray2 = myList.getTo();
            if (vector == null || this.inComponent(vector, byArray2)) break;
            myList.next();
        }
        if (byArray2 != null) {
            vector2 = this.mach.getTraceToState(byArray2, byArray);
            vector2.add(0, this.mach.getAlphabet()[n]);
        }
        return vector2;
    }

    private void printTrace(Vector vector) {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.output.outln("\t" + (String)enumeration.nextElement());
        }
    }

    private boolean stateLabel(int n) {
        String string = this.mach.getAlphabet()[n];
        return string.charAt(0) == '_';
    }

    private void outStatistics(int n, int n2) {
        Runtime runtime = Runtime.getRuntime();
        this.output.outln("-- States: " + n + " Transitions: " + n2 + " Memory used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + "K");
    }

    private boolean isAccept(String string) {
        if (string.charAt(0) == '@') {
            return true;
        }
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 > 0) {
            if (string.substring(n, n2).charAt(0) == '@') {
                return true;
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n2 + 1);
        }
        return string.substring(n).charAt(0) == '@';
    }

    private int acceptLabel(String[] stringArray) {
        int n = 1;
        while (n < stringArray.length) {
            if (this.isAccept(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }
}

