/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.Converter;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.GeneralizedBuchiAutomata;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AssertDefinition {
    Symbol name;
    FormulaFactory fac;
    CompositeState cached;
    static Hashtable definitions;

    private AssertDefinition(Symbol symbol, FormulaFactory formulaFactory) {
        this.name = symbol;
        this.fac = formulaFactory;
        this.cached = null;
    }

    public static void put(Symbol symbol, FormulaFactory formulaFactory) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (definitions.put(symbol.toString(), new AssertDefinition(symbol, formulaFactory)) != null) {
            Diagnostics.fatal("duplicate LTL property definition: " + symbol, symbol);
        }
    }

    public static void init() {
        definitions = null;
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Enumeration enumeration = definitions.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static CompositeState compile(LTSOutput lTSOutput, String string) {
        if (definitions == null || string == null) {
            return null;
        }
        AssertDefinition assertDefinition = (AssertDefinition)definitions.get(string);
        if (assertDefinition == null) {
            return null;
        }
        if (assertDefinition.cached != null) {
            return assertDefinition.cached;
        }
        lTSOutput.outln("Formula !" + assertDefinition.name.toString() + " = " + assertDefinition.fac.getFormula());
        GeneralizedBuchiAutomata generalizedBuchiAutomata = new GeneralizedBuchiAutomata(assertDefinition.name.toString(), assertDefinition.fac);
        generalizedBuchiAutomata.translate();
        Graph graph = generalizedBuchiAutomata.Gmake();
        graph = SuperSetReduction.reduce((Graph)graph);
        Graph graph2 = Degeneralize.degeneralize((Graph)graph);
        graph2 = SCCReduction.reduce((Graph)graph2);
        graph2 = SFSReduction.reduce((Graph)graph2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Converter converter = new Converter(assertDefinition.name.toString(), graph2, generalizedBuchiAutomata.getLabelFactory());
        lTSOutput.outln("Buchi automata:");
        converter.printFSP(new PrintStream(byteArrayOutputStream));
        lTSOutput.out(byteArrayOutputStream.toString());
        Vector vector = generalizedBuchiAutomata.getLabelFactory().propProcs;
        vector.add(converter);
        CompositeState compositeState = new CompositeState(converter.name, vector);
        compositeState.hidden = generalizedBuchiAutomata.getLabelFactory().getPrefix();
        compositeState.compose(lTSOutput);
        compositeState.composition.removeNonDetTau();
        Minimiser minimiser = new Minimiser(compositeState.composition, lTSOutput);
        compositeState.composition = minimiser.minimise();
        assertDefinition.cached = compositeState;
        return compositeState;
    }
}

