/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Edge;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import ic.doc.ltsa.lts.ltl.Node;
import java.util.BitSet;
import java.util.SortedSet;

class Transition {
    SortedSet propositions;
    int pointsTo;
    BitSet accepting;
    boolean safe_acc;
    static LabelFactory lf;

    static void setLabelFactory(LabelFactory labelFactory) {
        lf = labelFactory;
    }

    Transition(SortedSet sortedSet, int n, BitSet bitSet, boolean bl) {
        this.propositions = sortedSet;
        this.pointsTo = n;
        this.accepting = new BitSet();
        this.accepting.or(bitSet);
        this.safe_acc = bl;
    }

    int goesTo() {
        return this.pointsTo;
    }

    BitSet computeAccepting(int n) {
        BitSet bitSet = new BitSet(n);
        int n2 = 0;
        while (n2 < n) {
            if (!this.accepting.get(n2)) {
                bitSet.set(n2);
            }
            ++n2;
        }
        return bitSet;
    }

    void print(LTSOutput lTSOutput, int n) {
        if (this.propositions.isEmpty()) {
            lTSOutput.out("LABEL True");
        } else {
            Node.printFormulaSet(lTSOutput, "LABEL", this.propositions);
        }
        lTSOutput.out(" T0 " + this.goesTo());
        if (n > 0) {
            lTSOutput.outln(" Acc " + this.computeAccepting(n));
        } else if (this.safe_acc) {
            lTSOutput.outln(" Acc {0}");
        } else {
            lTSOutput.outln("");
        }
    }

    void Gmake(gov.nasa.arc.ase.util.graph.Node[] nodeArray, gov.nasa.arc.ase.util.graph.Node node, int n) {
        String string = "-";
        String string2 = "-";
        if (!this.propositions.isEmpty()) {
            string = lf.makeLabel(this.propositions);
        }
        Edge edge = new Edge(node, nodeArray[this.pointsTo], string, string2);
        if (n == 0) {
            if (this.safe_acc) {
                edge.setBooleanAttribute("acc0", true);
            }
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (!this.accepting.get(n2)) {
                    edge.setBooleanAttribute("acc" + n2, true);
                }
                ++n2;
            }
        }
    }
}

