/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mscedit.BMSCComponent;
import mscedit.Divider;
import mscedit.Input;
import mscedit.InputOrOutput;
import mscedit.Instance;
import mscedit.Link;
import mscedit.Output;
import mscedit.Visitor;
import org.jdom.Element;

public class BMSC {
    private Element o_root;

    public BMSC() {
    }

    public BMSC(String string) {
        this.o_root = new Element("bmsc").setAttribute("name", string);
    }

    public BMSC(Element element) {
        this.o_root = element;
    }

    public BMSC addInstance(String string) {
        this.o_root.addContent(new Element("instance").setAttribute("name", string));
        return this;
    }

    public Element getXML() {
        return this.o_root;
    }

    public List getInstances() {
        List list = this.o_root.getChildren("instance");
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new Instance((Element)iterator.next()));
        }
        return arrayList;
    }

    public List getLinks() {
        Object object;
        List list = this.getInstances();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector<Link> vector3 = new Vector<Link>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Instance)iterator.next();
            vector.addAll(((Instance)object).getOutputs());
            vector2.addAll(((Instance)object).getInputs());
        }
        object = vector.iterator();
        while (object.hasNext()) {
            Output output = (Output)object.next();
            String string = output.getId();
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                Input input = (Input)iterator2.next();
                String string2 = input.getId();
                if (!string.equals(string2)) continue;
                Link link = new Link(input.getFrom(), output.getTo(), output.getName(), input.getTimeIndex());
                if (input.isNegative()) {
                    link.setNegative();
                }
                vector3.add(link);
            }
        }
        return vector3;
    }

    public List getDividers() {
        List list = this.o_root.getChildren("divider");
        ArrayList<Divider> arrayList = new ArrayList<Divider>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new Divider((Element)iterator.next()));
        }
        return arrayList;
    }

    public BMSC addLink(Link link) {
        this.addLink(link.getFrom(), link.getTo(), link.getName(), link.getTimeIndex());
        this.sortChronologically();
        return this;
    }

    public BMSC addLink(String string, String string2, String string3, int n) {
        this.addOutput(string, string2, string3, n, false);
        this.addInput(string, string2, string3, n, false);
        return this;
    }

    public BMSC addNegativeLink(String string, String string2, String string3, int n) {
        this.addOutput(string, string2, string3, n, true);
        this.addInput(string, string2, string3, n, true);
        this.setNegativeLink(string3);
        return this;
    }

    public BMSC addDivider(int n) {
        this.o_root.addContent(new Element("divider").setAttribute("timeindex", String.valueOf(n)));
        return this;
    }

    public BMSC deleteLink(String string) {
        this.deleteInput(string);
        this.deleteOutput(string);
        return this;
    }

    public BMSC setNegativeLink(String string) {
        this.o_root.setAttribute("negative", string);
        return this;
    }

    public BMSC unsetNegativeLink() {
        this.o_root.removeAttribute("negative");
        return this;
    }

    public String getNegativeLink() {
        String string = this.o_root.getAttribute("negative").getValue();
        if (string != null && !string.equals("")) {
            return string;
        }
        return null;
    }

    public boolean isNegative() {
        String string;
        return this.o_root.getAttribute("negative") != null && (string = this.o_root.getAttribute("negative").getValue()) != null && !string.equals("");
    }

    public String getName() {
        return this.o_root.getAttribute("name").getValue();
    }

    public void setName(String string) {
        this.o_root.setAttribute("name", string);
    }

    public Element asXML() {
        return this.o_root;
    }

    public void apply(Visitor visitor) {
        if (this.isNegative()) {
            visitor.caseANegativeBMSC(this);
        } else {
            visitor.caseABMSC(this);
        }
    }

    private BMSC addOutput(String string, String string2, String string3, int n, boolean bl) {
        List list = this.getInstances();
        Instance instance = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            instance = (Instance)iterator.next();
            if (instance.getName().equals(string)) break;
        }
        Element element = new Element("output");
        element.setAttribute("timeindex", String.valueOf(n));
        if (bl) {
            element.setAttribute("negative", "true");
        }
        element.addContent(new Element("name").setText(string3));
        element.addContent(new Element("to").setText(string2));
        instance.add(element);
        return this;
    }

    private BMSC addInput(String string, String string2, String string3, int n, boolean bl) {
        List list = this.getInstances();
        Instance instance = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            instance = (Instance)iterator.next();
            if (instance.getName().equals(string2)) break;
        }
        Element element = new Element("input");
        element.setAttribute("timeindex", String.valueOf(n));
        if (bl) {
            element.setAttribute("negative", "true");
        }
        element.addContent(new Element("name").setText(string3));
        element.addContent(new Element("from").setText(string));
        instance.add(element);
        return this;
    }

    private void deleteInput(String string) {
        this.delete("input", string);
    }

    private void deleteOutput(String string) {
        this.delete("output", string);
    }

    private void delete(String string, String string2) {
        List list = this.getInstances();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            List list2 = string.equals("output") ? instance.getOutputs() : instance.getInputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                InputOrOutput inputOrOutput = (InputOrOutput)iterator2.next();
                if (!inputOrOutput.getId().equals(string2)) continue;
                instance.remove(inputOrOutput);
                return;
            }
        }
    }

    public void changeLinkName(String string, String string2) {
        List list = this.getInstances();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Instance instance = (Instance)iterator.next();
            List list2 = instance.getInputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = (Input)iterator2.next();
                if (!((InputOrOutput)object).getId().equals(string)) continue;
                ((InputOrOutput)object).setName(string2);
                break;
            }
            list2 = instance.getOutputs();
            object = list2.iterator();
            while (object.hasNext()) {
                Output output = (Output)object.next();
                if (!output.getId().equals(string)) continue;
                output.setName(string2);
                continue block0;
            }
        }
    }

    public void moveDivider(int n, int n2) {
        List list = this.getDividers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Divider divider = (Divider)iterator.next();
            if (divider.getTimeIndex() != n) continue;
            divider.setTimeIndex(n2);
            break;
        }
    }

    public void deleteDivider(int n) {
        List list = this.o_root.getChildren("divider");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (Integer.parseInt(element.getAttribute("timeindex").getValue()) != n) continue;
            iterator.remove();
            break;
        }
    }

    public void deleteInstance(String string) {
        List list = this.o_root.getChildren("instance");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Instance instance = new Instance((Element)iterator.next());
            if (!instance.getName().equals(string)) continue;
            List list2 = instance.getInputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = (Input)iterator2.next();
                if (((InputOrOutput)object).getFrom() == null || !string.equals(((InputOrOutput)object).getFrom())) continue;
                iterator2.remove();
            }
            object = instance.getOutputs();
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                Output output = (Output)iterator3.next();
                if (output.getTo() == null || !string.equals(output.getTo())) continue;
                iterator3.remove();
            }
            iterator.remove();
        }
    }

    public void changeTimeIndex(String string, int n) {
        List list = this.getInstances();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Instance instance = (Instance)iterator.next();
            List list2 = instance.getInputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = (Input)iterator2.next();
                if (!((InputOrOutput)object).getId().equals(string)) continue;
                ((InputOrOutput)object).setTimeIndex(n);
                break;
            }
            list2 = instance.getOutputs();
            object = list2.iterator();
            while (object.hasNext()) {
                Output output = (Output)object.next();
                if (!output.getId().equals(string)) continue;
                output.setTimeIndex(n);
                continue block0;
            }
        }
    }

    public void reverseLink(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        List list = this.getInstances();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            List list2 = instance.getOutputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Output output = (Output)iterator2.next();
                if (!output.getId().equals(string)) continue;
                string4 = output.getName();
                string2 = instance.getName();
                string3 = output.getTo();
                n = output.getTimeIndex();
                continue block0;
            }
        }
        this.deleteLink(string);
        this.addLink(string3, string2, string4, n);
    }

    public void negateLastMessage() {
        List list = this.getLinks();
        if (list.size() < 1) {
            return;
        }
        Link link = (Link)list.get(0);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Link link2 = (Link)iterator.next();
            if (link2.getTimeIndex() <= link.getTimeIndex()) continue;
            link = link2;
        }
        this.negateLink(link.getId());
        this.changeTimeIndex(link.getId(), link.getTimeIndex() + 1);
        this.addDivider(link.getTimeIndex());
    }

    public void negateLink(String string) {
        List list = this.getInstances();
        String string2 = "";
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Instance instance = (Instance)iterator.next();
            List list2 = instance.getInputs();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object = (Input)iterator2.next();
                if (!((InputOrOutput)object).getId().equals(string)) continue;
                if (((InputOrOutput)object).isNegative()) {
                    ((InputOrOutput)object).setNegative(false);
                    break;
                }
                ((InputOrOutput)object).setNegative(true);
                string2 = ((InputOrOutput)object).getName();
                break;
            }
            list2 = instance.getOutputs();
            object = list2.iterator();
            while (object.hasNext()) {
                Output output = (Output)object.next();
                if (!output.getId().equals(string)) continue;
                if (output.isNegative()) {
                    output.setNegative(false);
                    continue block0;
                }
                output.setNegative(true);
                continue block0;
            }
        }
        if (!this.isNegative()) {
            this.setNegativeLink(string2);
        } else {
            this.unsetNegativeLink();
        }
    }

    public void tidy() {
        List list = this.getLinks();
        list.addAll(this.getDividers());
        int n = this.getHighestTimeIndex(list);
        int n2 = 0;
        int n3 = 0;
        while (n3 <= n) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BMSCComponent bMSCComponent = (BMSCComponent)iterator.next();
                if (bMSCComponent.getTimeIndex() != n3 || n3 <= n2) continue;
                if (bMSCComponent instanceof Link) {
                    this.changeTimeIndex(((Link)bMSCComponent).getId(), n2 + 1);
                } else {
                    bMSCComponent.setTimeIndex(n2 + 1);
                }
                bl = true;
            }
            if (bl) {
                ++n2;
            }
            ++n3;
        }
    }

    public int getLastTimeIndex() {
        return this.getHighestTimeIndex(this.getLinks());
    }

    private int getHighestTimeIndex(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = ((BMSCComponent)iterator.next()).getTimeIndex();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void sortChronologically() {
        List list = this.getInstances();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Collections.sort(((Element)iterator.next()).getChildren(), new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    int n2 = Integer.parseInt(((Element)object).getAttribute("timeindex").getValue());
                    if (n2 > (n = Integer.parseInt(((Element)object2).getAttribute("timeindex").getValue()))) {
                        return 1;
                    }
                    if (n2 < n) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
    }
}

