/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.event.MouseInputAdapter;
import mscedit.BMSCEditorCanvas;
import mscedit.DividerGraphic;
import mscedit.Glyph;

class CanvasMouseListener
extends MouseInputAdapter {
    private BMSCEditorCanvas o_canvas;
    private int o_clicks = 0;
    private Glyph o_moving;

    public CanvasMouseListener(BMSCEditorCanvas bMSCEditorCanvas) {
        this.o_canvas = bMSCEditorCanvas;
        this.o_moving = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.o_canvas.inAddDividerMode()) {
                this.o_canvas.addDivider((int)((double)mouseEvent.getY() / Glyph.getScale()));
            } else if (this.o_canvas.inAddLinkMode()) {
                String string = this.o_canvas.getInstanceAt(mouseEvent.getX(), mouseEvent.getY());
                if (string == null) {
                    return;
                }
                if (this.o_clicks == 0) {
                    this.o_canvas.setOldSelection(string);
                    Graphics2D graphics2D = (Graphics2D)this.o_canvas.getGraphics();
                    double d = Glyph.getScale();
                    graphics2D.setColor(Color.red);
                    graphics2D.fill(new Ellipse2D.Float((int)((((double)mouseEvent.getX() / d - 10.0) / 100.0 * 100.0 + 10.0) * d), (int)((((double)mouseEvent.getY() / d - 50.0) / 25.0 * 25.0 + 50.0) * d), 5.0f, 5.0f));
                } else {
                    if (string.equals(this.o_canvas.getOldSelection())) {
                        return;
                    }
                    if (this.o_canvas.addPositive()) {
                        this.o_canvas.addLink(this.o_canvas.getOldSelection(), string, (int)((double)mouseEvent.getY() / Glyph.getScale()));
                    } else {
                        this.o_canvas.addNegativeLink(this.o_canvas.getOldSelection(), string, (int)((double)mouseEvent.getY() / Glyph.getScale()));
                    }
                }
                this.o_clicks = 1 - this.o_clicks;
            } else {
                this.o_canvas.setSelection(this.o_canvas.getMessageAt(mouseEvent.getX(), mouseEvent.getY()));
            }
        }
        if (mouseEvent.getButton() == 3) {
            this.o_canvas.showPopup(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.o_moving == null) {
            this.o_moving = this.o_canvas.getMessageAt(mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.o_moving.moveTo((int)((double)mouseEvent.getY() / Glyph.getScale()));
            this.o_canvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.o_moving != null) {
            this.o_moving.moveTo(mouseEvent.getY());
            if (this.o_moving instanceof DividerGraphic) {
                this.o_canvas.moveDivider(Integer.parseInt(this.o_moving.getId()), ((int)((double)mouseEvent.getY() / Glyph.getScale()) - 50) / 25);
            } else {
                this.o_canvas.moveMessage(this.o_moving.getId(), ((int)((double)mouseEvent.getY() / Glyph.getScale()) - 50) / 25);
            }
            this.o_moving = null;
            this.o_canvas.rebuild();
        }
    }
}

