/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mscedit.BMSCGraphic;
import mscedit.EditorCanvas;
import mscedit.Glyph;
import mscedit.HMSC;
import mscedit.Transition;
import mscedit.TransitionGraphic;
import mscedit.XMLGui;
import org.jdom.Element;

class HMSCEditorCanvas
extends EditorCanvas {
    private HMSC o_msc;
    private Vector o_bmsc_glyphs;
    private Vector o_transition_glyphs;

    public HMSCEditorCanvas() {
    }

    public HMSCEditorCanvas(XMLGui xMLGui) {
        this.o_gui = xMLGui;
        this.o_msc = new HMSC();
        this.rebuild();
    }

    public HMSCEditorCanvas(XMLGui xMLGui, HMSC hMSC) {
        this.o_gui = xMLGui;
        this.o_msc = hMSC;
        this.rebuild();
    }

    public Dimension getPreferredSize() {
        double d = Glyph.getScale();
        if (this.o_bmsc_glyphs == null) {
            return new Dimension(500, 400);
        }
        if (this.o_bmsc_glyphs.size() < 5) {
            return new Dimension((int)(d * 500.0), (int)(d * 400.0));
        }
        if (this.o_bmsc_glyphs.size() < 12) {
            return new Dimension((int)(d * 750.0), (int)(d * 600.0));
        }
        return new Dimension(4000, 4000);
    }

    public HMSC getHMSC() {
        return this.o_msc;
    }

    public void fileDraw(Graphics graphics) {
        this.paintComponent(graphics);
    }

    void changeLinkName(String string, String string2) {
    }

    void reverseSelectedLink() {
    }

    void negateSelectedLink() {
    }

    public void rebuild() {
        this.o_bmsc_glyphs = new Vector();
        this.o_transition_glyphs = new Vector();
        if (this.o_msc != null) {
            Element element;
            Object object;
            List list = this.o_msc.getBMSCs();
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    element = (Element)object.next();
                    this.o_bmsc_glyphs.add(new BMSCGraphic(element.getAttribute("name").getValue(), Integer.parseInt(element.getAttribute("x").getValue()), Integer.parseInt(element.getAttribute("y").getValue())));
                }
            }
            if ((object = this.o_msc.getTransitions()) != null) {
                element = object.iterator();
                while (element.hasNext()) {
                    Transition transition = (Transition)element.next();
                    String string = transition.getTo();
                    String string2 = transition.getFrom();
                    this.o_transition_glyphs.add(new TransitionGraphic(string2, string, this.locate(string2), this.locate(string)));
                }
            }
        }
        this.repaint();
    }

    void moveBMSC(String string, int n, int n2) {
        this.o_msc.moveBMSC(string, n, n2);
    }

    private Point locate(String string) {
        Iterator iterator = this.o_bmsc_glyphs.iterator();
        while (iterator.hasNext()) {
            BMSCGraphic bMSCGraphic = (BMSCGraphic)iterator.next();
            if (!bMSCGraphic.getName().equals(string)) continue;
            return bMSCGraphic.getCentre();
        }
        return null;
    }

    public void addBMSC(String string, int n, int n2) {
        this.o_msc.addBMSC(string, n, n2);
    }

    void addTransition(String string, String string2) {
        this.o_msc.addTransition(string, string2);
        this.setCursor(new Cursor(0));
        this.rebuild();
    }

    void addInstance(String string) {
    }

    void addLink(String string, String string2, String string3, int n) {
    }

    void addNegativeLink(String string, String string2, String string3, int n) {
    }

    void delete() {
        if (this.o_selected != null && this.o_selected instanceof TransitionGraphic) {
            this.o_msc.deleteTransition(((TransitionGraphic)this.o_selected).getFrom(), ((TransitionGraphic)this.o_selected).getTo());
        } else if (this.o_selected != null && this.o_selected instanceof BMSCGraphic) {
            this.o_gui.deleteBMSC(((BMSCGraphic)this.o_selected).getName());
        }
        this.rebuild();
    }

    void deleteBMSC(String string) {
        this.o_msc.deleteBMSC(string);
    }

    void tidy() {
    }

    boolean inAddLinkMode() {
        return this.o_gui.inAddLinkMode();
    }

    void setAddLinkMode(boolean bl) {
        this.o_gui.setAddLinkMode(bl);
    }

    String getBMSCAt(int n, int n2) {
        BMSCGraphic bMSCGraphic = this.getBMSCGraphicAt(n, n2);
        if (bMSCGraphic != null) {
            return bMSCGraphic.getName();
        }
        return null;
    }

    BMSCGraphic getBMSCGraphicAt(int n, int n2) {
        Iterator iterator = this.o_bmsc_glyphs.iterator();
        while (iterator.hasNext()) {
            BMSCGraphic bMSCGraphic = (BMSCGraphic)iterator.next();
            if (!bMSCGraphic.contains(n, n2)) continue;
            return bMSCGraphic;
        }
        return null;
    }

    TransitionGraphic getTransitionAt(int n, int n2) {
        Iterator iterator = this.o_transition_glyphs.iterator();
        while (iterator.hasNext()) {
            TransitionGraphic transitionGraphic = (TransitionGraphic)iterator.next();
            if (!transitionGraphic.contains(n, n2)) continue;
            return transitionGraphic;
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics2D.setColor(Color.black);
        Iterator iterator = this.o_bmsc_glyphs.iterator();
        while (iterator.hasNext()) {
            object = (Glyph)iterator.next();
            if (object == this.o_selected) {
                graphics.setColor(Color.red);
                ((Glyph)object).draw(graphics);
                graphics.setColor(Color.black);
                continue;
            }
            ((Glyph)object).draw(graphics);
        }
        object = this.o_transition_glyphs.iterator();
        while (object.hasNext()) {
            Glyph glyph = (Glyph)object.next();
            if (glyph == this.o_selected) {
                graphics.setColor(Color.red);
                glyph.draw(graphics);
                graphics.setColor(Color.black);
                continue;
            }
            glyph.draw(graphics);
        }
    }
}

