/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.extension.Exportable;
import ic.doc.extension.LTSA;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mscedit.BMSC;
import mscedit.BMSCEditorCanvas;
import mscedit.CanvasMouseListener;
import mscedit.EditorCanvas;
import mscedit.ExampleFileFilter;
import mscedit.Glyph;
import mscedit.GuiEventListener;
import mscedit.HMSC;
import mscedit.HMSCCanvasMouseListener;
import mscedit.HMSCEditorCanvas;
import mscedit.Instance;
import mscedit.Link;
import mscedit.Specification;
import mscedit.XMLUtil;

public class XMLGui
extends JPanel {
    private HMSCEditorCanvas o_hmsc_canvas;
    private Specification o_spec;
    private JTabbedPane o_tabbed_pane;
    private JToolBar o_toolbar;
    private JPopupMenu o_popup;
    private List o_editors = new ArrayList();
    private JButton o_pointer;
    private JButton o_delete;
    private JButton o_newmsc;
    private JButton o_newinst;
    private JButton o_newmsg;
    private JButton o_newtrans;
    private JButton o_newnegmsg;
    private JButton o_newdiv;
    private boolean o_positive = true;
    private boolean o_add_link_mode = false;
    private boolean o_add_divider_mode = false;
    private String o_link_name = "";
    private int o_neg_count = 0;
    private HashSet o_message_alphabet;
    private List o_instance_alphabet;
    private LTSA o_ltsa;

    public XMLGui() {
        this.o_spec = new Specification();
        this.o_tabbed_pane = new JTabbedPane();
        this.o_hmsc_canvas = new HMSCEditorCanvas(this);
        this.o_spec.addHMSC(this.o_hmsc_canvas.getHMSC());
        this.o_spec.addBMSC(new BMSC("init"));
        this.o_hmsc_canvas.addBMSC("init", 50, 30);
        this.o_hmsc_canvas.rebuild();
        HMSCCanvasMouseListener hMSCCanvasMouseListener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
        this.o_hmsc_canvas.addMouseListener(hMSCCanvasMouseListener);
        this.o_hmsc_canvas.addMouseMotionListener(hMSCCanvasMouseListener);
        this.o_toolbar = new JToolBar("MSC Editor");
        this.populateMenus();
        this.populateToolBar();
        this.o_instance_alphabet = new ArrayList();
        this.o_message_alphabet = new HashSet();
        this.o_hmsc_canvas.setPreferredSize(new Dimension(500, 400));
        this.setLocation(150, 150);
        this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
        this.o_editors.add(this.o_hmsc_canvas);
        this.o_tabbed_pane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                XMLGui.this.enableButtons();
            }
        });
        this.enableButtons();
        this.setLayout(new BorderLayout());
        this.add((Component)this.o_tabbed_pane, "Center");
        this.add((Component)this.o_toolbar, "South");
    }

    private void enableButtons() {
        if (this.o_tabbed_pane.getSelectedIndex() == 0) {
            this.o_newmsc.setEnabled(true);
            this.o_newtrans.setEnabled(true);
            this.o_newmsg.setEnabled(false);
            this.o_newnegmsg.setEnabled(false);
            this.o_newdiv.setEnabled(false);
            this.o_newinst.setEnabled(false);
        } else {
            this.o_newmsc.setEnabled(true);
            this.o_newtrans.setEnabled(false);
            this.o_newmsg.setEnabled(true);
            this.o_newnegmsg.setEnabled(true);
            this.o_newdiv.setEnabled(true);
            this.o_newinst.setEnabled(true);
        }
    }

    public Specification getSpecification() {
        return this.o_spec;
    }

    void populateMenus() {
        this.o_popup = new JPopupMenu("Message");
        JMenuItem jMenuItem = new JMenuItem("Rename message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.renameMessage();
            }
        });
        this.o_popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Reverse arrow");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.reverseLink();
            }
        });
        this.o_popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.deleteMessage();
            }
        });
        this.o_popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Tidy");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.tidyChart();
            }
        });
        this.o_popup.add(jMenuItem);
    }

    void setBigFont(boolean bl) {
        if (bl) {
            Glyph.setFont(new Font("Terminal", 1, 15));
            Glyph.setScale(1.5);
        } else {
            Glyph.setFont(new Font("Terminal", 0, 11));
            Glyph.setScale(1.0);
        }
        Iterator iterator = this.o_editors.iterator();
        while (iterator.hasNext()) {
            EditorCanvas editorCanvas = (EditorCanvas)iterator.next();
            editorCanvas.rebuild();
        }
    }

    void showToolBar(boolean bl) {
        if (bl) {
            this.add("South", this.o_toolbar);
        } else {
            this.remove(this.o_toolbar);
        }
    }

    void newMSC() {
        String string = JOptionPane.showInputDialog(null, "Enter a name for the MSC:", "New MSC", 3);
        if (string != null && !string.trim().equals("")) {
            if (this.existsMSCCalled(string) || string.trim().equals("init")) {
                JOptionPane.showMessageDialog(null, "MSC called " + string + " already exists.", "Duplicate name", 0);
                return;
            }
            string = this.capitalise(string);
            BMSCEditorCanvas bMSCEditorCanvas = new BMSCEditorCanvas(this, string);
            CanvasMouseListener canvasMouseListener = new CanvasMouseListener(bMSCEditorCanvas);
            bMSCEditorCanvas.addMouseListener(canvasMouseListener);
            bMSCEditorCanvas.addMouseMotionListener(canvasMouseListener);
            this.o_tabbed_pane.addTab(string, null, new JScrollPane(bMSCEditorCanvas), "Basic Message Sequence Chart");
            this.o_editors.add(bMSCEditorCanvas);
            this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(string));
            Iterator iterator = this.o_instance_alphabet.iterator();
            while (iterator.hasNext()) {
                bMSCEditorCanvas.addInstance((String)iterator.next());
            }
            this.o_spec.addBMSC(bMSCEditorCanvas.getBMSC());
            bMSCEditorCanvas.rebuild();
            this.o_hmsc_canvas.addBMSC(string, (this.o_tabbed_pane.getTabCount() - 2) % 4 * 120 + 50, (this.o_tabbed_pane.getTabCount() - 2) / 4 * 100 + 130);
            this.o_hmsc_canvas.rebuild();
        }
    }

    public void addBMSC(BMSC bMSC) {
        BMSCEditorCanvas bMSCEditorCanvas = new BMSCEditorCanvas(this, bMSC);
        CanvasMouseListener canvasMouseListener = new CanvasMouseListener(bMSCEditorCanvas);
        bMSCEditorCanvas.addMouseListener(canvasMouseListener);
        bMSCEditorCanvas.addMouseMotionListener(canvasMouseListener);
        this.o_tabbed_pane.addTab(bMSC.getName(), null, new JScrollPane(bMSCEditorCanvas), "Implied Scenario");
        this.o_editors.add(bMSCEditorCanvas);
        this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(bMSC.getName()));
        this.o_spec.addBMSC(bMSCEditorCanvas.getBMSC());
        bMSCEditorCanvas.rebuild();
    }

    public void addBMSCtoHMSC(BMSC bMSC) {
        this.o_hmsc_canvas.addBMSC(bMSC.getName(), (this.o_tabbed_pane.getTabCount() - 2) % 4 * 120 + 50, (this.o_tabbed_pane.getTabCount() - 2) / 4 * 100 + 130);
        this.o_hmsc_canvas.rebuild();
    }

    File fileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser(new File(this.o_ltsa.getCurrentDirectory()));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("xml");
        exampleFileFilter.setDescription("XML files");
        jFileChooser.addChoosableFileFilter(exampleFileFilter);
        jFileChooser.setApproveButtonText(string);
        jFileChooser.setDialogTitle(string);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.o_ltsa.setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    void newSpec() {
        this.o_spec = new Specification();
        this.o_tabbed_pane.removeAll();
        this.o_editors.clear();
        this.o_hmsc_canvas = new HMSCEditorCanvas(this);
        this.o_spec.addHMSC(this.o_hmsc_canvas.getHMSC());
        this.o_spec.addBMSC(new BMSC("init"));
        this.o_hmsc_canvas.addBMSC("init", 50, 30);
        this.o_hmsc_canvas.rebuild();
        HMSCCanvasMouseListener hMSCCanvasMouseListener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
        this.o_hmsc_canvas.addMouseListener(hMSCCanvasMouseListener);
        this.o_hmsc_canvas.addMouseMotionListener(hMSCCanvasMouseListener);
        this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
        this.o_editors.add(this.o_hmsc_canvas);
        this.enableButtons();
        this.o_neg_count = 0;
        this.o_message_alphabet = new HashSet();
        this.o_instance_alphabet = new ArrayList();
    }

    void openFile(File file) {
        if (file != null) {
            this.o_spec = new Specification(XMLUtil.loadFromFile(file));
            this.o_tabbed_pane.removeAll();
            this.o_editors.clear();
            HMSC hMSC = this.o_spec.getHMSC();
            this.o_hmsc_canvas = new HMSCEditorCanvas(this, hMSC);
            HMSCCanvasMouseListener hMSCCanvasMouseListener = new HMSCCanvasMouseListener(this.o_hmsc_canvas);
            this.o_hmsc_canvas.addMouseListener(hMSCCanvasMouseListener);
            this.o_hmsc_canvas.addMouseMotionListener(hMSCCanvasMouseListener);
            this.o_tabbed_pane.addTab("hMSC", null, new JScrollPane(this.o_hmsc_canvas), "High-Level Message Sequence Chart");
            this.o_editors.add(this.o_hmsc_canvas);
            this.o_neg_count = 0;
            List list = this.o_spec.getBMSCs();
            this.o_instance_alphabet = new ArrayList();
            this.o_message_alphabet = new HashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                BMSC bMSC = (BMSC)iterator.next();
                if (bMSC.getName().equals("init")) continue;
                if (bMSC.isNegative()) {
                    ++this.o_neg_count;
                }
                BMSCEditorCanvas bMSCEditorCanvas = new BMSCEditorCanvas(this, bMSC);
                CanvasMouseListener canvasMouseListener = new CanvasMouseListener(bMSCEditorCanvas);
                bMSCEditorCanvas.addMouseListener(canvasMouseListener);
                bMSCEditorCanvas.addMouseMotionListener(canvasMouseListener);
                this.o_tabbed_pane.addTab(bMSC.getName(), null, new JScrollPane(bMSCEditorCanvas), "Basic Message Sequence Chart");
                this.o_editors.add(bMSCEditorCanvas);
                List list2 = bMSC.getInstances();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    object = ((Instance)iterator2.next()).getName();
                    if (this.o_instance_alphabet.contains(object)) continue;
                    this.o_instance_alphabet.add(object);
                }
                object = bMSC.getLinks();
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    this.o_message_alphabet.add(((Link)iterator3.next()).getName());
                }
            }
        }
        this.o_hmsc_canvas.rebuild();
        this.updateTitleBar();
    }

    void saveFile() {
        File file = this.fileChooser("Save");
        if (file != null) {
            XMLUtil.saveToFile(this.o_spec.asXML(), file);
        }
    }

    void saveFile(FileOutputStream fileOutputStream) {
        if (fileOutputStream != null) {
            XMLUtil.saveToFile(this.o_spec.asXML(), fileOutputStream);
        }
    }

    void newInstance() {
        if (this.o_tabbed_pane.getTabCount() == 0) {
            this.newMSC();
        }
        Object[] objectArray = new Object[this.o_instance_alphabet.toArray().length + 1];
        System.arraycopy(this.o_instance_alphabet.toArray(), 0, objectArray, 1, this.o_instance_alphabet.toArray().length);
        Arrays.sort(objectArray, 1, objectArray.length);
        objectArray[0] = "New...";
        String string = (String)JOptionPane.showInputDialog(null, "Select instance name:", "New Instance", 3, null, objectArray, "New...");
        if (string != null && string.equals("New...")) {
            string = JOptionPane.showInputDialog(null, "Enter instance name:", "New Instance", 3);
        }
        if (string != null && !string.trim().equals("")) {
            BMSCEditorCanvas bMSCEditorCanvas = (BMSCEditorCanvas)this.getCurrentEditor();
            Iterator iterator = bMSCEditorCanvas.getBMSC().getInstances().iterator();
            while (iterator.hasNext()) {
                if (!((Instance)iterator.next()).getName().equals(string)) continue;
                JOptionPane.showMessageDialog(null, "Instance called " + string + " already exists.", "Duplicate name", 0);
                return;
            }
            if (!this.o_instance_alphabet.contains(string = this.capitalise(string))) {
                this.o_instance_alphabet.add(string);
            }
            bMSCEditorCanvas.addInstance(string);
            bMSCEditorCanvas.rebuild();
        }
    }

    void newMessage(boolean bl) {
        if (this.o_tabbed_pane.getSelectedIndex() > 0) {
            Object[] objectArray = new Object[this.o_message_alphabet.toArray().length + 1];
            System.arraycopy(this.o_message_alphabet.toArray(), 0, objectArray, 1, this.o_message_alphabet.toArray().length);
            Arrays.sort(objectArray, 1, objectArray.length);
            objectArray[0] = "New...";
            String string = (String)JOptionPane.showInputDialog(null, "Select link name:", "New Link", 3, null, objectArray, "New...");
            if (string != null && string.equals("New...")) {
                string = JOptionPane.showInputDialog(null, "Enter link name:", "New Link", 3);
            }
            if (string != null && !string.trim().equals("")) {
                if (this.o_message_alphabet.contains(string = this.smallCaps(string))) {
                    Object object;
                    List list = this.getSpecification().getAllLinks();
                    String string2 = "";
                    String string3 = "";
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        object = (Link)iterator.next();
                        if (!((Link)object).getName().equals(string)) continue;
                        string2 = ((Link)object).getFrom();
                        string3 = ((Link)object).getTo();
                        break;
                    }
                    object = (BMSCEditorCanvas)this.getCurrentEditor();
                    int n = ((BMSCEditorCanvas)object).getBMSC().getLastTimeIndex() + 1;
                    ((BMSCEditorCanvas)object).addLink(string2, string3, string, n);
                    ((BMSCEditorCanvas)object).rebuild();
                    return;
                }
                this.o_message_alphabet.add(string);
                this.o_positive = bl;
                this.o_add_link_mode = true;
                this.o_link_name = string;
            }
            this.setCursor(new Cursor(1));
        }
    }

    void newTransition() {
        if (this.o_tabbed_pane.getSelectedIndex() == 0) {
            this.o_add_link_mode = true;
            this.setCursor(new Cursor(1));
        }
    }

    void newDivider() {
        this.o_add_link_mode = false;
        this.o_add_divider_mode = true;
        this.setCursor(new Cursor(1));
    }

    void deleteMessage() {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.delete();
        editorCanvas.rebuild();
    }

    void deleteBMSC(String string) {
        HMSCEditorCanvas hMSCEditorCanvas = (HMSCEditorCanvas)this.o_editors.get(0);
        hMSCEditorCanvas.deleteBMSC(string);
        hMSCEditorCanvas.rebuild();
        this.o_editors.remove(this.o_tabbed_pane.indexOfTab(string));
        this.o_tabbed_pane.removeTabAt(this.o_tabbed_pane.indexOfTab(string));
    }

    void renameMessage() {
        String string = JOptionPane.showInputDialog(null, "Enter new name:", "Rename Message", 3);
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.changeLinkName(editorCanvas.getSelectionId(), string);
        editorCanvas.rebuild();
    }

    void reverseLink() {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.reverseSelectedLink();
        editorCanvas.rebuild();
    }

    void negateMessage() {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.negateSelectedLink();
        editorCanvas.rebuild();
    }

    void tidyChart() {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.tidy();
        editorCanvas.rebuild();
    }

    void removeFromMsgAlphabet(String string) {
        this.o_message_alphabet.remove(string);
    }

    public boolean inAddLinkMode() {
        return this.o_add_link_mode;
    }

    public boolean inAddDividerMode() {
        return this.o_add_divider_mode;
    }

    public void setAddDividerMode(boolean bl) {
        this.o_add_divider_mode = bl;
    }

    public boolean addPositive() {
        return this.o_positive;
    }

    public void setAddLinkMode(boolean bl) {
        this.o_add_link_mode = bl;
    }

    public String getLinkName() {
        return this.o_link_name;
    }

    public List getInstanceAlphabet() {
        return this.o_instance_alphabet;
    }

    public void addLink(String string, String string2, int n) {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.addLink(string, string2, this.o_link_name, n);
        this.o_add_link_mode = false;
        this.setCursor(new Cursor(0));
        editorCanvas.rebuild();
    }

    public void addNegativeLink(String string, String string2, int n) {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.addNegativeLink(string, string2, this.o_link_name, n);
        this.o_add_link_mode = false;
        this.o_positive = true;
        editorCanvas.rebuild();
    }

    int getNegCount() {
        return this.o_neg_count;
    }

    void setNegCount(int n) {
        this.o_neg_count = n;
    }

    void updateTitleBar() {
    }

    public void redrawCurrentCanvas() {
        EditorCanvas editorCanvas = this.getCurrentEditor();
        editorCanvas.rebuild();
    }

    public void showPopup(MouseEvent mouseEvent) {
        this.o_popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void populateToolBar() {
        this.o_pointer = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/pointer.gif")));
        this.o_pointer.setToolTipText("Select");
        this.o_pointer.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLGui.this.o_add_link_mode = false;
                XMLGui.this.o_add_divider_mode = false;
                EditorCanvas editorCanvas = XMLGui.this.getCurrentEditor();
                editorCanvas.setSelection(null);
                editorCanvas.setOldSelection(null);
                editorCanvas.rebuild();
                XMLGui.this.setCursor(new Cursor(0));
            }
        });
        this.o_toolbar.add(this.o_pointer);
        this.o_delete = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/delete.gif")));
        this.o_delete.setToolTipText("Delete");
        this.o_delete.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.deleteMessage();
            }
        });
        this.o_toolbar.add(this.o_delete);
        this.o_newmsc = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newmsc.gif")));
        this.o_newmsc.setToolTipText("New bMSC");
        this.o_newmsc.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMSC();
            }
        });
        this.o_toolbar.add(this.o_newmsc);
        this.o_newtrans = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newlink.gif")));
        this.o_newtrans.setToolTipText("New transition");
        this.o_newtrans.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newTransition();
            }
        });
        this.o_toolbar.add(this.o_newtrans);
        this.o_newinst = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newinst.gif")));
        this.o_newinst.setToolTipText("New instance");
        this.o_newinst.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newInstance();
            }
        });
        this.o_toolbar.add(this.o_newinst);
        this.o_newmsg = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/newmsg.gif")));
        this.o_newmsg.setToolTipText("New message");
        this.o_newmsg.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMessage(true);
            }
        });
        this.o_toolbar.add(this.o_newmsg);
        this.o_newnegmsg = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/negmsg.gif")));
        this.o_newnegmsg.setToolTipText("New negative message");
        this.o_newnegmsg.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMessage(false);
            }
        });
        this.o_toolbar.add(this.o_newnegmsg);
        this.o_newdiv = new JButton(new ImageIcon(this.getClass().getResource("/mscedit/icon/div.gif")));
        this.o_newdiv.setToolTipText("New divider");
        this.o_newdiv.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newDivider();
            }
        });
        this.o_toolbar.add(this.o_newdiv);
    }

    public void populateMSCMenus(JMenuBar jMenuBar, LTSA lTSA) {
        this.o_ltsa = lTSA;
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Insert");
        JMenu jMenu4 = new JMenu("Options");
        JMenuItem jMenuItem = new JMenuItem("New...");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newSpec();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as...");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.saveFile();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export graphics...");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorCanvas editorCanvas = XMLGui.this.getCurrentEditor();
                XMLGui.this.o_ltsa.exportGraphic((Exportable)editorCanvas);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.renameMessage();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Reverse arrow");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.reverseLink();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.deleteMessage();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Negate message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.negateMessage();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Tidy");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.tidyChart();
            }
        });
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("New bMSC");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMSC();
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("New instance");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newInstance();
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("New transition");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newTransition();
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("New message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMessage(true);
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("New negative message");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newMessage(false);
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("New divider");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.newDivider();
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Large display");
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.setBigFont(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        jMenu4.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Show toolbar");
        jMenuItem.setSelected(true);
        jMenuItem.addActionListener(new GuiEventListener(this){

            public void actionPerformed(ActionEvent actionEvent) {
                this.o_gui.showToolBar(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        jMenu4.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
    }

    public void renameTab(String string, String string2) {
        this.o_tabbed_pane.setTitleAt(this.o_tabbed_pane.indexOfTab(string), string2);
    }

    public void swapToTab(String string) {
        if (this.o_tabbed_pane.indexOfTab(string) > -1) {
            this.o_tabbed_pane.setSelectedIndex(this.o_tabbed_pane.indexOfTab(string));
        }
    }

    EditorCanvas getCurrentEditor() {
        EditorCanvas editorCanvas = (EditorCanvas)this.o_editors.get(this.o_tabbed_pane.getSelectedIndex());
        return editorCanvas;
    }

    private boolean existsMSCCalled(String string) {
        return this.o_tabbed_pane.indexOfTab(string) > -1 || this.o_tabbed_pane.indexOfTab(this.capitalise(string)) > -1;
    }

    private String capitalise(String string) {
        StringBuffer stringBuffer = this.removeSpaces(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return stringBuffer.toString();
    }

    private String smallCaps(String string) {
        StringBuffer stringBuffer = this.removeSpaces(string);
        stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer removeSpaces(String var1_1) {
        var2_2 = new StringBuffer(var1_1);
        var3_3 = 0;
        while (var3_3 < var2_2.length()) {
            if (var2_2.charAt(var3_3) == ' ') {
                var2_2.setCharAt(var3_3 + 1, Character.toUpperCase(var2_2.charAt(var3_3 + 1)));
            }
            ++var3_3;
        }
        var4_4 = 0;
        ** GOTO lbl15
        {
            var2_2.deleteCharAt(var4_4);
            do {
                if (var2_2.charAt(var4_4) == ' ') continue block1;
                ++var4_4;
lbl15:
                // 2 sources

            } while (var4_4 < var2_2.length());
        }
        return var2_2;
    }
}

