/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.ConditionEvent;
import synthesis.Event;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.StringSet;

public class LTS {
    private HashMap delta;
    private Vector Inputs;
    private int max;
    private Integer actual;
    private int totalTransitions;

    public LTS() {
        this.max = 100;
        this.delta = new HashMap();
        this.totalTransitions = 0;
    }

    public void print(MyOutput myOutput) {
        Iterator iterator = this.delta.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.delta.get(n)).iterator();
            while (iterator2.hasNext()) {
                Vector vector = (Vector)iterator2.next();
                myOutput.println(n.toString() + "--" + (String)vector.get(0) + "->" + ((Integer)vector.get(1)).toString());
            }
        }
    }

    public void print(LTSOutput lTSOutput) {
        Iterator iterator = this.delta.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Iterator iterator2 = ((Set)this.delta.get(n)).iterator();
            while (iterator2.hasNext()) {
                Vector vector = (Vector)iterator2.next();
                lTSOutput.outln(n.toString() + "--" + (String)vector.get(0) + "->" + ((Integer)vector.get(1)).toString());
            }
        }
    }

    public LTS(int n) {
        this.max = n;
        this.delta = new HashMap();
        this.Inputs = new Vector(n);
        this.actual = new Integer(0);
        this.totalTransitions = 0;
        this.delta.put(this.actual, new HashSet());
        this.Inputs.add(0, new Integer(0));
        int n2 = 1;
        while (n2 < this.max) {
            Integer n3 = new Integer(n2);
            this.delta.put(n3, new HashSet());
            this.Inputs.add(n2, new Integer(0));
            ++n2;
        }
    }

    public Integer getState(int n) {
        return this.getKey(n);
    }

    private Integer getKey(int n) {
        boolean bl = false;
        Integer n2 = null;
        Iterator iterator = this.delta.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            n2 = (Integer)iterator.next();
            boolean bl2 = bl = n2 == n;
        }
        if (bl) {
            return n2;
        }
        return null;
    }

    public void addTransition(int n, String string, int n2) {
        Integer n3 = this.getKey(n);
        Integer n4 = this.getKey(n2);
        Vector<Object> vector = new Vector<Object>(3);
        vector.add(0, string);
        vector.add(1, n4);
        vector.add(2, n3);
        HashSet hashSet = (HashSet)this.delta.get(n3);
        hashSet.add(vector);
        int n5 = (Integer)this.Inputs.get(n2);
        this.Inputs.set(n2, new Integer(n5 + 1));
        ++this.totalTransitions;
    }

    public int numberOfTransitions() {
        return this.totalTransitions;
    }

    public void reset() {
        this.actual = this.getKey(0);
    }

    public boolean step(String string) {
        Iterator iterator = ((Set)this.delta.get(this.actual)).iterator();
        boolean bl = false;
        Vector vector = null;
        while (iterator.hasNext() && !bl) {
            vector = (Vector)iterator.next();
            bl = ((String)vector.get(0)).equals(string);
        }
        if (bl) {
            this.actual = (Integer)vector.get(1);
            return true;
        }
        return false;
    }

    public boolean step(String string, Integer n) {
        Iterator iterator = ((Set)this.delta.get(this.actual)).iterator();
        boolean bl = false;
        Vector vector = null;
        while (iterator.hasNext() && !bl) {
            vector = (Vector)iterator.next();
            boolean bl2 = bl = ((String)vector.get(0)).equals(string) && (Integer)vector.get(1) == n;
        }
        if (bl) {
            this.actual = (Integer)vector.get(1);
            return true;
        }
        return false;
    }

    public void step(Vector vector) {
        this.actual = (Integer)vector.get(1);
    }

    public boolean run(Vector vector) {
        return this.run_oc(vector, 0);
    }

    private boolean run_oc(Vector vector, int n) {
        boolean bl;
        Iterator iterator = this.enabledTransitions().iterator();
        Integer n2 = this.actual;
        if (n == vector.size()) {
            bl = true;
        } else {
            bl = false;
            while (iterator.hasNext() && !bl) {
                if (n2 != this.actual) {
                    this.setActual(n2);
                }
                if (!(bl = this.step((String)vector.get(n), (Integer)((Vector)iterator.next()).get(1)))) continue;
                boolean bl2 = bl = bl && this.run_oc(vector, n + 1);
            }
        }
        return bl;
    }

    public Set getStates() {
        return this.delta.keySet();
    }

    public void setActual(Integer n) {
        this.actual = n;
    }

    private Integer getActual() {
        return this.actual;
    }

    public int getActualState() {
        return this.getActual();
    }

    public Set enabledTransitions() {
        return (Set)this.delta.get(this.actual);
    }

    public int numberOfInputs(int n) {
        return (Integer)this.Inputs.get(n);
    }

    public int numberOfOutputs(int n) {
        try {
            return ((Set)this.delta.get(this.getKey(n))).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Map pathsWithNoMoreThanNCycles(int n, LTSOutput lTSOutput) {
        this.reset();
        return this.pathsWithNoMoreThanNCycles(this.actual, n, lTSOutput);
    }

    public Map pathsWithNoMoreThanNCycles(Integer n, int n2, LTSOutput lTSOutput) {
        boolean bl = true;
        HashMap hashMap = new HashMap();
        if (bl) {
            lTSOutput.outln("Generating paths without cycles");
        }
        hashMap.put(new Vector(), "");
        while (this.extendPathsWithNoMoreThanNCycles(hashMap, n, n2, lTSOutput)) {
            if (!bl) continue;
            lTSOutput.outln("Extended paths");
        }
        if (bl) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                String string = "Path:";
                int n3 = 0;
                while (n3 < vector.size()) {
                    string = string + (String)((Vector)vector.get(n3)).get(0) + ", ";
                    ++n3;
                }
                string = ((String)hashMap.get(vector)).equals("Loop") ? string + ": LOOP" : string + ": Deadlock";
                lTSOutput.outln(string);
            }
        }
        return hashMap;
    }

    public void pathCovers(HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        Vector vector = new Vector();
        hashSet.add(vector);
        while (this.extendCoverTraces(hashSet2, hashSet)) {
        }
    }

    private Set ExtendPrefix(Set set, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Vector vector;
            Integer n;
            Vector vector2 = (Vector)iterator.next();
            if (vector2.size() == 0) {
                this.reset();
                n = this.actual;
            } else {
                vector = (Vector)vector2.get(vector2.size() - 1);
                n = (Integer)vector.get(1);
            }
            HashSet<Vector> hashSet = new HashSet<Vector>();
            boolean bl = false;
            while (!bl && set2.contains(n)) {
                Iterator iterator2 = ((Set)this.delta.get(n)).iterator();
                boolean bl2 = false;
                while (iterator2.hasNext() && !bl2) {
                    Vector vector3 = (Vector)iterator2.next();
                    if (hashSet.contains(vector3)) continue;
                    hashSet.add(vector3);
                    bl2 = true;
                    vector2.add(vector2.size(), vector3);
                }
                if (!iterator2.hasNext()) {
                    bl = true;
                }
                vector = (Vector)vector2.get(vector2.size() - 1);
                n = (Integer)vector.get(1);
            }
        }
        return set;
    }

    private boolean extendCoverTraces(Set set, Set set2) {
        boolean bl = false;
        Vector vector = null;
        Vector vector2 = null;
        boolean bl2 = false;
        Iterator iterator = set2.iterator();
        while (iterator.hasNext() && !bl2) {
            Integer n;
            Vector vector3 = (Vector)iterator.next();
            if (vector3.size() == 0) {
                this.reset();
                n = this.actual;
            } else {
                Vector vector4 = (Vector)vector3.get(vector3.size() - 1);
                n = (Integer)vector4.get(1);
            }
            Iterator iterator2 = ((Set)this.delta.get(n)).iterator();
            while (iterator2.hasNext()) {
                vector = (Vector)iterator2.next();
                if (set.contains(vector)) continue;
                bl2 = true;
                set.add(vector);
                if (vector2 == null) {
                    vector2 = (Vector)vector3.clone();
                    vector3.add(vector3.size(), vector);
                    continue;
                }
                Vector vector5 = (Vector)vector2.clone();
                vector5.add(vector5.size(), vector);
                set2.add(vector5);
            }
        }
        return bl2;
    }

    private boolean extendPathsWithNoMoreThanNCycles(Map map, Integer n, int n2, LTSOutput lTSOutput) {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            Integer n3;
            Vector vector = (Vector)iterator.next();
            if (bl2) {
                lTSOutput.outln("Got a trace out of " + map.keySet().size());
            }
            if (((String)map.get(vector)).equals("Loop")) continue;
            if (bl2) {
                lTSOutput.outln("Not a loop");
            }
            Vector vector2 = (Vector)vector.clone();
            if (vector.size() == 0) {
                n3 = n;
            } else {
                Vector vector3 = (Vector)vector.get(vector.size() - 1);
                n3 = (Integer)vector3.get(1);
            }
            if (bl2) {
                lTSOutput.outln("Last node is:" + n3);
            }
            Iterator iterator2 = ((Set)this.delta.get(n3)).iterator();
            while (iterator2.hasNext()) {
                Integer n4;
                Vector vector4 = (Vector)iterator2.next();
                if (bl2) {
                    lTSOutput.outln("Got a transition:" + (String)vector4.get(0));
                }
                if (bl) {
                    if (bl2) {
                        lTSOutput.outln("Copying trace");
                    }
                    vector = (Vector)vector2.clone();
                } else {
                    bl = true;
                }
                map.remove(vector);
                vector.add(vector.size(), vector4);
                if (bl2) {
                    lTSOutput.outln("Added to trace");
                }
                int n5 = (n4 = (Integer)vector4.get(1)).intValue() == n.intValue() ? 1 : 0;
                int n6 = 0;
                while (n6 < vector.size() && n5 != n2 + 1) {
                    if (n4 == ((Vector)vector.get(n6)).get(1)) {
                        ++n5;
                    }
                    ++n6;
                }
                if (n5 == n2 + 1) {
                    if (bl2) {
                        lTSOutput.outln("Its a loop! Looped at " + n4);
                    }
                    map.put(vector, "Loop");
                    if (!bl2) continue;
                    lTSOutput.outln("Trace is clasified as " + (String)map.get(vector));
                    continue;
                }
                map.put(vector, "");
            }
        }
        return bl;
    }

    public boolean ExtendPath(Vector vector, StringSet stringSet, LTSOutput lTSOutput) {
        Vector vector2 = (Vector)vector.get(vector.size() - 1);
        return this.ocExtendPath(vector, stringSet, (Integer)vector2.get(1), 0, lTSOutput);
    }

    private boolean ocExtendPath(Vector vector, StringSet stringSet, int n, int n2, LTSOutput lTSOutput) {
        Vector vector2 = null;
        boolean bl = false;
        if (++n2 > 10) {
            lTSOutput.outln("Supero!!");
        }
        Vector vector3 = (Vector)vector.get(vector.size() - 1);
        Integer n3 = (Integer)vector3.get(1);
        lTSOutput.outln("Started in " + n + ". Extending from state " + n3);
        Iterator iterator = ((Set)this.delta.get(n3)).iterator();
        while (iterator.hasNext() && !bl) {
            vector2 = (Vector)iterator.next();
            if (!stringSet.contains((String)vector2.get(0))) continue;
            vector.add(vector.size(), vector2);
            bl = true;
        }
        if (!bl) {
            lTSOutput.outln("Starting to backtrack");
            int n4 = vector.size();
            iterator = ((Set)this.delta.get(n3)).iterator();
            while (iterator.hasNext() && !bl) {
                vector2 = (Vector)iterator.next();
                if (!stringSet.contains((String)vector2.get(0)) && ((Integer)vector2.get(1)).intValue() == n3.intValue()) {
                    lTSOutput.outln("Loop that doesn't change anything");
                    continue;
                }
                if ((Integer)vector2.get(1) == n) {
                    lTSOutput.outln("Back to the beginning");
                    continue;
                }
                vector.add(vector.size(), vector2);
                bl = this.ocExtendPath(vector, stringSet, n, n2, lTSOutput);
                if (bl) continue;
                vector.setSize(n4);
            }
        }
        return bl;
    }

    private void printTrace(Vector vector) {
        System.out.println("New Trace");
        int n = 0;
        while (n < vector.size()) {
            System.out.println("lbl : " + (String)((Vector)vector.get(n)).get(0) + " State " + (Integer)((Vector)vector.get(n)).get(1));
            ++n;
        }
    }

    public boolean getPath(Vector vector, Instance instance, int n, HashSet hashSet, LTSOutput lTSOutput) {
        boolean bl;
        if (n < instance.size()) {
            Event event = instance.get(n);
            if (!(event instanceof ConditionEvent)) {
                bl = false;
                HashSet hashSet2 = (HashSet)hashSet.clone();
                HashSet<Vector> hashSet3 = new HashSet<Vector>();
                Integer n2 = this.getActual();
                int n3 = 1;
                while (n3 <= 2) {
                    Iterator iterator = n3 == 1 ? this.enabledTransitions().iterator() : hashSet3.iterator();
                    while (iterator.hasNext() && !bl) {
                        Vector vector2 = (Vector)iterator.next();
                        String string = (String)vector2.get(0);
                        if (!string.equals(event.getLabel())) continue;
                        if (n3 == 1 && hashSet.contains(vector2)) {
                            hashSet3.add(vector2);
                            continue;
                        }
                        this.step(vector2);
                        hashSet.add(vector2);
                        bl = this.getPath(vector, instance, n + 1, hashSet, lTSOutput);
                        if (bl) {
                            vector.insertElementAt(vector2, 0);
                            continue;
                        }
                        this.setActual(n2);
                        hashSet.clear();
                        hashSet.addAll(hashSet2);
                    }
                    ++n3;
                }
            } else {
                bl = this.getPath(vector, instance, n + 1, hashSet, lTSOutput);
            }
        } else {
            bl = true;
        }
        return bl;
    }
}

