/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.util.Vector;
import synthesis.StringSet;

public class Trace {
    private Vector Events = new Vector();
    private int size = 0;

    public void add(String string) {
        this.Events.add(this.size, string);
        ++this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof Trace) {
            Trace trace = (Trace)object;
            boolean bl = trace.size() == this.size();
            int n = 0;
            while (n < this.size && bl) {
                bl = trace.get(n).equals(this.get(n));
                ++n;
            }
            return bl;
        }
        return false;
    }

    public String getString() {
        String string = "";
        int n = 0;
        while (n < this.size) {
            string = string + this.get(n);
            ++n;
        }
        return string;
    }

    public void print(LTSOutput lTSOutput) {
        int n = 0;
        while (n < this.size) {
            lTSOutput.out(this.get(n));
            if (n < this.size - 1) {
                lTSOutput.out(",");
            }
            ++n;
        }
        lTSOutput.outln(".");
    }

    public String get(int n) {
        return (String)this.Events.get(n);
    }

    public int size() {
        return this.size;
    }

    public Trace subtrace(int n, int n2) {
        Trace trace = new Trace();
        int n3 = n;
        while (n3 <= n2) {
            trace.add(this.get(n3));
            ++n3;
        }
        return trace;
    }

    public Trace subtrace(int n) {
        return this.subtrace(n, this.size() - 1);
    }

    public Trace myClone() {
        Trace trace = new Trace();
        trace.Events = (Vector)this.Events.clone();
        trace.size = this.size();
        return trace;
    }

    public boolean isPrefixOf(Trace trace) {
        if (this.size() > trace.size()) {
            return false;
        }
        return trace.subtrace(0, this.size() - 1).equals(this);
    }

    public Trace project(StringSet stringSet) {
        Trace trace = new Trace();
        int n = 0;
        while (n < this.size) {
            if (stringSet.contains(this.get(n))) {
                trace.add(this.get(n));
            }
            ++n;
        }
        return trace;
    }
}

