/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.LinkNode;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.Pool;
import gov.nasa.arc.ase.ltl.State;
import gov.nasa.arc.ase.util.graph.Graph;

class Automaton {
    private LinkNode head = null;
    private LinkNode tail = null;
    private Node[] equivalence_classes = null;

    public void add(Node node) {
        LinkNode linkNode = new LinkNode(node, null);
        if (this.head == null) {
            this.head = this.tail = linkNode;
        } else {
            this.tail.LinkWith(linkNode);
            this.tail = linkNode;
        }
    }

    public Node alreadyThere(Node node) {
        LinkNode linkNode = this.head;
        while (linkNode != null) {
            Node node2 = linkNode.getNode();
            if (node2.getField_next().equals(node.getField_next()) && node2.compare_accepting(node)) {
                return node2;
            }
            linkNode = linkNode.getNext();
        }
        return null;
    }

    public int index_equivalence(Node node) {
        int n = 0;
        while (n < Pool.assign()) {
            if (this.equivalence_classes[n] == null) break;
            if (this.equivalence_classes[n].getField_next().equals(node.getField_next())) {
                return this.equivalence_classes[n].getNodeId();
            }
            ++n;
        }
        if (n == Pool.assign()) {
            System.out.println("ERROR - size of equivalence classes array was incorrect");
        }
        this.equivalence_classes[n] = node;
        return this.equivalence_classes[n].getNodeId();
    }

    public State[] structForRuntAnalysis() {
        Pool.stop();
        int n = Pool.assign();
        State[] stateArray = new State[n];
        this.equivalence_classes = new Node[n];
        if (this.head == null) {
            return stateArray;
        }
        LinkNode linkNode = this.head;
        while (linkNode != null) {
            Node node = linkNode.getNode();
            node.set_equivalenceId(this.index_equivalence(node));
            linkNode.getNode().RTstructure(stateArray);
            linkNode = linkNode.getNext();
        }
        return stateArray;
    }

    public static void FSPoutput(State[] stateArray) {
        boolean bl = false;
        if (stateArray == null) {
            System.out.println("\n\nRES = STOP.");
            return;
        }
        System.out.println("\n\nRES = S0,");
        int n = Pool.assign();
        int n2 = 0;
        while (n2 < n) {
            if (stateArray[n2] != null && n2 == stateArray[n2].get_representativeId()) {
                if (bl) {
                    System.out.println("),");
                }
                bl = true;
                System.out.print("S" + stateArray[n2].get_representativeId());
                System.out.print("=");
                stateArray[n2].FSPoutput();
            }
            ++n2;
        }
        System.out.println(").\n");
    }

    public static Graph SMoutput(State[] stateArray) {
        Graph graph = new Graph();
        graph.setStringAttribute("type", "gba");
        graph.setStringAttribute("ac", "edges");
        if (stateArray == null) {
            return graph;
        }
        int n = Pool.assign();
        gov.nasa.arc.ase.util.graph.Node[] nodeArray = new gov.nasa.arc.ase.util.graph.Node[n];
        int n2 = 0;
        while (n2 < n) {
            if (stateArray[n2] != null && n2 == stateArray[n2].get_representativeId()) {
                nodeArray[n2] = new gov.nasa.arc.ase.util.graph.Node(graph);
                nodeArray[n2].setStringAttribute("label", "S" + stateArray[n2].get_representativeId());
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (stateArray[n3] != null && n3 == stateArray[n3].get_representativeId()) {
                stateArray[n3].SMoutput(nodeArray, nodeArray[n3]);
            }
            ++n3;
        }
        if (Node.accepting_conds == 0) {
            graph.setIntAttribute("nsets", 1);
        } else {
            graph.setIntAttribute("nsets", Node.accepting_conds);
        }
        return graph;
    }
}

