/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.extra.JPFErrorException;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.Pool;
import gov.nasa.arc.ase.ltl.Rewriter;
import gov.nasa.arc.ase.ltl.Translator;
import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class LTL2Buchi {
    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.ltl.LTL2Buchi [<filename>|<ltl-formula>]");
            return;
        }
        String string = null;
        if (stringArray.length == 0) {
            string = LTL2Buchi.readLTL();
        } else {
            string = stringArray[0];
            if (string.endsWith(".ltl")) {
                string = LTL2Buchi.loadLTL(string);
            } else if (string.equals("-")) {
                string = LTL2Buchi.readLTL();
            }
        }
        try {
            Graph graph = LTL2Buchi.translate(string);
            graph.save(1);
            System.out.println("\n\n");
        }
        catch (ParseErrorException parseErrorException) {
            System.out.println("Error: " + parseErrorException);
        }
    }

    public static void reset_all_static() {
        Node.reset_static();
        Formula.reset_static();
        Pool.reset_static();
    }

    public static Graph translate(String string) throws ParseErrorException {
        try {
            string = Rewriter.rewrite(string);
            Graph graph = Translator.translate(string);
            graph.save("gba.sm");
            graph.save("gba.txt", 1);
            FileWriter fileWriter = new FileWriter("gba.txt", true);
            try {
                fileWriter.write("\n" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: " + iOException);
            }
            graph = SuperSetReduction.reduce(graph);
            graph.save("ssr-gba.sm");
            graph.save("ssr-gba.txt", 1);
            fileWriter = new FileWriter("ssr-gba.txt", true);
            try {
                fileWriter.write("\n" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: " + iOException);
            }
            Graph graph2 = Degeneralize.degeneralize(graph);
            graph2.save("ba.sm");
            graph2.save("ba.txt", 1);
            fileWriter = new FileWriter("ba.txt", true);
            try {
                fileWriter.write("\n" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: " + iOException);
            }
            graph2 = SCCReduction.reduce(graph2);
            graph2.save("scc-ba.sm");
            graph2.save("scc-ba.txt", 1);
            fileWriter = new FileWriter("scc-ba.txt", true);
            try {
                fileWriter.write("\n" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: " + iOException);
            }
            graph2 = SFSReduction.reduce(graph2);
            graph2.save("fairSim-final.sm");
            graph2.save("sfs-ba.txt", 1);
            fileWriter = new FileWriter("sfs-ba.txt", true);
            try {
                fileWriter.write("\n" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: " + iOException);
            }
            return graph2;
        }
        catch (IOException iOException) {
            throw new JPFErrorException(iOException.getMessage());
        }
    }

    private static String loadLTL(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            return bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JPFErrorException("Can't load LTL formula: " + string);
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Error read on LTL formula: " + string);
        }
    }

    private static String readLTL() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Insert LTL formula: ");
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Invalid LTL formula");
        }
    }
}

