/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Attributes;
import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.EmptyVisitor;
import gov.nasa.arc.ase.util.graph.Node;
import gov.nasa.arc.ase.util.graph.Visitor;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Graph {
    public static final int SM_FORMAT = 0;
    public static final int FSP_FORMAT = 1;
    private List nodes;
    private Node init;
    private Attributes attributes;

    public Graph(Attributes attributes) {
        this.init(attributes);
    }

    public Graph() {
        this.init(null);
    }

    public List getNodes() {
        return new LinkedList(this.nodes);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getEdgeCount() {
        int n = 0;
        Iterator iterator = new LinkedList(this.nodes).iterator();
        while (iterator.hasNext()) {
            n += ((Node)iterator.next()).getOutgoingEdgeCount();
        }
        return n;
    }

    public Node getInit() {
        return this.init;
    }

    public int getIntAttribute(String string) {
        return this.attributes.getInt(string);
    }

    public String getStringAttribute(String string) {
        return this.attributes.getString(string);
    }

    public boolean getBooleanAttribute(String string) {
        return this.attributes.getBoolean(string);
    }

    public synchronized void setIntAttribute(String string, int n) {
        this.attributes.setInt(string, n);
    }

    public synchronized void setStringAttribute(String string, String string2) {
        this.attributes.setString(string, string2);
    }

    public synchronized void setBooleanAttribute(String string, boolean bl) {
        this.attributes.setBoolean(string, bl);
    }

    public synchronized void save(int n) {
        this.save(System.out, n);
    }

    public synchronized void save() {
        this.save(System.out, 0);
    }

    public synchronized void save(String string, int n) throws IOException {
        this.save(new PrintStream(new FileOutputStream(string)), n);
    }

    public synchronized void save(String string) throws IOException {
        this.save(new PrintStream(new FileOutputStream(string)), 0);
    }

    public synchronized void setInit(Node node) {
        if (this.nodes.contains(node)) {
            this.init = node;
            this.number();
        }
    }

    synchronized void removeNode(Node node) {
        this.nodes.remove(node);
        if (this.init == node) {
            this.init = this.nodes.size() != 0 ? (Node)this.nodes.get(0) : null;
        }
        this.number();
    }

    synchronized void addNode(Node node) {
        this.nodes.add(node);
        if (this.init == null) {
            this.init = node;
        }
        this.number();
    }

    public synchronized void setAttributes(Attributes attributes) {
        this.attributes = new Attributes(attributes);
    }

    private void init(Attributes attributes) {
        this.attributes = attributes == null ? new Attributes() : attributes;
        this.nodes = new LinkedList();
        this.init = null;
    }

    private synchronized void save(PrintStream printStream, int n) {
        switch (n) {
            case 0: {
                this.save_sm(printStream);
                break;
            }
            case 1: {
                this.save_fsp(printStream);
            }
        }
    }

    private synchronized void save_fsp(PrintStream printStream) {
        boolean bl = false;
        if (this.init != null) {
            printStream.print("RES = S" + this.init.getId());
        } else {
            printStream.print("Empty");
            bl = true;
        }
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            printStream.println(",");
            Node node = (Node)iterator.next();
            node.save(printStream, 1);
        }
        printStream.println(".");
        int n = this.getIntAttribute("nsets");
        if (n == 0 && !bl) {
            boolean bl2 = true;
            printStream.print("AS = { ");
            Iterator iterator2 = this.nodes.iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator2.next();
                if (!node.getBooleanAttribute("accepting")) continue;
                if (!bl2) {
                    printStream.print(", ");
                } else {
                    bl2 = false;
                }
                printStream.print("S" + node.getId());
            }
            printStream.println(" }");
        } else if (!bl) {
            int n2 = 0;
            while (n2 < n) {
                boolean bl3 = true;
                printStream.print("AS" + n2 + " = { ");
                Iterator iterator3 = this.nodes.iterator();
                while (iterator3.hasNext()) {
                    Node node = (Node)iterator3.next();
                    if (!node.getBooleanAttribute("acc" + n2)) continue;
                    if (!bl3) {
                        printStream.print(", ");
                    } else {
                        bl3 = false;
                    }
                    printStream.print("S" + node.getId());
                }
                printStream.println(" }");
                ++n2;
            }
        }
        if (printStream != System.out) {
            printStream.close();
        }
    }

    private synchronized void save_sm(PrintStream printStream) {
        printStream.println(this.nodes.size());
        printStream.println(this.attributes);
        if (this.init != null) {
            this.init.save(printStream, 0);
        }
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == this.init) continue;
            node.save(printStream, 0);
        }
    }

    private synchronized void number() {
        int n;
        if (this.init != null) {
            this.init.setId(0);
            n = 1;
        } else {
            n = 0;
        }
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == this.init) continue;
            node.setId(n++);
        }
    }

    public Node getNode(int n) {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getId() != n) continue;
            return node;
        }
        return null;
    }

    public static Graph load() throws IOException {
        return Graph.load(new BufferedReader(new InputStreamReader(System.in)));
    }

    public static Graph load(String string) throws IOException {
        return Graph.load(new BufferedReader(new FileReader(string)));
    }

    private static String readLine(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            int n;
            if ((n = (string = bufferedReader.readLine()).indexOf(35)) == -1) continue;
            string = string.substring(0, n);
        } while ((string = string.trim()).length() == 0);
        return string;
    }

    private static String readString(BufferedReader bufferedReader) throws IOException {
        return Graph.readLine(bufferedReader);
    }

    private static int readInt(BufferedReader bufferedReader) throws IOException {
        return Integer.parseInt(Graph.readLine(bufferedReader));
    }

    private static Attributes readAttributes(BufferedReader bufferedReader) throws IOException {
        return new Attributes(Graph.readLine(bufferedReader));
    }

    private static Graph load(BufferedReader bufferedReader) throws IOException {
        int n = Graph.readInt(bufferedReader);
        Node[] nodeArray = new Node[n];
        Graph graph = new Graph(Graph.readAttributes(bufferedReader));
        int n2 = 0;
        while (n2 < n) {
            int n3 = Graph.readInt(bufferedReader);
            if (nodeArray[n2] == null) {
                nodeArray[n2] = new Node(graph, Graph.readAttributes(bufferedReader));
            } else {
                nodeArray[n2].setAttributes(Graph.readAttributes(bufferedReader));
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = Graph.readInt(bufferedReader);
                String string = Graph.readString(bufferedReader);
                String string2 = Graph.readString(bufferedReader);
                if (nodeArray[n5] == null) {
                    nodeArray[n5] = new Node(graph);
                }
                new Edge(nodeArray[n2], nodeArray[n5], string, string2, Graph.readAttributes(bufferedReader));
                ++n4;
            }
            ++n2;
        }
        graph.number();
        return graph;
    }

    public synchronized void dfs(Visitor visitor) {
        if (this.init == null) {
            return;
        }
        this.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node node) {
                node.setBooleanAttribute("_reached", false);
            }
        });
        this.dfs(this.init, visitor);
        this.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node node) {
                node.setBooleanAttribute("_reached", false);
            }
        });
    }

    public synchronized void forAllNodes(Visitor visitor) {
        Iterator iterator = new LinkedList(this.nodes).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            visitor.visitNode(node);
        }
    }

    public synchronized void forAllEdges(Visitor visitor) {
        Iterator iterator = new LinkedList(this.nodes).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.forAllEdges(visitor);
        }
    }

    public synchronized void forAll(Visitor visitor) {
        Iterator iterator = new LinkedList(this.nodes).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            visitor.visitNode(node);
            node.forAllEdges(visitor);
        }
    }

    private synchronized void dfs(Node node, Visitor visitor) {
        final Visitor visitor2 = visitor;
        if (node.getBooleanAttribute("_reached")) {
            return;
        }
        node.setBooleanAttribute("_reached", true);
        visitor.visitNode(node);
        node.forAllEdges(new EmptyVisitor(){

            public void visitEdge(Edge edge) {
                Graph.this.dfs(edge.getNext(), visitor2);
            }
        });
    }
}

