/*
 * Decompiled with CFR 0.152.
 */
package webplugin;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import webplugin.Environment;

class Action {
    Element o_xml;
    Environment o_env;

    public Action(Element element, Environment environment) {
        this.o_xml = element;
        this.o_env = environment;
    }

    public boolean isValid() {
        if (this.o_xml == null) {
            return true;
        }
        Condition condition = this.makeCondition(this.o_xml.getChild("conditions"));
        if (condition != null) {
            return condition.check();
        }
        return true;
    }

    public int getTime() {
        if (this.o_xml == null) {
            return 0;
        }
        Element element = this.o_xml.getChild("time");
        if (element != null) {
            return Integer.parseInt(element.getText());
        }
        return 0;
    }

    public void execute() {
        if (this.o_xml == null) {
            return;
        }
        List list = this.o_xml.getChildren("data");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Attribute attribute = element.getAttribute("key");
            Attribute attribute2 = element.getAttribute("value");
            if (attribute == null) {
                System.err.println("No key value for data.");
                return;
            }
            if (attribute2 == null) {
                System.err.println("No value for data.");
                return;
            }
            this.o_env.put(attribute.getValue(), attribute2.getValue());
        }
    }

    Condition makeCondition(Element element) {
        if (element == null) {
            return null;
        }
        if (element.getName().equals("conditions")) {
            return this.makeCondition((Element)element.getChildren().get(0));
        }
        if (element.getName().equals("and")) {
            return new And(element);
        }
        if (element.getName().equals("or")) {
            return new Or(element);
        }
        if (element.getName().equals("equal")) {
            return new Equal(element);
        }
        if (element.getName().equals("notequal")) {
            return new NotEqual(element);
        }
        System.err.println("error - unknown condition type: " + element.getName());
        return null;
    }

    class Or
    extends Condition {
        Or(Element element) {
            super(element);
        }

        boolean check() {
            boolean bl = true;
            Iterator iterator = this.o_root.getChildren().iterator();
            while (iterator.hasNext()) {
                Condition condition = Action.this.makeCondition((Element)iterator.next());
                if (condition == null) continue;
                bl &= condition.check();
            }
            return bl;
        }
    }

    class And
    extends Condition {
        And(Element element) {
            super(element);
        }

        boolean check() {
            boolean bl = true;
            Iterator iterator = this.o_root.getChildren().iterator();
            while (iterator.hasNext()) {
                Condition condition = Action.this.makeCondition((Element)iterator.next());
                if (condition == null) continue;
                bl &= condition.check();
            }
            return bl;
        }
    }

    class NotEqual
    extends Condition {
        NotEqual(Element element) {
            super(element);
        }

        boolean check() {
            Attribute attribute = this.o_root.getAttribute("key");
            if (attribute == null) {
                System.err.println("No key specified in not-equal condition.");
                return true;
            }
            Attribute attribute2 = this.o_root.getAttribute("value");
            if (attribute2 == null) {
                System.err.println("No value specified in not-equal condition.");
                return true;
            }
            String string = Action.this.o_env.get(attribute.getValue());
            String string2 = attribute2.getValue();
            if (string == null) {
                return true;
            }
            return !string.equals(string2);
        }
    }

    class Equal
    extends Condition {
        Equal(Element element) {
            super(element);
        }

        boolean check() {
            Attribute attribute = this.o_root.getAttribute("key");
            if (attribute == null) {
                System.err.println("No key specified in equal condition.");
                return true;
            }
            Attribute attribute2 = this.o_root.getAttribute("value");
            if (attribute2 == null) {
                System.err.println("No value specified in equal condition.");
                return true;
            }
            String string = Action.this.o_env.get(attribute.getValue());
            String string2 = attribute2.getValue();
            if (string == null) {
                return false;
            }
            return string.equals(string2);
        }
    }

    abstract class Condition {
        protected Element o_root;

        Condition(Element element) {
            this.o_root = element;
        }

        abstract boolean check();
    }
}

