/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.ImagePanel;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

class ImageCanvas
extends Canvas {
    Image image = null;
    float degree = 1.0f;
    MediaTracker tracker = new MediaTracker(this);
    int canvasHeight = 600;
    int canvasWidth = 600;
    ImagePanel pane;

    public ImageCanvas(ImagePanel imagePanel) {
        this.pane = imagePanel;
    }

    public void setImage(Image image) {
        this.image = image;
        this.tracker.addImage(this.image, 0);
    }

    public void reduce() {
        this.degree -= 0.1f;
        if ((double)this.degree < 0.5) {
            this.degree = 0.5f;
        }
    }

    public void increase() {
        this.degree += 0.1f;
        if (this.degree > 2.0f) {
            this.degree = 2.0f;
        }
    }

    public void setNormal() {
        this.degree = 1.0f;
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            int n = this.image.getWidth(this);
            int n2 = this.image.getHeight(this);
            int n3 = Math.round((float)n * this.degree);
            int n4 = Math.round((float)n2 * this.degree);
            if (n3 > this.getWidth() || n4 > this.getHeight()) {
                this.setSize(n3 + 5, n4 + 5);
                this.canvasWidth = n3 + 5;
                this.canvasHeight = n4 + 5;
            }
            if (this.tracker.statusID(0, false) == 8) {
                graphics.drawImage(this.image, 0, 0, n3, n4, this);
                this.pane.doLayout();
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.canvasWidth, this.canvasHeight);
    }
}

