/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.extra.JPFErrorException;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.Pool;
import gov.nasa.arc.ase.ltl.Rewriter;
import gov.nasa.arc.ase.ltl.Translator;
import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class LTL2BuchiText {
    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.ltl.LTL2Buchi [<filename>|<ltl-formula>]");
            return;
        }
        String string = null;
        if (stringArray.length == 0) {
            string = LTL2BuchiText.readLTL();
        } else {
            string = stringArray[0];
            if (string.endsWith(".ltl")) {
                string = LTL2BuchiText.loadLTL(string);
            } else if (string.equals("-")) {
                string = LTL2BuchiText.readLTL();
            }
        }
        try {
            Graph graph = LTL2BuchiText.translate(string);
            graph.save(1);
            System.out.println("\n***********************\n");
        }
        catch (ParseErrorException parseErrorException) {
            System.out.println("Error: " + parseErrorException);
        }
    }

    public static void reset_all_static() {
        Node.reset_static();
        Formula.reset_static();
        Pool.reset_static();
    }

    public static Graph translate(String string) throws ParseErrorException {
        System.out.println("Translating formula: " + string);
        System.out.println();
        string = Rewriter.rewrite(string);
        System.out.println("Rewritten as       : " + string);
        System.out.println();
        Graph graph = Translator.translate(string);
        System.out.println("\n***********************");
        System.out.println("Generalized buchi automaton generated");
        System.out.println("\t" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
        System.out.println();
        graph = SuperSetReduction.reduce(graph);
        System.out.println("Superset reduction");
        System.out.println("\t" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
        System.out.println();
        Graph graph2 = Degeneralize.degeneralize(graph);
        System.out.println("Degeneralized buchi automaton generated: ba.sm");
        System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
        System.out.println();
        graph2 = SCCReduction.reduce(graph2);
        System.out.println("Strongly connected component reduction: scc-ba.sm");
        System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
        System.out.println();
        graph2 = SFSReduction.reduce(graph2);
        System.out.println("Fair simulation applied");
        System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
        System.out.println("***********************\n");
        return graph2;
    }

    private static String loadLTL(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            return bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JPFErrorException("Can't load LTL formula: " + string);
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Error read on LTL formula: " + string);
        }
    }

    private static String readLTL() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Insert LTL formula: ");
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Invalid LTL formula");
        }
    }
}

