/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.Automaton;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Pool;
import gov.nasa.arc.ase.ltl.State;
import gov.nasa.arc.ase.ltl.Transition;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeSet;

class Node
implements Comparable {
    private int nodeId = Pool.assign();
    private TreeSet incoming;
    private TreeSet toBeDone;
    private TreeSet old;
    private TreeSet next;
    private BitSet accepting;
    private BitSet right_of_untils;
    private Node OtherTransitionSource;
    public static int accepting_conds = 0;
    private static boolean init_collapsed = false;
    private int equivalenceId;

    public Node() {
        this.incoming = new TreeSet();
        this.toBeDone = new TreeSet();
        this.old = new TreeSet();
        this.next = new TreeSet();
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.right_of_untils = new BitSet(accepting_conds);
    }

    public Node(TreeSet treeSet, TreeSet treeSet2, TreeSet treeSet3, TreeSet treeSet4, BitSet bitSet, BitSet bitSet2) {
        this.incoming = new TreeSet(treeSet);
        this.toBeDone = new TreeSet(treeSet2);
        this.old = new TreeSet(treeSet3);
        this.next = new TreeSet(treeSet4);
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.accepting.or(bitSet);
        this.right_of_untils = new BitSet(accepting_conds);
        this.right_of_untils.or(bitSet2);
    }

    public static Node createInitial(Formula formula) {
        accepting_conds = formula.processRightUntils();
        Formula.until_forms = new Formula[accepting_conds];
        Formula.untils.toArray(Formula.until_forms);
        Node node = new Node();
        node.nodeId = 0;
        if (formula.getContent() != 't') {
            node.decompose_ands_for_next(formula);
        }
        return node;
    }

    public static void reset_static() {
        accepting_conds = 0;
        init_collapsed = false;
    }

    public static int getAcceptingConds() {
        return accepting_conds;
    }

    public void set_equivalenceId(int n) {
        this.equivalenceId = n;
    }

    public int get_equivalenceId() {
        return this.equivalenceId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public boolean isInitial() {
        return this.nodeId == 0;
    }

    public void update_accepting() {
        this.accepting.andNot(this.right_of_untils);
    }

    public boolean compare_accepting(Node node) {
        if (this.nodeId == 0 && !init_collapsed) {
            return true;
        }
        return this.accepting.equals(node.accepting);
    }

    public TreeSet getField_old() {
        return this.old;
    }

    public void decompose_ands_for_next(Formula formula) {
        if (formula.getContent() == 'A') {
            this.decompose_ands_for_next(formula.getSub1());
            this.decompose_ands_for_next(formula.getSub2());
        } else if (!Node.is_redundant(this.next, null, formula)) {
            this.next.add(formula);
        }
    }

    public TreeSet getField_next() {
        return this.next;
    }

    private Node split(Formula formula) {
        Node node = new Node(this.incoming, this.toBeDone, this.old, this.next, this.accepting, this.right_of_untils);
        Formula formula2 = formula.getSub2();
        if (!this.old.contains(formula2)) {
            node.toBeDone.add(formula2);
        }
        if (formula.getContent() == 'V' && !this.old.contains(formula2 = formula.getSub1())) {
            node.toBeDone.add(formula2);
        }
        if (!this.old.contains(formula2 = formula.getSub1())) {
            this.toBeDone.add(formula2);
        }
        if ((formula2 = formula.getNext()) != null) {
            this.decompose_ands_for_next(formula2);
        }
        if (formula.getContent() == 'U') {
            this.accepting.set(formula.get_untils_index());
            node.accepting.set(formula.get_untils_index());
        }
        if (formula.is_right_of_until()) {
            this.right_of_untils.set(formula.get_rightOfUntils_index());
            node.right_of_untils.set(formula.get_rightOfUntils_index());
        }
        if (formula.is_literal()) {
            this.old.add(formula);
            System.out.println("added " + formula);
            node.old.add(formula);
        }
        return node;
    }

    public void print() {
        System.out.println("\n\nPrinting node " + this.nodeId);
        Iterator iterator = this.next.iterator();
        Formula formula = null;
        while (iterator.hasNext()) {
            formula = (Formula)iterator.next();
            System.out.println("Formula: " + formula.toString());
        }
    }

    public Automaton expand(Automaton automaton) {
        if (this.toBeDone.isEmpty()) {
            Node node;
            if (this.nodeId != 0) {
                this.update_accepting();
            }
            if ((node = automaton.alreadyThere(this)) != null) {
                node.modify(this);
                return automaton;
            }
            Node node2 = new Node();
            node2.incoming.add(this);
            node2.toBeDone.addAll(this.next);
            automaton.add(this);
            return node2.expand(automaton);
        }
        Formula formula = (Formula)this.toBeDone.first();
        this.toBeDone.remove(formula);
        if (this.testForContradictions(formula)) {
            return automaton;
        }
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.old);
        treeSet.addAll(this.toBeDone);
        if (Node.is_redundant(treeSet, this.next, formula)) {
            return this.expand(automaton);
        }
        if (!formula.is_literal()) {
            switch (formula.getContent()) {
                case 'O': 
                case 'U': 
                case 'V': 
                case 'W': {
                    Node node = this.split(formula);
                    return node.expand(this.expand(automaton));
                }
                case 'X': {
                    this.decompose_ands_for_next(formula.getSub1());
                    if (formula.is_right_of_until()) {
                        this.right_of_untils.set(formula.get_rightOfUntils_index());
                    }
                    return this.expand(automaton);
                }
                case 'A': {
                    Formula formula2 = formula.getSub1();
                    if (!this.old.contains(formula2)) {
                        this.toBeDone.add(formula2);
                    }
                    if (!this.old.contains(formula2 = formula.getSub2())) {
                        this.toBeDone.add(formula2);
                    }
                    if (formula.is_right_of_until()) {
                        this.right_of_untils.set(formula.get_rightOfUntils_index());
                    }
                    return this.expand(automaton);
                }
            }
            System.out.println("default case of switch entered");
            return null;
        }
        if (formula.getContent() != 't') {
            this.old.add(formula);
        }
        if (formula.is_right_of_until()) {
            this.right_of_untils.set(formula.get_rightOfUntils_index());
        }
        return this.expand(automaton);
    }

    private static boolean is_redundant(TreeSet treeSet, TreeSet treeSet2, Formula formula) {
        return formula.is_special_case_of_V(treeSet) || formula.is_synt_implied(treeSet, treeSet2) && (formula.getContent() != 'U' || formula.getSub2().is_synt_implied(treeSet, treeSet2));
    }

    private void modify(Node node) {
        boolean bl = false;
        Node node2 = this;
        Node node3 = this;
        if (this.nodeId == 0 && !init_collapsed) {
            this.accepting = node.accepting;
            init_collapsed = true;
        }
        while (node3 != null) {
            if (node3.old.equals(node.old)) {
                node3.incoming.addAll(node.incoming);
                bl = true;
            }
            node2 = node3;
            node3 = node3.OtherTransitionSource;
        }
        if (!bl) {
            node2.OtherTransitionSource = node;
        }
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        return 1;
    }

    private boolean testForContradictions(Formula formula) {
        Formula formula2 = formula.negate();
        return formula2.is_synt_implied(this.old, this.next);
    }

    public int getId() {
        return this.nodeId;
    }

    public void debug() {
        Iterator iterator = this.old.iterator();
        Formula formula = null;
        while (iterator.hasNext()) {
            formula = (Formula)iterator.next();
        }
    }

    private boolean is_safety_acc_node() {
        if (this.next.isEmpty()) {
            return true;
        }
        Iterator iterator = this.next.iterator();
        Formula formula = null;
        while (iterator.hasNext()) {
            formula = (Formula)iterator.next();
            if (formula.getContent() == 'V' || formula.getContent() == 'W') continue;
            return false;
        }
        return true;
    }

    public void RTstructure(State[] stateArray) {
        boolean bl = false;
        if (stateArray[this.nodeId] == null) {
            stateArray[this.nodeId] = new State(this.accepting, this.equivalenceId);
        } else {
            stateArray[this.nodeId].update_acc(this.accepting, this.equivalenceId);
        }
        if (this.is_safety_acc_node()) {
            stateArray[this.nodeId].update_safety_acc(true);
            bl = true;
        }
        Node node = this;
        while (node != null) {
            Iterator iterator = node.incoming.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                int n = node2.getId();
                if (stateArray[n] == null) {
                    stateArray[n] = new State();
                }
                stateArray[n].add(new Transition(node.old, this.equivalenceId, this.accepting, bl));
            }
            node = node.OtherTransitionSource;
        }
    }
}

