/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.RulesClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;

public class Rewriter {
    public static void main(String[] stringArray) {
        block7: {
            int n = 0;
            int n2 = 0;
            try {
                if (stringArray.length != 0) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        Formula formula = Formula.parse(stringArray[n3]);
                        n += formula.size();
                        formula = Rewriter.rewrite(formula);
                        System.out.println(formula);
                        System.err.println((n2 += formula.size()) * 100 / n + "% (" + n + " => " + n2 + ")");
                        ++n3;
                    }
                    break block7;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.equals("")) continue;
                        Formula formula = Formula.parse(string);
                        n += formula.size();
                        formula = Rewriter.rewrite(formula);
                        System.out.println(formula);
                        System.err.println((n2 += formula.size()) * 100 / n + "% (" + n + " => " + n2 + ")");
                    }
                }
                catch (IOException iOException) {
                    System.out.println("error");
                }
            }
            catch (ParseErrorException parseErrorException) {
                System.err.println("parse error: " + parseErrorException.getMessage());
            }
        }
    }

    public static String rewrite(String string) throws ParseErrorException {
        return Rewriter.rewrite(Formula.parse(string)).toString();
    }

    public static Formula rewrite(Formula formula) {
        Formula[] formulaArray = Rewriter.readRules();
        if (formulaArray == null) {
            return formula;
        }
        try {
            boolean bl;
            boolean bl2 = false;
            do {
                Formula formula2;
                bl = false;
                do {
                    formula2 = formula;
                    int n = 0;
                    while (n < formulaArray.length) {
                        formula = Rewriter.applyRule(formula, formulaArray[n], formulaArray[n + 1]);
                        n += 2;
                    }
                    if (formula2 == formula) continue;
                    bl = true;
                } while (formula2 != formula);
                bl2 = !bl2;
                formula = Formula.parse("!" + formula.toString());
            } while (bl || bl2);
            return formula;
        }
        catch (ParseErrorException parseErrorException) {
            return null;
        }
    }

    public static Formula[] readRules() {
        Formula[] formulaArray = new Formula[]{};
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(RulesClass.getRules()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("")) continue;
                Formula formula = Formula.parse(string);
                Formula[] formulaArray2 = new Formula[formulaArray.length + 1];
                System.arraycopy(formulaArray, 0, formulaArray2, 0, formulaArray.length);
                formulaArray2[formulaArray.length] = formula;
                formulaArray = formulaArray2;
            }
        }
        catch (IOException iOException) {
        }
        catch (ParseErrorException parseErrorException) {
            System.err.println("parse error: " + parseErrorException.getMessage());
            System.exit(1);
        }
        return formulaArray;
    }

    public static Formula applyRule(Formula formula, Formula formula2, Formula formula3) {
        return formula.rewrite(formula2, formula3);
    }
}

