/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.extra.JPFErrorException;
import gov.nasa.arc.ase.ltl.Automaton;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.State;
import gov.nasa.arc.ase.util.graph.Graph;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Translator {
    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("\nPlease enter LTL formula followed by enter");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.out.println(" => <input error:" + iOException.getMessage() + ">");
            }
        }
        if (string2 == null) {
            Translator.translate(string).save(1);
        } else {
            try {
                Translator.translate(string).save(string2);
            }
            catch (IOException iOException) {
                System.out.println("Can't save file: " + string2);
            }
        }
    }

    public static Graph translate(String string) {
        try {
            Formula formula = Formula.parse(string);
            Node node = Node.createInitial(formula);
            State[] stateArray = node.expand(new Automaton()).structForRuntAnalysis();
            return Automaton.SMoutput(stateArray);
        }
        catch (ParseErrorException parseErrorException) {
            throw new JPFErrorException("parse error: " + parseErrorException.getMessage());
        }
    }
}

