/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import gov.nasa.arc.ase.util.Debug;
import java.io.PrintStream;
import java.util.Vector;

public class Category
implements Comparable {
    private String[] categories;
    private int length;
    private int delta;

    public Category() {
        this.categories = new String[0];
        this.length = 0;
        this.delta = 1;
    }

    public Category(Category category) {
        int n = category.categories.length;
        this.categories = new String[n];
        System.arraycopy(category.categories, 0, this.categories, 0, n);
        this.length = n;
        this.delta = 1;
    }

    public Category(String string) {
        this.parseFromString(string);
    }

    public Category(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.categories = new String[n];
        this.length = 0;
        this.delta = 1;
    }

    public Category(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.categories = new String[n];
        this.length = 0;
        this.delta = n2;
    }

    public Category(Category category, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        int n2 = category.categories.length;
        this.categories = new String[n2];
        System.arraycopy(category.categories, 0, this.categories, 0, n2);
        this.length = n2;
        this.delta = n;
    }

    public boolean equals(Object object) {
        Category category = (Category)object;
        String[] stringArray = this.categories;
        String[] stringArray2 = category.categories;
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n & n3 < n2) {
            if (!stringArray[n3].equals(stringArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected void grow() {
        String[] stringArray = new String[this.length + this.delta];
        System.arraycopy(this.categories, 0, stringArray, 0, this.length);
        this.categories = stringArray;
    }

    public void down(String string) {
        if (this.length >= this.categories.length) {
            this.grow();
        }
        this.categories[this.length++] = string;
    }

    public String up() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException("length == 0");
        }
        return this.categories[--this.length];
    }

    public void print(Category category) {
        boolean bl = false;
        if (this.length == 0) {
            Debug.print(1, "/");
            return;
        }
        int n = 0;
        while (n < this.length) {
            int n2;
            if (n == this.length - 1) {
                n2 = 0;
                while (n2 < n) {
                    Debug.print(1, "  ");
                    ++n2;
                }
                Debug.print(1, this.categories[n].toString());
            } else if (bl || category == null) {
                n2 = 0;
                while (n2 < n) {
                    Debug.print(1, "  ");
                    ++n2;
                }
                Debug.println(1, this.categories[n].toString());
            } else if (!this.categories[n].equals(category.categories[n])) {
                bl = true;
                n2 = 0;
                while (n2 < n) {
                    Debug.print(1, "  ");
                    ++n2;
                }
                Debug.println(1, this.categories[n].toString());
            }
            ++n;
        }
    }

    public void save(PrintStream printStream, Category category) {
        boolean bl = false;
        if (this.length == 0) {
            printStream.print("/");
            return;
        }
        int n = 0;
        while (n < this.length) {
            int n2;
            if (n == this.length - 1) {
                n2 = 0;
                while (n2 < n) {
                    printStream.print("  ");
                    ++n2;
                }
                printStream.print(this.categories[n].toString());
            } else if (bl || category == null) {
                n2 = 0;
                while (n2 < n) {
                    printStream.print("  ");
                    ++n2;
                }
                printStream.println(this.categories[n].toString());
            } else if (n >= category.length || !this.categories[n].equals(category.categories[n])) {
                bl = true;
                n2 = 0;
                while (n2 < n) {
                    printStream.print("  ");
                    ++n2;
                }
                printStream.println(this.categories[n].toString());
            }
            ++n;
        }
    }

    public String toString() {
        if (this.length == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.length) {
            stringBuffer.append("/");
            stringBuffer.append(this.categories[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.length) {
            n += this.categories[n2].hashCode();
            ++n2;
        }
        return n;
    }

    protected void parseFromString(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("category should start with /");
        }
        int n = 1;
        int n2 = string.length();
        Vector<String> vector = new Vector<String>();
        while (n < n2) {
            int n3 = string.indexOf(47, n);
            if (n3 == -1) {
                n3 = n2;
            }
            vector.addElement(string.substring(n, n3));
            n = n3 + 1;
        }
        this.length = vector.size();
        this.categories = new String[this.length];
        vector.toArray(this.categories);
        this.delta = 1;
    }

    public int compareTo(Object object) {
        Category category = (Category)object;
        String[] stringArray = this.categories;
        String[] stringArray2 = category.categories;
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n & n3 < n2) {
            int n4 = stringArray[n3].compareTo(stringArray2[n3]);
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return n - n2;
    }
}

