/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import gov.nasa.arc.ase.util.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TreeNode {
    private Tree tree;
    private TreeNode parent;
    private Collection children;

    public TreeNode(Tree tree) {
        this.tree = tree;
        this.parent = null;
        this.children = new ArrayList();
        tree.setRoot(this);
    }

    public TreeNode(TreeNode treeNode) {
        this.tree = treeNode.tree;
        this.parent = treeNode;
        this.children = new ArrayList();
        treeNode.addChild(this);
    }

    private void addChild(TreeNode treeNode) {
        this.children.add(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public Tree getTree() {
        return this.tree;
    }

    public Collection children() {
        return this.children;
    }

    public Collection below() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            arrayList.add(treeNode);
            arrayList.addAll(treeNode.below());
        }
        return arrayList;
    }

    public Collection above() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (this.parent != null) {
            arrayList.add(this.parent);
            arrayList.addAll(this.parent.above());
        }
        return arrayList;
    }

    public Collection get(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (this.equals(treeNode)) {
            arrayList.add(this);
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode2 = (TreeNode)iterator.next();
            arrayList.addAll(treeNode2.get(treeNode));
        }
        return arrayList;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ');
        stringBuffer.append(this);
        stringBuffer.append('\n');
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            stringBuffer.append(string);
            if (iterator.hasNext()) {
                stringBuffer.append('+');
                stringBuffer.append(treeNode.toString(string + "|  "));
                continue;
            }
            stringBuffer.append('\\');
            stringBuffer.append(treeNode.toString(string + "   "));
        }
        return stringBuffer.toString();
    }
}

