/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.ColorPair;
import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.ITypeNeighbor;
import gov.nasa.arc.ase.util.graph.Node;
import gov.nasa.arc.ase.util.graph.Pair;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class SFSReduction {
    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.util.graph.SFSReduction [<filename>]");
            return;
        }
        Graph graph = null;
        try {
            graph = stringArray.length == 0 ? Graph.load() : Graph.load(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("Can't load the graph.");
            return;
        }
        Graph graph2 = SFSReduction.reduce(graph);
        graph2.save();
    }

    private static boolean isAccepting(Node node) {
        return node.getBooleanAttribute("accepting");
    }

    private static String subterm(String string, String string2) {
        String string3;
        String string4;
        String string5;
        if (string.equals("-") && string2.equals("-")) {
            return "true";
        }
        if (string.equals("-")) {
            return string;
        }
        if (string2.equals("-")) {
            return string2;
        }
        if (string.indexOf("true") != -1 && string2.indexOf("true") != -1) {
            return "true";
        }
        if (string.indexOf("true") != -1) {
            return string;
        }
        if (string2.indexOf("true") != -1) {
            return string2;
        }
        if (string.length() <= string2.length()) {
            string5 = string;
            string4 = string2;
        } else {
            string5 = string2;
            string4 = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5, "&");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "&");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer2.hasMoreTokens()) {
            string3 = stringTokenizer2.nextToken();
            linkedList.add(string3);
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (linkedList.contains(string3)) continue;
            return "false";
        }
        if (string.length() == string2.length()) {
            return "true";
        }
        return string5;
    }

    private static ITypeNeighbor iDominates(ITypeNeighbor iTypeNeighbor, ITypeNeighbor iTypeNeighbor2, boolean[][] blArray) {
        String string = iTypeNeighbor.getTransition();
        String string2 = iTypeNeighbor2.getTransition();
        int n = iTypeNeighbor.getColor();
        int n2 = iTypeNeighbor2.getColor();
        String string3 = SFSReduction.subterm(string, string2);
        if (string3 == string) {
            if (blArray[n2 - 1][n - 1]) {
                return iTypeNeighbor;
            }
            return null;
        }
        if (string3 == string2) {
            if (blArray[n - 1][n2 - 1]) {
                return iTypeNeighbor2;
            }
            return null;
        }
        if (string3.equals("true")) {
            if (blArray[n2 - 1][n - 1]) {
                return iTypeNeighbor;
            }
            if (blArray[n - 1][n2 - 1]) {
                return iTypeNeighbor2;
            }
        }
        return null;
    }

    private static boolean iDominateSet(TreeSet treeSet, TreeSet treeSet2, boolean[][] blArray) {
        TreeSet treeSet3 = new TreeSet(treeSet2);
        Iterator iterator = treeSet3.iterator();
        block0: while (iterator.hasNext()) {
            ITypeNeighbor iTypeNeighbor = (ITypeNeighbor)iterator.next();
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                ITypeNeighbor iTypeNeighbor2 = (ITypeNeighbor)iterator2.next();
                ITypeNeighbor iTypeNeighbor3 = SFSReduction.iDominates(iTypeNeighbor2, iTypeNeighbor, blArray);
                if (iTypeNeighbor3 != iTypeNeighbor2) continue;
                iterator.remove();
                continue block0;
            }
        }
        return treeSet3.size() == 0;
    }

    private static TreeSet getPrevN(Node node, boolean[][] blArray) {
        ITypeNeighbor iTypeNeighbor;
        List list = node.getOutgoingEdges();
        LinkedList<ITypeNeighbor> linkedList = new LinkedList<ITypeNeighbor>();
        TreeSet<ITypeNeighbor> treeSet = new TreeSet<ITypeNeighbor>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            iTypeNeighbor = new ITypeNeighbor(edge.getNext().getIntAttribute("_prevColor"), edge.getGuard());
            linkedList.add(iTypeNeighbor);
        }
        if (linkedList.size() == 0) {
            return treeSet;
        }
        do {
            boolean bl = false;
            iTypeNeighbor = (ITypeNeighbor)linkedList.removeFirst();
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                ITypeNeighbor iTypeNeighbor2 = (ITypeNeighbor)iterator2.next();
                ITypeNeighbor iTypeNeighbor3 = SFSReduction.iDominates(iTypeNeighbor, iTypeNeighbor2, blArray);
                if (iTypeNeighbor3 == iTypeNeighbor) {
                    iterator2.remove();
                }
                if (iTypeNeighbor3 != iTypeNeighbor2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            treeSet.add(iTypeNeighbor);
        } while (linkedList.size() > 0);
        return treeSet;
    }

    private static Graph reachabilityGraph(Graph graph) {
        Object object;
        Object object2;
        Object object3;
        Vector<Node> vector = new Vector<Node>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.add(graph.getInit());
        while (!vector.isEmpty()) {
            object3 = (Node)vector.firstElement();
            vector2.add(object3);
            if (object3 != null) {
                object2 = ((Node)object3).getOutgoingEdges();
                object = object2.iterator();
                while (object.hasNext()) {
                    Edge edge = (Edge)object.next();
                    Node node = edge.getNext();
                    if (vector.contains(node) || vector2.contains(node)) continue;
                    vector.add(node);
                }
            }
            if (vector.remove(0) == object3) continue;
            System.out.println("ERROR");
        }
        object3 = graph.getNodes();
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                if (vector2.contains(object)) continue;
                graph.removeNode((Node)object);
            }
        }
        return graph;
    }

    public static Graph reduce(Graph graph) {
        Graph graph2;
        Object object;
        ColorPair colorPair;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = 1;
        int n2 = 4;
        int n3 = n;
        TreeSet<Object> treeSet = null;
        LinkedList<Pair> linkedList = null;
        boolean bl = false;
        boolean bl2 = false;
        List list = graph.getNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object5 = (Node)iterator.next();
            ((Node)object5).setIntAttribute("_prevColor", 1);
            if (SFSReduction.isAccepting((Node)object5)) {
                ((Node)object5).setIntAttribute("_currColor", 1);
                bl = true;
                continue;
            }
            ((Node)object5).setIntAttribute("_currColor", 2);
            bl2 = true;
        }
        int n4 = bl && bl2 ? 2 : 1;
        object5 = new boolean[2][2];
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 2) {
                object5[n5][n6] = n5 >= n6 ? (Object)true : (Object)false;
                ++n6;
            }
            ++n5;
        }
        while (n4 != n || n2 != n3) {
            Object object6;
            Object object7;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                object4 = (Node[])iterator2.next();
                ((Node)object4).setIntAttribute("_prevColor", ((Node)object4).getIntAttribute("_currColor"));
            }
            Object object8 = object5;
            n = n4;
            linkedList = new LinkedList<Pair>();
            treeSet = new TreeSet<Object>();
            object4 = list.iterator();
            while (object4.hasNext()) {
                object7 = (Node)object4.next();
                object3 = new ColorPair(((Node)object7).getIntAttribute("_prevColor"), SFSReduction.getPrevN((Node)object7, (boolean[][])object8));
                linkedList.add(new Pair(((Node)object7).getId(), object3));
                treeSet.add(object3);
            }
            n4 = treeSet.size();
            if (n == n4) break;
            object7 = new LinkedList();
            object3 = treeSet.iterator();
            while (object3.hasNext()) {
                object2 = (ColorPair)object3.next();
                ((LinkedList)object7).add(object2);
            }
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object6 = (Pair)object2.next();
                colorPair = (ColorPair)((Pair)object6).getElement();
                graph.getNode(((Pair)object6).getValue()).setIntAttribute("_currColor", ((LinkedList)object7).indexOf(colorPair) + 1);
            }
            object5 = new boolean[n4][n4];
            object6 = linkedList.iterator();
            while (object6.hasNext()) {
                colorPair = (ColorPair)((Pair)object6.next()).getElement();
                object = linkedList.iterator();
                while (object.hasNext()) {
                    ColorPair colorPair2 = (ColorPair)((Pair)object.next()).getElement();
                    Object object9 = object8[colorPair2.getColor() - 1][colorPair.getColor() - 1];
                    boolean bl3 = SFSReduction.iDominateSet(colorPair.getIMaxSet(), colorPair2.getIMaxSet(), (boolean[][])object8);
                    object5[((LinkedList)object7).indexOf((Object)colorPair2)][((LinkedList)object7).indexOf((Object)colorPair)] = object9 != false && bl3 ? (Object)true : (Object)false;
                }
            }
        }
        if (linkedList == null) {
            graph2 = graph;
        } else {
            graph2 = new Graph();
            object4 = new Node[n4];
            int n7 = 0;
            while (n7 < n4) {
                object4[n7] = object3 = new Node(graph2);
                ++n7;
            }
            object3 = linkedList.iterator();
            while (object3.hasNext()) {
                object2 = (Pair)object3.next();
                int n8 = ((Pair)object2).getValue();
                colorPair = (ColorPair)((Pair)object2).getElement();
                if (!treeSet.contains(colorPair)) continue;
                treeSet.remove(colorPair);
                object = colorPair.getIMaxSet();
                int n9 = colorPair.getColor();
                Object object10 = object4[n9 - 1];
                Iterator iterator3 = ((TreeSet)object).iterator();
                while (iterator3.hasNext()) {
                    ITypeNeighbor iTypeNeighbor = (ITypeNeighbor)iterator3.next();
                    int n10 = iTypeNeighbor.getColor() - 1;
                    Edge edge = new Edge((Node)object10, (Node)object4[n10], iTypeNeighbor.getTransition());
                }
                if (graph.getInit().getId() == n8) {
                    graph2.setInit((Node)object10);
                }
                if (!SFSReduction.isAccepting(graph.getNode(n8))) continue;
                ((Node)object10).setBooleanAttribute("accepting", true);
            }
        }
        return SFSReduction.reachabilityGraph(graph2);
    }
}

