/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import gov.nasa.arc.ase.util.graph.Graph;
import ic.doc.extension.Animator;
import ic.doc.extension.Exportable;
import ic.doc.extension.Initialisable;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import ic.doc.extension.PluginManager;
import ic.doc.extension.Relation;
import ic.doc.ltsa.AlphabetWindow;
import ic.doc.ltsa.AnimWindow;
import ic.doc.ltsa.AppletButton;
import ic.doc.ltsa.Examples;
import ic.doc.ltsa.LTSABlanker;
import ic.doc.ltsa.LTSASplash;
import ic.doc.ltsa.LTSDrawWindow;
import ic.doc.ltsa.PrintWindow;
import ic.doc.ltsa.dclap.Gr2PICT;
import ic.doc.ltsa.editor.ColoredEditorKit;
import ic.doc.ltsa.lts.Analyser;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSCanvas;
import ic.doc.ltsa.lts.LTSCompiler;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSException;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MenuDefinition;
import ic.doc.ltsa.lts.ProgressCheck;
import ic.doc.ltsa.lts.RunMenu;
import ic.doc.ltsa.lts.SuperTrace;
import ic.doc.ltsa.lts.SymbolTable;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HPWindow
extends JFrame
implements LTSA,
LTSInput,
LTSOutput,
Runnable {
    private static final String VERSION = " j1.2 v14-10-99, amimation support";
    private static final String DEFAULT = "DEFAULT";
    JTextArea output;
    JEditorPane input;
    JEditorPane manual;
    AlphabetWindow alphabet;
    PrintWindow prints;
    LTSDrawWindow draws;
    JTabbedPane textIO;
    JToolBar tools;
    PluginManager o_plugin_manager;
    Map o_plugin_buttons;
    Map o_menus;
    JComboBox targetChoice;
    JPanel p;
    EventManager eman = new EventManager();
    JFrame animator = null;
    CompositeState current = null;
    String run_menu = "DEFAULT";
    String asserted = null;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    JMenu file;
    JMenu edit;
    JMenu check;
    JMenu build;
    JMenu window;
    JMenu help;
    JMenu option;
    JMenuItem file_new;
    JMenuItem file_open;
    JMenuItem file_save;
    JMenuItem file_saveAs;
    JMenuItem file_export;
    JMenuItem file_exit;
    JMenuItem edit_cut;
    JMenuItem edit_copy;
    JMenuItem edit_paste;
    JMenuItem edit_undo;
    JMenuItem edit_redo;
    JMenuItem check_safe;
    JMenuItem check_progress;
    JMenuItem check_reachable;
    JMenuItem check_stop;
    JMenuItem build_parse;
    JMenuItem build_compile;
    JMenuItem build_compose;
    JMenuItem build_minimise;
    JMenuItem help_about;
    JMenuItem supertrace_options;
    JMenu check_run;
    JMenu file_example;
    JMenu check_liveness;
    JMenuItem default_run;
    JMenuItem[] run_items;
    JMenuItem[] assert_items;
    String[] run_names;
    String[] assert_names;
    boolean[] run_enabled;
    JCheckBoxMenuItem setWarnings;
    JCheckBoxMenuItem setWarningsAreErrors;
    JCheckBoxMenuItem setFair;
    JCheckBoxMenuItem setPartialOrder;
    JCheckBoxMenuItem setObsEquiv;
    JCheckBoxMenuItem setReduction;
    JCheckBoxMenuItem setBigFont;
    JCheckBoxMenuItem setDisplayName;
    JCheckBoxMenuItem setNewLabelFormat;
    JCheckBoxMenuItem setAutoRun;
    JCheckBoxMenuItem setMultipleLTS;
    JCheckBoxMenuItem help_manual;
    JCheckBoxMenuItem window_alpha;
    JCheckBoxMenuItem window_print;
    JCheckBoxMenuItem window_draw;
    JMenuBar mb;
    JCheckBoxMenuItem window_msc;
    Map o_plugins;
    JButton stopTool;
    JButton parseTool;
    JButton safetyTool;
    JButton progressTool;
    JButton copyTool;
    JButton cutTool;
    JButton pasteTool;
    JButton newFileTool;
    JButton openFileTool;
    JButton saveFileTool;
    JButton compileTool;
    JButton composeTool;
    JButton minimizeTool;
    JButton undoTool;
    JButton redoTool;
    int fPos = -1;
    String fSrc = "\n";
    Font fixed = new Font("Monospaced", 0, 12);
    Font big = new Font("Monospaced", 1, 18);
    private AppletButton isApplet = null;
    private static final int DO_safety = 1;
    private static final int DO_execute = 3;
    private static final int DO_reachable = 4;
    private static final int DO_compile = 5;
    private static final int DO_doComposition = 6;
    private static final int DO_minimiseComposition = 7;
    private static final int DO_progress = 8;
    private static final int DO_liveness = 9;
    private static final int DO_parse = 10;
    private int theAction = 0;
    private Thread executer;
    private static final String fileType = "*.lts";
    private String openFile = "*.lts";
    String currentDirectory;
    private String savedText = "";
    private int tabindex = 0;

    public HPWindow(AppletButton appletButton) {
        Object object;
        this.isApplet = appletButton;
        SymbolTable.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.o_plugin_manager = new PluginManager(this);
        this.o_menus = new HashMap();
        this.textIO = new JTabbedPane();
        this.input = new JEditorPane();
        this.input.setEditorKit(new ColoredEditorKit());
        this.input.setFont(this.fixed);
        this.input.setBackground(Color.white);
        this.input.getDocument().addUndoableEditListener(this.undoHandler);
        this.undo.setLimit(10);
        this.input.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.input, 22, 30);
        this.textIO.addTab("Edit", jScrollPane);
        this.output = new JTextArea("", 30, 100);
        this.output.setEditable(false);
        this.output.setFont(this.fixed);
        this.output.setBackground(Color.white);
        this.output.setLineWrap(true);
        this.output.setWrapStyleWord(true);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane jScrollPane2 = new JScrollPane(this.output, 22, 31);
        this.textIO.addTab("Output", jScrollPane2);
        this.textIO.addChangeListener(new TabChange());
        this.getContentPane().add("Center", this.textIO);
        this.o_plugin_buttons = new HashMap();
        Iterator iterator = this.o_plugin_manager.getPluginIterator();
        while (iterator.hasNext()) {
            object = (LTSAPlugin)iterator.next();
            if (!((LTSAPlugin)object).addAsTab()) continue;
            this.textIO.addTab(((LTSAPlugin)object).getName(), ((LTSAPlugin)object).getComponent());
        }
        this.mb = new JMenuBar();
        this.setJMenuBar(this.mb);
        this.file = new JMenu("File");
        this.mb.add(this.file);
        this.o_menus.put("File", this.file);
        this.file_new = new JMenuItem("New");
        this.file_new.addActionListener(new NewFileAction());
        this.file.add(this.file_new);
        this.file_open = new JMenuItem("Open...");
        this.file_open.addActionListener(new OpenFileAction());
        this.file.add(this.file_open);
        this.file_save = new JMenuItem("Save");
        this.file_save.addActionListener(new SaveFileAction());
        this.file.add(this.file_save);
        this.file_saveAs = new JMenuItem("Save as...");
        this.file_saveAs.addActionListener(new SaveAsFileAction());
        this.file.add(this.file_saveAs);
        this.file_export = new JMenuItem("Export...");
        this.file_export.addActionListener(new ExportFileAction());
        this.file.add(this.file_export);
        this.file_example = new JMenu("Examples");
        new Examples(this.file_example, this).getExamples();
        this.file.add(this.file_example);
        this.file_exit = new JMenuItem("Quit");
        this.file_exit.addActionListener(new ExitFileAction());
        this.file.add(this.file_exit);
        this.edit = new JMenu("Edit");
        this.mb.add(this.edit);
        this.o_menus.put("Edit", this.edit);
        this.edit_cut = new JMenuItem("Cut");
        this.edit_cut.addActionListener(new EditCutAction());
        this.edit.add(this.edit_cut);
        this.edit_copy = new JMenuItem("Copy");
        this.edit_copy.addActionListener(new EditCopyAction());
        this.edit.add(this.edit_copy);
        this.edit_paste = new JMenuItem("Paste");
        this.edit_paste.addActionListener(new EditPasteAction());
        this.edit.add(this.edit_paste);
        this.edit.addSeparator();
        this.edit_undo = new JMenuItem("Undo");
        this.edit_undo.addActionListener(new UndoAction());
        this.edit.add(this.edit_undo);
        this.edit_redo = new JMenuItem("Redo");
        this.edit_redo.addActionListener(new RedoAction());
        this.edit.add(this.edit_redo);
        this.check = new JMenu("Check");
        this.mb.add(this.check);
        this.o_menus.put("Check", this.check);
        this.check_safe = new JMenuItem("Safety");
        this.check_safe.addActionListener(new DoAction(1));
        this.check.add(this.check_safe);
        this.check_progress = new JMenuItem("Progress");
        this.check_progress.addActionListener(new DoAction(8));
        this.check.add(this.check_progress);
        this.check_liveness = new JMenu("LTL property");
        if (this.hasLTL2BuchiJar()) {
            this.check.add(this.check_liveness);
        }
        this.check_run = new JMenu("Run");
        this.check.add(this.check_run);
        this.default_run = new JMenuItem(DEFAULT);
        this.default_run.addActionListener(new ExecuteAction(DEFAULT));
        this.check_run.add(this.default_run);
        this.check_reachable = new JMenuItem("Supertrace");
        this.check_reachable.addActionListener(new DoAction(4));
        this.check.add(this.check_reachable);
        this.check_stop = new JMenuItem("Stop");
        this.check_stop.addActionListener(new StopAction());
        this.check_stop.setEnabled(false);
        this.check.add(this.check_stop);
        this.build = new JMenu("Build");
        this.mb.add(this.build);
        this.o_menus.put("Build", this.build);
        this.build_parse = new JMenuItem("Parse");
        this.build_parse.addActionListener(new DoAction(10));
        this.build.add(this.build_parse);
        this.build_compile = new JMenuItem("Compile");
        this.build_compile.addActionListener(new DoAction(5));
        this.build.add(this.build_compile);
        this.build_compose = new JMenuItem("Compose");
        this.build_compose.addActionListener(new DoAction(6));
        this.build.add(this.build_compose);
        this.build_minimise = new JMenuItem("Minimise");
        this.build_minimise.addActionListener(new DoAction(7));
        this.build.add(this.build_minimise);
        this.window = new JMenu("Window");
        this.mb.add(this.window);
        this.o_menus.put("Window", this.window);
        this.window_alpha = new JCheckBoxMenuItem("Alphabet");
        this.window_alpha.setSelected(false);
        this.window_alpha.addActionListener(new WinAlphabetAction());
        this.window.add(this.window_alpha);
        this.window_print = new JCheckBoxMenuItem("Transitions");
        this.window_print.setSelected(false);
        this.window_print.addActionListener(new WinPrintAction());
        this.window.add(this.window_print);
        this.window_draw = new JCheckBoxMenuItem("Draw");
        this.window_draw.setSelected(true);
        this.window_draw.addActionListener(new WinDrawAction());
        this.window.add(this.window_draw);
        this.help = new JMenu("Help");
        this.mb.add(this.help);
        this.o_menus.put("Help", this.help);
        this.help_about = new JMenuItem("About");
        this.help_about.addActionListener(new HelpAboutAction());
        this.help.add(this.help_about);
        this.help_manual = new JCheckBoxMenuItem("Manual");
        this.help_manual.setSelected(false);
        this.help_manual.addActionListener(new HelpManualAction());
        this.help.add(this.help_manual);
        object = new OptionAction();
        this.option = new JMenu("Options");
        this.mb.add(this.option);
        this.o_menus.put("Options", this.option);
        this.setWarnings = new JCheckBoxMenuItem("Display warning messages");
        this.setWarnings.addActionListener((ActionListener)object);
        this.option.add(this.setWarnings);
        this.setWarnings.setSelected(true);
        this.setWarningsAreErrors = new JCheckBoxMenuItem("Treat warnings as errors");
        this.setWarningsAreErrors.addActionListener((ActionListener)object);
        this.option.add(this.setWarningsAreErrors);
        this.setWarningsAreErrors.setSelected(false);
        this.setFair = new JCheckBoxMenuItem("Fair Choice for LTL check");
        this.setFair.addActionListener((ActionListener)object);
        this.option.add(this.setFair);
        this.setFair.setSelected(true);
        this.setPartialOrder = new JCheckBoxMenuItem("Partial Order Reduction");
        this.setPartialOrder.addActionListener((ActionListener)object);
        this.option.add(this.setPartialOrder);
        this.setPartialOrder.setSelected(false);
        this.setObsEquiv = new JCheckBoxMenuItem("Preserve OE for POR composition");
        this.setObsEquiv.addActionListener((ActionListener)object);
        this.option.add(this.setObsEquiv);
        this.setObsEquiv.setSelected(true);
        this.setReduction = new JCheckBoxMenuItem("Enable Tau Reduction");
        this.setReduction.addActionListener((ActionListener)object);
        this.option.add(this.setReduction);
        this.setReduction.setSelected(true);
        this.supertrace_options = new JMenuItem("Set Supertrace parameters");
        this.supertrace_options.addActionListener(new SuperTraceOptionListener());
        this.option.add(this.supertrace_options);
        this.option.addSeparator();
        this.setBigFont = new JCheckBoxMenuItem("Use big font");
        this.setBigFont.addActionListener((ActionListener)object);
        this.option.add(this.setBigFont);
        this.setBigFont.setSelected(false);
        this.setDisplayName = new JCheckBoxMenuItem("Display name when drawing LTS");
        this.setDisplayName.addActionListener((ActionListener)object);
        this.option.add(this.setDisplayName);
        this.setDisplayName.setSelected(true);
        this.setNewLabelFormat = new JCheckBoxMenuItem("Use V2.0 label format when drawing LTS");
        this.setNewLabelFormat.addActionListener((ActionListener)object);
        this.option.add(this.setNewLabelFormat);
        this.setNewLabelFormat.setSelected(true);
        this.setMultipleLTS = new JCheckBoxMenuItem("Multiple LTS in Draw window");
        this.setMultipleLTS.addActionListener((ActionListener)object);
        this.option.add(this.setMultipleLTS);
        this.setMultipleLTS.setSelected(false);
        this.option.addSeparator();
        this.setAutoRun = new JCheckBoxMenuItem("Auto run actions in Animator");
        this.setAutoRun.addActionListener((ActionListener)object);
        this.option.add(this.setAutoRun);
        this.setAutoRun.setSelected(false);
        this.tools = new JToolBar();
        this.tools.setFloatable(false);
        this.newFileTool = this.createTool("/ic/doc/ltsa/icon/new.gif", "New file", new NewFileAction());
        this.tools.add(this.newFileTool);
        this.openFileTool = this.createTool("/ic/doc/ltsa/icon/open.gif", "Open file", new OpenFileAction());
        this.tools.add(this.openFileTool);
        this.saveFileTool = this.createTool("/ic/doc/ltsa/icon/save.gif", "Save File", new SaveFileAction());
        this.tools.add(this.saveFileTool);
        this.tools.addSeparator();
        this.cutTool = this.createTool("/ic/doc/ltsa/icon/cut.gif", "Cut", new EditCutAction());
        this.tools.add(this.cutTool);
        this.copyTool = this.createTool("/ic/doc/ltsa/icon/copy.gif", "Copy", new EditCopyAction());
        this.tools.add(this.copyTool);
        this.pasteTool = this.createTool("/ic/doc/ltsa/icon/paste.gif", "Paste", new EditPasteAction());
        this.tools.add(this.pasteTool);
        this.undoTool = this.createTool("/ic/doc/ltsa/icon/undo.gif", "Undo", new UndoAction());
        this.tools.add(this.undoTool);
        this.redoTool = this.createTool("/ic/doc/ltsa/icon/redo.gif", "Redo", new RedoAction());
        this.tools.add(this.redoTool);
        this.tools.addSeparator();
        this.parseTool = this.createTool("/ic/doc/ltsa/icon/parse.gif", "Parse", new DoAction(10));
        this.tools.add(this.parseTool);
        this.compileTool = this.createTool("/ic/doc/ltsa/icon/compile.gif", "Compile", new DoAction(5));
        this.tools.add(this.compileTool);
        this.composeTool = this.createTool("/ic/doc/ltsa/icon/compose.gif", "Compose", new DoAction(6));
        this.tools.add(this.composeTool);
        this.minimizeTool = this.createTool("/ic/doc/ltsa/icon/minimize.gif", "Minimize", new DoAction(7));
        this.tools.add(this.minimizeTool);
        Iterator iterator2 = this.o_plugin_manager.getPluginIterator();
        while (iterator2.hasNext()) {
            List list;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            LTSAPlugin lTSAPlugin = (LTSAPlugin)iterator2.next();
            if (lTSAPlugin.addToolbarButtons()) {
                this.tools.addSeparator();
                object6 = lTSAPlugin.getToolbarButtons();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (LTSAButton)object5.next();
                    this.tools.add((Component)object4);
                    this.o_plugin_buttons.put(object4, lTSAPlugin);
                }
                if (!iterator2.hasNext()) {
                    this.tools.addSeparator();
                }
            }
            if (!lTSAPlugin.addMenuItems()) continue;
            object6 = lTSAPlugin.getMenuItems();
            object5 = new HashMap();
            object4 = object6.keySet().iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                object2 = object6.get(object3);
                if (object5.get(object2) == null) {
                    object5.put(object2, new ArrayList());
                }
                list = (List)object5.get(object2);
                list.add(object3);
            }
            object3 = object5.keySet().iterator();
            while (object3.hasNext()) {
                JMenu jMenu;
                object2 = (String)object3.next();
                list = (List)object5.get(object2);
                if (this.o_menus.get(object2) == null) {
                    jMenu = new JMenu((String)object2);
                    this.o_menus.put(object2, jMenu);
                    this.mb.add(jMenu);
                } else {
                    jMenu = (JMenu)this.o_menus.get(object2);
                    jMenu.addSeparator();
                }
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    jMenu.add((JMenuItem)iterator3.next());
                }
            }
        }
        this.targetChoice = new JComboBox();
        this.targetChoice.setEditable(false);
        this.targetChoice.addItem(DEFAULT);
        this.targetChoice.setToolTipText("Target Composition");
        this.targetChoice.setRequestFocusEnabled(false);
        this.targetChoice.addActionListener(new TargetAction());
        this.tools.add(this.targetChoice);
        this.tools.addSeparator();
        this.safetyTool = this.createTool("/ic/doc/ltsa/icon/safety.gif", "Check safety", new DoAction(1));
        this.tools.add(this.safetyTool);
        this.progressTool = this.createTool("/ic/doc/ltsa/icon/progress.gif", "Check Progress", new DoAction(8));
        this.tools.add(this.progressTool);
        this.stopTool = this.createTool("/ic/doc/ltsa/icon/stop.gif", "Stop", new StopAction());
        this.tools.add(this.stopTool);
        this.stopTool.setEnabled(false);
        this.tools.addSeparator();
        this.tools.add(this.createTool("/ic/doc/ltsa/icon/alphabet.gif", "Run DEFAULT Animation", new ExecuteAction(DEFAULT)));
        this.tools.add(this.createTool("/ic/doc/ltsa/icon/blanker.gif", "Blank Screen", new BlankAction()));
        this.tools.addSeparator();
        this.getContentPane().add("North", this.tools);
        this.menuEnable(true);
        this.file_save.setEnabled(this.isApplet == null);
        this.file_saveAs.setEnabled(this.isApplet == null);
        this.file_export.setEnabled(this.isApplet == null);
        this.saveFileTool.setEnabled(this.isApplet == null);
        this.updateDoState();
        LTSCanvas.displayName = this.setDisplayName.isSelected();
        LTSCanvas.newLabelFormat = this.setNewLabelFormat.isSelected();
        LTSDrawWindow.singleMode = !this.setMultipleLTS.isSelected();
        this.newDrawWindow(this.window_draw.isSelected());
        this.swapto(0);
        this.setEditControls(0);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseWindow());
    }

    static void centre(Component component) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = component.getSize();
        double d = (dimension.getWidth() - dimension2.getWidth()) / 2.0;
        double d2 = (dimension.getHeight() - dimension2.getHeight()) / 2.0;
        component.setLocation((int)d, (int)d2);
    }

    void left(Component component) {
        Point point = this.getLocationOnScreen();
        point.translate(10, 100);
        component.setLocation(point);
    }

    protected JButton createTool(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton((Icon)new ImageIcon(this.getClass().getResource(string))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    void menuEnable(boolean bl) {
        this.tabindex = this.textIO.getSelectedIndex();
        String string = this.textIO.getTitleAt(this.tabindex);
        boolean bl2 = this.tabindex == 0;
        LTSAPlugin lTSAPlugin = this.o_plugin_manager.getPlugin(string);
        boolean bl3 = this.isApplet == null;
        this.file_new.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesNewFile()));
        this.file_example.setEnabled(bl && bl2);
        this.file_open.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesOpenFile()));
        this.file_exit.setEnabled(bl);
        this.check_safe.setEnabled(bl);
        this.check_progress.setEnabled(bl);
        this.check_run.setEnabled(bl);
        this.check_reachable.setEnabled(bl);
        this.build_parse.setEnabled(bl);
        this.build_compile.setEnabled(bl);
        this.build_compose.setEnabled(bl);
        this.build_minimise.setEnabled(bl);
        this.parseTool.setEnabled(bl);
        this.safetyTool.setEnabled(bl);
        this.progressTool.setEnabled(bl);
        this.compileTool.setEnabled(bl);
        this.composeTool.setEnabled(bl);
        this.minimizeTool.setEnabled(bl);
        Iterator iterator = this.o_plugin_buttons.keySet().iterator();
        while (iterator.hasNext()) {
            LTSAButton lTSAButton = (LTSAButton)iterator.next();
            LTSAPlugin lTSAPlugin2 = (LTSAPlugin)this.o_plugin_buttons.get(lTSAButton);
            if (lTSAPlugin2 != null && lTSAPlugin2.addAsTab()) {
                lTSAButton.setEnabled(lTSAPlugin == lTSAPlugin2);
                continue;
            }
            lTSAButton.setEnabled(true);
        }
    }

    private void do_action(int n) {
        this.menuEnable(false);
        this.check_stop.setEnabled(true);
        this.stopTool.setEnabled(true);
        this.theAction = n;
        this.executer = new Thread(this);
        this.executer.setPriority(4);
        this.executer.start();
    }

    public void run() {
        try {
            switch (this.theAction) {
                case 1: {
                    this.showOutput();
                    this.safety();
                    break;
                }
                case 3: {
                    this.execute();
                    break;
                }
                case 4: {
                    this.showOutput();
                    this.reachable();
                    break;
                }
                case 5: {
                    this.showOutput();
                    this.compile();
                    break;
                }
                case 6: {
                    this.showOutput();
                    this.doComposition();
                    break;
                }
                case 7: {
                    this.showOutput();
                    this.minimiseComposition();
                    break;
                }
                case 8: {
                    this.showOutput();
                    this.progress();
                    break;
                }
                case 9: {
                    this.showOutput();
                    this.liveness();
                    break;
                }
                case 10: {
                    this.parse();
                }
            }
        }
        catch (Throwable throwable) {
            this.showOutput();
            this.outln("**** Runtime Exception: " + throwable);
            throwable.printStackTrace();
        }
        this.menuEnable(true);
        this.check_stop.setEnabled(false);
        this.stopTool.setEnabled(false);
    }

    public void invalidateState() {
        this.current = null;
        this.targetChoice.removeAllItems();
        this.targetChoice.addItem(DEFAULT);
        this.check_run.removeAll();
        this.check_run.add(this.default_run);
        this.run_items = null;
        this.assert_items = null;
        this.run_names = null;
        this.check_liveness.removeAll();
        this.validate();
        this.eman.post(new LTSEvent(1, null));
        if (this.animator != null) {
            this.animator.dispose();
            this.animator = null;
        }
    }

    public void postState(CompositeState compositeState) {
        if (this.animator != null) {
            this.animator.dispose();
            this.animator = null;
        }
        this.eman.post(new LTSEvent(1, compositeState));
    }

    private void newFile() {
        if (this.checkSave()) {
            this.setTitle("LTS Analyser");
            this.savedText = "";
            this.openFile = fileType;
            this.input.setText("");
            this.swapto(0);
            this.output.setText("");
            this.invalidateState();
        }
        this.repaint();
    }

    public void newExample(String string, String string2) {
        this.undo.discardAllEdits();
        this.input.getDocument().removeUndoableEditListener(this.undoHandler);
        if (this.checkSave()) {
            this.invalidateState();
            this.clearOutput();
            this.doOpenFile(string, string2, true);
        }
        this.input.getDocument().addUndoableEditListener(this.undoHandler);
        this.updateDoState();
        this.repaint();
    }

    private void openAFile() {
        if (this.checkSave()) {
            String string;
            LTSAPlugin lTSAPlugin;
            this.invalidateState();
            this.clearOutput();
            FileDialog fileDialog = new FileDialog((Frame)this, "Select source file:");
            if (this.currentDirectory != null) {
                fileDialog.setDirectory(this.currentDirectory);
            }
            if ((lTSAPlugin = this.o_plugin_manager.getPlugin(string = this.textIO.getTitleAt(this.textIO.getSelectedIndex()))) != null && lTSAPlugin.getFileExtension() != null) {
                fileDialog.setFile("*." + lTSAPlugin.getFileExtension());
            } else {
                fileDialog.setFile(fileType);
            }
            fileDialog.show();
            this.currentDirectory = fileDialog.getDirectory();
            this.doOpenFile(this.currentDirectory, fileDialog.getFile(), false);
        }
        this.repaint();
    }

    private void doOpenFile(String string, String string2, boolean bl) {
        if (string2 != null) {
            try {
                InputStream inputStream;
                Object object;
                Object object2;
                this.openFile = string2;
                this.setTitle("LTSA - " + this.openFile);
                if (!bl) {
                    object2 = this.textIO.getTitleAt(this.textIO.getSelectedIndex());
                    object = this.o_plugin_manager.getPlugin((String)object2);
                    if (object != null && ((LTSAPlugin)object).providesOpenFile()) {
                        ((LTSAPlugin)object).openFile(new File(string + this.openFile));
                        return;
                    }
                    inputStream = new FileInputStream(string + this.openFile);
                } else {
                    inputStream = this.getClass().getResourceAsStream(string + this.openFile);
                }
                try {
                    object2 = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((object = ((BufferedReader)object2).readLine()) != null) {
                            stringBuffer.append((String)object + "\n");
                        }
                        this.savedText = stringBuffer.toString();
                        this.input.setText(this.savedText);
                        this.parse();
                    }
                    catch (Exception exception) {
                        this.outln("Error reading file: " + exception);
                    }
                }
                catch (Exception exception) {
                    this.outln("Error creating InputStream: " + exception);
                }
            }
            catch (Exception exception) {
                this.outln("Error creating FileInputStream: " + exception);
            }
        }
    }

    private void saveAsFile() {
        String string;
        LTSAPlugin lTSAPlugin;
        FileDialog fileDialog = new FileDialog((Frame)this, "Save file in:", 1);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        if ((lTSAPlugin = this.o_plugin_manager.getPlugin(string = this.textIO.getTitleAt(this.textIO.getSelectedIndex()))) != null && lTSAPlugin.getFileExtension() != null) {
            fileDialog.setFile("*." + lTSAPlugin.getFileExtension());
        } else {
            fileDialog.setFile(this.openFile);
        }
        fileDialog.show();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            if (lTSAPlugin != null && lTSAPlugin.providesSaveFile()) {
                try {
                    lTSAPlugin.saveFile(new FileOutputStream(fileDialog.getDirectory() + fileDialog.getFile()));
                }
                catch (IOException iOException) {
                    this.outln("File not found : " + fileDialog.getDirectory() + fileDialog.getFile());
                }
                return;
            }
            this.currentDirectory = fileDialog.getDirectory();
            this.openFile = string2;
            this.setTitle("LTSA - " + this.openFile);
            this.saveFile();
        }
    }

    private void saveFile() {
        String string = this.textIO.getTitleAt(this.textIO.getSelectedIndex());
        LTSAPlugin lTSAPlugin = this.o_plugin_manager.getPlugin(string);
        if (lTSAPlugin != null && lTSAPlugin.providesSaveFile()) {
            this.saveAsFile();
        } else if (this.openFile != null && this.openFile.equals(fileType)) {
            this.saveAsFile();
        } else if (this.openFile != null) {
            try {
                int n = this.openFile.indexOf(46, 0);
                this.openFile = n > 0 ? this.openFile.substring(0, n) + "." + "lts" : this.openFile + ".lts";
                String string2 = this.currentDirectory == null ? this.openFile : this.currentDirectory + this.openFile;
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                PrintStream printStream = new PrintStream(fileOutputStream);
                this.savedText = this.input.getText();
                printStream.print(this.savedText);
                printStream.close();
                fileOutputStream.close();
                this.outln("Saved in: " + string2);
            }
            catch (IOException iOException) {
                this.outln("Error saving file: " + iOException);
            }
        }
    }

    private void exportFile() {
        String string = "Export as Aldebaran format (.aut) to:";
        FileDialog fileDialog = new FileDialog((Frame)this, string, 1);
        if (this.current == null || this.current.composition == null) {
            JOptionPane.showMessageDialog(this, "No target composition to export");
            return;
        }
        String string2 = this.current.composition.name;
        fileDialog.setFile(string2 + ".aut");
        fileDialog.setDirectory(this.currentDirectory);
        fileDialog.show();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            try {
                int n = string3.indexOf(46, 0);
                string3 = string3.substring(0, n) + ".aut";
                File file = new File(fileDialog.getDirectory(), string3);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintStream printStream = new PrintStream(fileOutputStream);
                this.current.composition.printAUT(printStream);
                printStream.close();
                fileOutputStream.close();
                this.outln("Exported to: " + fileDialog.getDirectory() + file);
            }
            catch (IOException iOException) {
                this.outln("Error exporting file: " + iOException);
            }
        }
    }

    private boolean checkSave() {
        if (this.isApplet != null) {
            return true;
        }
        if (!this.savedText.equals(this.input.getText())) {
            int n = JOptionPane.showConfirmDialog(this, "Do you want to save the contents of " + this.openFile);
            if (n == 0) {
                this.saveFile();
                return true;
            }
            if (n == 1) {
                return true;
            }
            if (n == 2) {
                return false;
            }
        }
        return true;
    }

    private void doFont() {
        if (this.setBigFont.getState()) {
            this.input.setFont(this.big);
            this.output.setFont(this.big);
        } else {
            this.input.setFont(this.fixed);
            this.output.setFont(this.fixed);
        }
        this.pack();
        this.show();
    }

    private void quitAll() {
        if (this.isApplet != null) {
            this.dispose();
            this.isApplet.ended();
        } else if (this.checkSave()) {
            System.exit(0);
        }
    }

    public void updateDoState() {
        this.edit_undo.setEnabled(this.undo.canUndo());
        this.undoTool.setEnabled(this.undo.canUndo());
        this.edit_redo.setEnabled(this.undo.canRedo());
        this.redoTool.setEnabled(this.undo.canRedo());
    }

    private void swapto(int n) {
        if (n == this.tabindex) {
            return;
        }
        this.textIO.setBackgroundAt(n, Color.green);
        if (this.tabindex != n && this.tabindex < this.textIO.getTabCount()) {
            this.textIO.setBackgroundAt(this.tabindex, Color.lightGray);
        }
        this.tabindex = n;
        this.setEditControls(this.tabindex);
        this.textIO.setSelectedIndex(n);
    }

    public void swapto(String string) {
        this.swapto(this.textIO.indexOfTab(string));
    }

    private void setEditControls(int n) {
        boolean bl = this.isApplet == null;
        n = this.textIO.getSelectedIndex();
        String string = this.textIO.getTitleAt(n);
        boolean bl2 = n == 0;
        LTSAPlugin lTSAPlugin = this.o_plugin_manager.getPlugin(string);
        if (lTSAPlugin != null && lTSAPlugin.useOwnMenuBar()) {
            this.setJMenuBar(lTSAPlugin.getMenuBar());
            return;
        }
        this.setJMenuBar(this.mb);
        this.edit_cut.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesCut());
        this.cutTool.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesCut());
        this.edit_paste.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesPaste());
        this.pasteTool.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesPaste());
        this.edit_copy.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesCopy());
        this.copyTool.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesCopy());
        this.file_new.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesNewFile());
        this.file_example.setEnabled(bl2);
        this.file_open.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesOpenFile()));
        this.file_save.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesSaveFile()));
        this.file_saveAs.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesSaveFile()));
        this.file_export.setEnabled(bl && (bl2 || string.equals("Transitions")));
        this.newFileTool.setEnabled(bl2 || lTSAPlugin != null && lTSAPlugin.providesNewFile());
        this.openFileTool.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesOpenFile()));
        this.saveFileTool.setEnabled(bl && (bl2 || lTSAPlugin != null && lTSAPlugin.providesSaveFile()));
        this.edit_undo.setEnabled(bl2 && this.undo.canUndo());
        this.undoTool.setEnabled(bl2 && this.undo.canUndo());
        this.edit_redo.setEnabled(bl2 && this.undo.canRedo());
        this.redoTool.setEnabled(bl2 && this.undo.canRedo());
        if (bl2) {
            this.input.requestFocusInWindow();
        }
        Iterator iterator = this.o_plugin_buttons.keySet().iterator();
        while (iterator.hasNext()) {
            LTSAButton lTSAButton = (LTSAButton)iterator.next();
            LTSAPlugin lTSAPlugin2 = (LTSAPlugin)this.o_plugin_buttons.get(lTSAButton);
            if (lTSAPlugin2 != null && lTSAPlugin2.addAsTab()) {
                lTSAButton.setEnabled(lTSAPlugin == lTSAPlugin2);
                continue;
            }
            lTSAButton.setEnabled(true);
        }
    }

    public void out(String string) {
        SwingUtilities.invokeLater(new OutputAppend(string));
    }

    public void outln(String string) {
        SwingUtilities.invokeLater(new OutputAppend(string + "\n"));
    }

    public void clearOutput() {
        SwingUtilities.invokeLater(new OutputClear());
    }

    public void showOutput() {
        SwingUtilities.invokeLater(new OutputShow());
    }

    public char nextChar() {
        ++this.fPos;
        if (this.fPos < this.fSrc.length()) {
            return this.fSrc.charAt(this.fPos);
        }
        return '\u0000';
    }

    public char backChar() {
        --this.fPos;
        if (this.fPos < 0) {
            this.fPos = 0;
            return '\u0000';
        }
        return this.fSrc.charAt(this.fPos);
    }

    public int getMarker() {
        return this.fPos;
    }

    private void compile() {
        this.clearOutput();
        if (!this.parse()) {
            return;
        }
        this.current = this.docompile();
        if (this.current != null) {
            this.postState(this.current);
        }
    }

    private void displayError(LTSException lTSException) {
        if (lTSException.marker != null) {
            int n = (Integer)lTSException.marker;
            int n2 = 1;
            int n3 = 0;
            while (n3 < n) {
                if (this.fSrc.charAt(n3) == '\n') {
                    ++n2;
                }
                ++n3;
            }
            this.outln("ERROR line:" + n2 + " - " + lTSException.getMessage());
            this.input.select(n, n + 1);
        } else {
            this.outln("ERROR - " + lTSException.getMessage());
        }
    }

    private CompositeState docompile() {
        this.fPos = -1;
        this.fSrc = this.input.getText();
        CompositeState compositeState = null;
        LTSCompiler lTSCompiler = new LTSCompiler(this, this, this.currentDirectory);
        try {
            compositeState = lTSCompiler.compile((String)this.targetChoice.getSelectedItem());
        }
        catch (LTSException lTSException) {
            this.displayError(lTSException);
        }
        return compositeState;
    }

    private Hashtable doparse() {
        this.fPos = -1;
        this.fSrc = this.input.getText();
        LTSCompiler lTSCompiler = new LTSCompiler(this, this, this.currentDirectory);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        try {
            lTSCompiler.parse(hashtable, hashtable2);
        }
        catch (LTSException lTSException) {
            this.displayError(lTSException);
            return null;
        }
        return hashtable;
    }

    private void compileIfChange() {
        String string = this.input.getText();
        if (this.current == null || !string.equals(this.fSrc) || !this.current.name.equals(this.targetChoice.getSelectedItem())) {
            this.compile();
        }
    }

    private void safety() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            this.current.analyse(this);
        }
    }

    private void progress() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            this.current.checkProgress(this);
        }
    }

    private void liveness() {
        this.clearOutput();
        this.compileIfChange();
        CompositeState compositeState = AssertDefinition.compile(this, this.asserted);
        if (this.current != null && compositeState != null) {
            this.current.checkLTL(this, compositeState);
            this.postState(this.current);
        }
    }

    private void minimiseComposition() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            if (this.current.composition == null) {
                this.current.compose(this);
            }
            this.current.minimise(this);
            this.postState(this.current);
        }
    }

    private void doComposition() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            this.current.compose(this);
            this.postState(this.current);
        }
    }

    public void compileNoClear() {
        if (!this.parse()) {
            return;
        }
        this.current = this.docompile();
        if (this.current != null) {
            this.postState(this.current);
        }
    }

    private boolean checkReplay(Animator animator) {
        if (animator.hasErrorTrace()) {
            int n = JOptionPane.showConfirmDialog(this, "Do you want to replay the error trace?");
            if (n == 0) {
                return true;
            }
            if (n == 1) {
                return false;
            }
            if (n == 2) {
                return false;
            }
        }
        return false;
    }

    private void execute() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            Analyser analyser = new Analyser(this.current, this, this.eman);
            boolean bl = this.checkReplay(analyser);
            if (this.animator != null) {
                this.animator.dispose();
                this.animator = null;
            }
            RunMenu runMenu = null;
            if (RunMenu.menus != null) {
                runMenu = (RunMenu)RunMenu.menus.get(this.run_menu);
            }
            this.animator = runMenu != null && runMenu.isCustom() ? this.createCustom(analyser, runMenu.params, runMenu.actions, runMenu.controls, bl) : new AnimWindow(analyser, runMenu, this.setAutoRun.getState(), bl);
            if (this.animator != null) {
                this.animator.pack();
                this.left(this.animator);
                this.animator.setVisible(true);
            }
        }
    }

    private JFrame createCustom(Animator animator, String string, Relation relation, Relation relation2, boolean bl) {
        LTSAPlugin lTSAPlugin = this.o_plugin_manager.getPlugin("SceneBeans");
        if (lTSAPlugin != null) {
            System.err.println("x_scenebeans != null");
            try {
                Initialisable initialisable = (Initialisable)((Object)lTSAPlugin);
                initialisable.initialise(new Object[]{animator, string, relation, relation2, new Boolean(bl), this.currentDirectory});
                return (JFrame)lTSAPlugin.getComponent();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.outln("** Failed to create instance of Scene Animator");
        return null;
    }

    private void reachable() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null && this.current.machines.size() > 0) {
            Analyser analyser = new Analyser(this.current, this, null);
            SuperTrace superTrace = new SuperTrace(analyser, this);
            this.current.setErrorTrace(superTrace.getErrorTrace());
        }
    }

    private void newDrawWindow(boolean bl) {
        if (bl && this.textIO.indexOfTab("Draw") < 0) {
            this.draws = new LTSDrawWindow(this.current, this.eman);
            this.textIO.addTab("Draw", this.draws);
            this.swapto(this.textIO.indexOfTab("Draw"));
        } else if (!bl && this.textIO.indexOfTab("Draw") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Draw"));
            this.draws.removeClient();
            this.draws = null;
        }
    }

    private void newMSCWindow(boolean bl) {
        if (bl && this.textIO.indexOfTab("MSC Editor") < 0) {
            this.swapto(this.textIO.indexOfTab("MSC Editor"));
        } else if (!bl && this.textIO.indexOfTab("MSC Editor") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("MSC Editor"));
        }
    }

    private void newPrintWindow(boolean bl) {
        if (bl && this.textIO.indexOfTab("Transitions") < 0) {
            this.prints = new PrintWindow(this.current, this.eman);
            this.textIO.addTab("Transitions", this.prints);
            this.swapto(this.textIO.indexOfTab("Transitions"));
        } else if (!bl && this.textIO.indexOfTab("Transitions") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Transitions"));
            this.prints.removeClient();
            this.prints = null;
        }
    }

    private void newAlphabetWindow(boolean bl) {
        if (bl && this.textIO.indexOfTab("Alphabet") < 0) {
            this.alphabet = new AlphabetWindow(this.current, this.eman);
            this.textIO.addTab("Alphabet", this.alphabet);
            this.swapto(this.textIO.indexOfTab("Alphabet"));
        } else if (!bl && this.textIO.indexOfTab("Alphabet") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Alphabet"));
            this.alphabet.removeClient();
            this.alphabet = null;
        }
    }

    private void aboutDialog() {
        LTSASplash lTSASplash = new LTSASplash((Window)this);
        lTSASplash.setVisible(true);
    }

    private void blankit() {
        LTSABlanker lTSABlanker = new LTSABlanker((Window)this);
        lTSABlanker.setVisible(true);
    }

    private void setSuperTraceOption() {
        try {
            String string = (String)JOptionPane.showInputDialog(this, "Enter Hashtable size (Kilobytes):", "Supertrace parameters", -1, null, null, "" + SuperTrace.getHashSize());
            if (string == null) {
                return;
            }
            SuperTrace.setHashSize(Integer.parseInt(string));
            string = (String)JOptionPane.showInputDialog(this, "Enter bound for search depth size:", "Supertrace parameters", -1, null, null, "" + SuperTrace.getDepthBound());
            if (string == null) {
                return;
            }
            SuperTrace.setDepthBound(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean parse() {
        String string = (String)this.targetChoice.getSelectedItem();
        Hashtable hashtable = this.doparse();
        if (hashtable == null) {
            return false;
        }
        this.targetChoice.removeAllItems();
        if (hashtable.size() == 0) {
            this.targetChoice.addItem(DEFAULT);
        } else {
            Enumeration enumeration = hashtable.keys();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.targetChoice.addItem((String)iterator.next());
            }
        }
        if (string != null && !string.equals(DEFAULT) && hashtable.containsKey(string)) {
            this.targetChoice.setSelectedItem(string);
        }
        this.current = null;
        this.check_run.removeAll();
        this.run_names = MenuDefinition.names();
        this.run_enabled = MenuDefinition.enabled((String)this.targetChoice.getSelectedItem());
        this.check_run.add(this.default_run);
        if (this.run_names != null) {
            this.run_items = new JMenuItem[this.run_names.length];
            int n = 0;
            while (n < this.run_names.length) {
                this.run_items[n] = new JMenuItem(this.run_names[n]);
                this.run_items[n].setEnabled(this.run_enabled[n]);
                this.run_items[n].addActionListener(new ExecuteAction(this.run_names[n]));
                this.check_run.add(this.run_items[n]);
                ++n;
            }
        }
        this.check_liveness.removeAll();
        this.assert_names = AssertDefinition.names();
        if (this.assert_names != null) {
            this.assert_items = new JMenuItem[this.assert_names.length];
            int n = 0;
            while (n < this.assert_names.length) {
                this.assert_items[n] = new JMenuItem(this.assert_names[n]);
                this.assert_items[n].addActionListener(new LivenessAction(this.assert_names[n]));
                this.check_liveness.add(this.assert_items[n]);
                ++n;
            }
        }
        this.validate();
        return true;
    }

    private void displayManual(boolean bl) {
        if (bl && this.textIO.indexOfTab("Manual") < 0) {
            this.manual = new JEditorPane();
            this.manual.setEditable(false);
            this.manual.addHyperlinkListener(new Hyperactive());
            JScrollPane jScrollPane = new JScrollPane(this.manual, 22, 31);
            this.textIO.addTab("Manual", jScrollPane);
            this.swapto(this.textIO.indexOfTab("Manual"));
            URL uRL = this.getClass().getResource("doc/User-manual.html");
            try {
                this.manual.setPage(uRL);
            }
            catch (IOException iOException) {
                this.outln("" + iOException);
            }
        } else if (!bl && this.textIO.indexOfTab("Manual") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Manual"));
            this.manual = null;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new HPWindow(null);
        ((Frame)object).setTitle("LTS Analyser");
        ((Window)object).pack();
        HPWindow.centre((Component)object);
        ((Window)object).setVisible(true);
        if (stringArray.length > 0) {
            SwingUtilities.invokeLater(new ScheduleOpenFile((HPWindow)object, stringArray[0]));
        } else {
            ((HPWindow)object).currentDirectory = System.getProperty("user.dir");
        }
    }

    private boolean hasLTL2BuchiJar() {
        try {
            new Graph();
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public List getLTSNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.compileIfChange();
        if (this.current != null) {
            Iterator iterator = this.current.machines.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((CompactState)iterator.next()).name);
            }
        }
        return arrayList;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String string) {
        this.currentDirectory = string;
    }

    public UndoManager getUndoManager() {
        return this.undo;
    }

    public JEditorPane getInputPane() {
        return this.input;
    }

    public void setTargetChoice(String string) {
        this.targetChoice.setSelectedItem(string);
    }

    public boolean isCurrentStateNull() {
        return this.current == null;
    }

    public boolean isCurrentStateComposed() {
        return this.current.composition != null;
    }

    public void composeCurrentState() {
        this.current.compose(this);
    }

    public void analyseCurrentState() {
        this.current.analyse(this);
    }

    public Vector getCurrentStateErrorTrace() {
        return this.current.getErrorTrace();
    }

    public void postCurrentState() {
        this.postState(this.current);
    }

    public void exportGraphic(Exportable exportable) {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save file in:", 1);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (this.file != null) {
            try {
                int n = string.indexOf(46, 0);
                string = string.substring(0, n) + "." + "pct";
                FileOutputStream fileOutputStream = new FileOutputStream(fileDialog.getDirectory() + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
                Rectangle rectangle = new Rectangle(0, 0, this.input.getSize().width, this.input.getSize().height);
                Gr2PICT gr2PICT = new Gr2PICT((OutputStream)byteArrayOutputStream, this.input.getGraphics(), rectangle);
                exportable.fileDraw(gr2PICT);
                gr2PICT.finalize();
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error saving file: " + iOException);
            }
        }
    }

    public Animator getAnimator() {
        return new Analyser(this.current, this, this.eman);
    }

    static class ScheduleOpenFile
    implements Runnable {
        HPWindow window;
        String arg;

        ScheduleOpenFile(HPWindow hPWindow, String string) {
            this.window = hPWindow;
            this.arg = string;
        }

        public void run() {
            this.window.doOpenFile("", this.arg, false);
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                try {
                    URL uRL = hyperlinkEvent.getURL();
                    jEditorPane.setPage(uRL);
                }
                catch (Throwable throwable) {
                    HPWindow.this.outln("" + hyperlinkEvent);
                }
            }
        }
    }

    class OutputShow
    implements Runnable {
        OutputShow() {
        }

        public void run() {
            HPWindow.this.swapto(1);
        }
    }

    class OutputClear
    implements Runnable {
        OutputClear() {
        }

        public void run() {
            HPWindow.this.output.setText("");
        }
    }

    class OutputAppend
    implements Runnable {
        String text;

        OutputAppend(String string) {
            this.text = string;
        }

        public void run() {
            HPWindow.this.output.append(this.text);
        }
    }

    class TabChange
    implements ChangeListener {
        TabChange() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = HPWindow.this.textIO.getSelectedIndex();
            if (n == HPWindow.this.tabindex) {
                return;
            }
            HPWindow.this.textIO.setBackgroundAt(n, Color.green);
            HPWindow.this.textIO.setBackgroundAt(HPWindow.this.tabindex, Color.lightGray);
            HPWindow.this.tabindex = n;
            HPWindow.this.setEditControls(HPWindow.this.tabindex);
        }
    }

    class RedoAction
    implements ActionListener {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HPWindow.this.undo.redo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            HPWindow.this.updateDoState();
        }
    }

    class UndoAction
    implements ActionListener {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HPWindow.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            HPWindow.this.updateDoState();
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            HPWindow.this.undo.addEdit(undoableEditEvent.getEdit());
            HPWindow.this.updateDoState();
        }
    }

    class TargetAction
    implements ActionListener {
        TargetAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)HPWindow.this.targetChoice.getSelectedItem();
            if (string == null) {
                return;
            }
            HPWindow.this.run_enabled = MenuDefinition.enabled(string);
            if (HPWindow.this.run_items != null && HPWindow.this.run_enabled != null && HPWindow.this.run_items.length == HPWindow.this.run_enabled.length) {
                int n = 0;
                while (n < HPWindow.this.run_items.length) {
                    HPWindow.this.run_items[n].setEnabled(HPWindow.this.run_enabled[n]);
                    ++n;
                }
            }
        }
    }

    class EditPasteAction
    implements ActionListener {
        EditPasteAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            LTSAPlugin lTSAPlugin = HPWindow.this.o_plugin_manager.getPlugin(string);
            if (lTSAPlugin != null && lTSAPlugin.providesPaste()) {
                lTSAPlugin.paste();
            } else {
                HPWindow.this.input.paste();
            }
        }
    }

    class EditCopyAction
    implements ActionListener {
        EditCopyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            LTSAPlugin lTSAPlugin = HPWindow.this.o_plugin_manager.getPlugin(string);
            if (lTSAPlugin != null && lTSAPlugin.providesCopy()) {
                lTSAPlugin.copy();
            } else if (string.equals("Edit")) {
                HPWindow.this.input.copy();
            } else if (string.equals("Output")) {
                HPWindow.this.output.copy();
            } else if (string.equals("Manual")) {
                HPWindow.this.manual.copy();
            } else if (string.equals("Alphabet")) {
                HPWindow.this.alphabet.copy();
            } else if (string.equals("Transitions")) {
                HPWindow.this.prints.copy();
            }
        }
    }

    class EditCutAction
    implements ActionListener {
        EditCutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            LTSAPlugin lTSAPlugin = HPWindow.this.o_plugin_manager.getPlugin(string);
            if (lTSAPlugin != null && lTSAPlugin.providesCut()) {
                lTSAPlugin.cut();
            } else {
                HPWindow.this.input.cut();
            }
        }
    }

    class LivenessAction
    implements ActionListener {
        String asserttarget;

        LivenessAction(String string) {
            this.asserttarget = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.asserted = this.asserttarget;
            HPWindow.this.do_action(9);
        }
    }

    class ExecuteAction
    implements ActionListener {
        String runtarget;

        ExecuteAction(String string) {
            this.runtarget = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.run_menu = this.runtarget;
            HPWindow.this.do_action(3);
        }
    }

    class StopAction
    implements ActionListener {
        StopAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HPWindow.this.executer != null) {
                HPWindow.this.executer.stop();
                HPWindow.this.menuEnable(true);
                HPWindow.this.check_stop.setEnabled(false);
                HPWindow.this.stopTool.setEnabled(false);
                HPWindow.this.outln("\n\t-- stopped");
                HPWindow.this.executer = null;
            }
        }
    }

    class HelpManualAction
    implements ActionListener {
        HelpManualAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.displayManual(HPWindow.this.help_manual.isSelected());
        }
    }

    class BlankAction
    implements ActionListener {
        BlankAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.blankit();
        }
    }

    class HelpAboutAction
    implements ActionListener {
        HelpAboutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.aboutDialog();
        }
    }

    class WinMSCAction
    implements ActionListener {
        WinMSCAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.newMSCWindow(HPWindow.this.window_msc.isSelected());
        }
    }

    class WinDrawAction
    implements ActionListener {
        WinDrawAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.newDrawWindow(HPWindow.this.window_draw.isSelected());
        }
    }

    class WinPrintAction
    implements ActionListener {
        WinPrintAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.newPrintWindow(HPWindow.this.window_print.isSelected());
        }
    }

    class WinAlphabetAction
    implements ActionListener {
        WinAlphabetAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.newAlphabetWindow(HPWindow.this.window_alpha.isSelected());
        }
    }

    class SuperTraceOptionListener
    implements ActionListener {
        SuperTraceOptionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.setSuperTraceOption();
        }
    }

    class OptionAction
    implements ActionListener {
        OptionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == HPWindow.this.setWarnings) {
                Diagnostics.warningFlag = HPWindow.this.setWarnings.isSelected();
            } else if (object == HPWindow.this.setWarningsAreErrors) {
                Diagnostics.warningsAreErrors = HPWindow.this.setWarningsAreErrors.isSelected();
            } else if (object == HPWindow.this.setFair) {
                ProgressCheck.strongFairFlag = HPWindow.this.setFair.isSelected();
            } else if (object == HPWindow.this.setPartialOrder) {
                Analyser.partialOrderReduction = HPWindow.this.setPartialOrder.isSelected();
            } else if (object == HPWindow.this.setObsEquiv) {
                Analyser.preserveObsEquiv = HPWindow.this.setObsEquiv.isSelected();
            } else if (object == HPWindow.this.setReduction) {
                CompositeState.reduceFlag = HPWindow.this.setReduction.isSelected();
            } else if (object == HPWindow.this.setBigFont) {
                AnimWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                AlphabetWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.alphabet != null) {
                    HPWindow.this.alphabet.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                PrintWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.prints != null) {
                    HPWindow.this.prints.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                LTSDrawWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                LTSCanvas.fontFlag = HPWindow.this.setBigFont.isSelected();
                HPWindow.this.doFont();
            } else if (object == HPWindow.this.setDisplayName) {
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setDrawName(HPWindow.this.setDisplayName.isSelected());
                }
                LTSCanvas.displayName = HPWindow.this.setDisplayName.isSelected();
            } else if (object == HPWindow.this.setMultipleLTS) {
                boolean bl = LTSDrawWindow.singleMode = !HPWindow.this.setMultipleLTS.isSelected();
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setMode(LTSDrawWindow.singleMode);
                }
            } else if (object == HPWindow.this.setNewLabelFormat) {
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setNewLabelFormat(HPWindow.this.setNewLabelFormat.isSelected());
                }
                LTSCanvas.newLabelFormat = HPWindow.this.setNewLabelFormat.isSelected();
            }
        }
    }

    class DoAction
    implements ActionListener {
        int actionCode;

        DoAction(int n) {
            this.actionCode = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.do_action(this.actionCode);
        }
    }

    class ExitFileAction
    implements ActionListener {
        ExitFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.quitAll();
        }
    }

    class ExportFileAction
    implements ActionListener {
        ExportFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            if (string.equals("Edit")) {
                HPWindow.this.exportFile();
            } else if (string.equals("Transitions")) {
                HPWindow.this.prints.saveFile(HPWindow.this.currentDirectory, ".aut");
            }
        }
    }

    class SaveAsFileAction
    implements ActionListener {
        SaveAsFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.saveAsFile();
        }
    }

    class SaveFileAction
    implements ActionListener {
        SaveFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            if (string.equals("Edit") || string.equals("Output")) {
                HPWindow.this.saveFile();
            } else if (string.equals("Alphabet")) {
                HPWindow.this.alphabet.saveFile();
            } else if (string.equals("Transitions")) {
                HPWindow.this.prints.saveFile(HPWindow.this.currentDirectory, ".txt");
            } else if (string.equals("Draw")) {
                HPWindow.this.draws.saveFile();
            } else {
                HPWindow.this.saveFile();
            }
        }
    }

    class OpenFileAction
    implements ActionListener {
        OpenFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HPWindow.this.undo.discardAllEdits();
            HPWindow.this.input.getDocument().removeUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.openAFile();
            HPWindow.this.input.getDocument().addUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.updateDoState();
        }
    }

    class NewFileAction
    implements ActionListener {
        NewFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            LTSAPlugin lTSAPlugin = HPWindow.this.o_plugin_manager.getPlugin(string);
            if (lTSAPlugin != null && lTSAPlugin.providesNewFile()) {
                lTSAPlugin.newFile();
                return;
            }
            HPWindow.this.undo.discardAllEdits();
            HPWindow.this.input.getDocument().removeUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.newFile();
            HPWindow.this.input.getDocument().addUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.updateDoState();
        }
    }

    class CloseWindow
    extends WindowAdapter {
        CloseWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            HPWindow.this.quitAll();
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (HPWindow.this.animator != null) {
                HPWindow.this.animator.toFront();
            }
        }
    }
}

