/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.ltsa.dclap.Gr2PICT;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.DrawMachine;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSCanvas;
import ic.doc.ltsa.lts.LTSEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LTSDrawWindow
extends JSplitPane
implements EventClient {
    LTSCanvas output;
    EventManager eman;
    CompositeState cs;
    int[] lastEvent;
    int[] prevEvent;
    String lastName;
    int Nmach = 0;
    int hasC = 0;
    CompactState[] sm;
    boolean[] machineHasAction;
    boolean[] machineToDrawSet;
    public static boolean fontFlag = false;
    public static boolean singleMode = false;
    JList list;
    JScrollPane left;
    JScrollPane right;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 16);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 16);
    ImageIcon drawIcon = new ImageIcon(this.getClass().getResource("icon/draw.gif"));

    public LTSDrawWindow(CompositeState compositeState, EventManager eventManager) {
        this.eman = eventManager;
        this.output = new LTSCanvas(singleMode);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.output);
        this.right = new JScrollPane(jPanel, 20, 30);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.list.setCellRenderer(new MyCellRenderer());
        this.left = new JScrollPane(this.list, 20, 30);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("Center", this.right);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jPanel2.add("West", jToolBar);
        jToolBar.add(this.createTool("icon/stretchHorizontal.gif", "Stretch Horizontal", new HStretchAction(10)));
        jToolBar.add(this.createTool("icon/compressHorizontal.gif", "Compress Horizontal", new HStretchAction(-10)));
        jToolBar.add(this.createTool("icon/stretchVertical.gif", "Stretch Vertical", new VStretchAction(10)));
        jToolBar.add(this.createTool("icon/compressVertical.gif", "Compress Vertical", new VStretchAction(-10)));
        if (eventManager != null) {
            eventManager.addClient(this);
        }
        this.new_machines(compositeState);
        this.setLeftComponent(this.left);
        this.setRightComponent(jPanel2);
        this.setDividerLocation(200);
        this.setBigFont(fontFlag);
        this.validate();
        this.output.addKeyListener(new KeyPress());
        this.output.addMouseListener(new MyMouse());
    }

    private int validMachine(int n, int[] nArray) {
        if (nArray != null && n < this.Nmach - this.hasC) {
            return nArray[n];
        }
        return 0;
    }

    public void ltsAction(LTSEvent lTSEvent) {
        switch (lTSEvent.kind) {
            case 0: {
                this.prevEvent = this.lastEvent;
                this.lastEvent = (int[])lTSEvent.info;
                this.lastName = lTSEvent.name;
                this.output.select(this.Nmach - this.hasC, this.prevEvent, this.lastEvent, lTSEvent.name);
                this.buttonHighlight(lTSEvent.name);
                break;
            }
            case 1: {
                this.prevEvent = null;
                this.lastEvent = null;
                this.cs = (CompositeState)lTSEvent.info;
                this.new_machines(this.cs);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void buttonHighlight(String string) {
        if (string == null && this.machineHasAction != null) {
            int n = 0;
            while (n < this.machineHasAction.length) {
                this.machineHasAction[n] = false;
                ++n;
            }
        } else if (this.machineHasAction != null) {
            int n = 0;
            while (n < this.sm.length - this.hasC) {
                this.machineHasAction[n] = !string.equals("tau") && this.sm[n].hasLabel(string);
                ++n;
            }
        }
        this.list.repaint();
    }

    private void new_machines(CompositeState compositeState) {
        int n;
        Object object;
        int n2 = this.hasC = compositeState != null && compositeState.composition != null ? 1 : 0;
        if (compositeState != null && compositeState.machines != null && compositeState.machines.size() > 0) {
            this.sm = new CompactState[compositeState.machines.size() + this.hasC];
            object = compositeState.machines.elements();
            n = 0;
            while (object.hasMoreElements()) {
                this.sm[n] = (CompactState)object.nextElement();
                ++n;
            }
            this.Nmach = this.sm.length;
            if (this.hasC == 1) {
                this.sm[this.Nmach - 1] = compositeState.composition;
            }
            this.machineHasAction = new boolean[this.Nmach];
            this.machineToDrawSet = new boolean[this.Nmach];
        } else {
            this.Nmach = 0;
            this.machineHasAction = null;
            this.machineToDrawSet = null;
        }
        object = new DefaultListModel();
        n = 0;
        while (n < this.Nmach) {
            if (this.hasC == 1 && n == this.Nmach - 1) {
                ((DefaultListModel)object).addElement("||" + this.sm[n].name);
            } else {
                ((DefaultListModel)object).addElement(this.sm[n].name);
            }
            ++n;
        }
        this.list.setModel(object);
        this.output.setMachines(this.Nmach);
    }

    protected JButton createTool(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton((Icon)new ImageIcon(this.getClass().getResource(string))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void setBigFont(boolean bl) {
        fontFlag = bl;
        this.output.setBigFont(bl);
    }

    public void setDrawName(boolean bl) {
        this.output.setDrawName(bl);
    }

    public void setNewLabelFormat(boolean bl) {
        this.output.setNewLabelFormat(bl);
    }

    public void setMode(boolean bl) {
        singleMode = bl;
        this.output.setMode(bl);
        this.list.clearSelection();
        if (this.Nmach > 0) {
            this.machineToDrawSet = new boolean[this.Nmach];
        }
        this.list.repaint();
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void saveFile() {
        String string;
        int n;
        DrawMachine drawMachine = this.output.getDrawing();
        if (drawMachine == null) {
            JOptionPane.showMessageDialog(this, "No LTS picture selected to save");
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this.getTopLevelAncestor(), "Save file in:", 1);
        if (this.Nmach > 0 && (n = (string = drawMachine.getMachine().name).indexOf(58, 0)) > 0) {
            string = string.substring(0, n);
        }
        fileDialog.show();
        string = fileDialog.getFile();
        if (string != null) {
            try {
                n = string.indexOf(46, 0);
                string = string.substring(0, n) + "." + "pct";
                FileOutputStream fileOutputStream = new FileOutputStream(fileDialog.getDirectory() + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
                Rectangle rectangle = new Rectangle(0, 0, drawMachine.getSize().width, drawMachine.getSize().height);
                Gr2PICT gr2PICT = new Gr2PICT((OutputStream)byteArrayOutputStream, this.output.getGraphics(), rectangle);
                drawMachine.fileDraw(gr2PICT);
                gr2PICT.finalize();
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error saving file: " + iOException);
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setFont(fontFlag ? LTSDrawWindow.this.f4 : LTSDrawWindow.this.f3);
            this.setText(object.toString());
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            if (LTSDrawWindow.this.machineHasAction != null && LTSDrawWindow.this.machineHasAction[n]) {
                this.setBackground(Color.red);
                this.setForeground(Color.white);
            }
            this.setForeground(bl ? Color.white : Color.black);
            this.setIcon(LTSDrawWindow.this.machineToDrawSet[n] && !singleMode ? LTSDrawWindow.this.drawIcon : null);
            return this;
        }
    }

    class MyMouse
    extends MouseAdapter {
        MyMouse() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            LTSDrawWindow.this.output.requestFocus();
        }
    }

    class KeyPress
    extends KeyAdapter {
        KeyPress() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (LTSDrawWindow.this.output == null) {
                return;
            }
            int n2 = keyEvent.getKeyCode();
            if (n2 == 37) {
                LTSDrawWindow.this.output.stretchHorizontal(-5);
            } else if (n2 == 39) {
                LTSDrawWindow.this.output.stretchHorizontal(5);
            } else if (n2 == 38) {
                LTSDrawWindow.this.output.stretchVertical(-5);
            } else if (n2 == 40) {
                LTSDrawWindow.this.output.stretchVertical(5);
            } else if (n2 == 8 && (n = LTSDrawWindow.this.output.clearSelected()) >= 0) {
                LTSDrawWindow.this.machineToDrawSet[n] = false;
                LTSDrawWindow.this.list.repaint();
            }
        }
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && !singleMode) {
                return;
            }
            int n = LTSDrawWindow.this.list.getSelectedIndex();
            if (n < 0 || n >= LTSDrawWindow.this.Nmach) {
                return;
            }
            if (singleMode) {
                LTSDrawWindow.this.output.draw(n, LTSDrawWindow.this.sm[n], LTSDrawWindow.this.validMachine(n, LTSDrawWindow.this.prevEvent), LTSDrawWindow.this.validMachine(n, LTSDrawWindow.this.lastEvent), LTSDrawWindow.this.lastName);
            } else {
                if (!LTSDrawWindow.this.machineToDrawSet[n]) {
                    LTSDrawWindow.this.output.draw(n, LTSDrawWindow.this.sm[n], LTSDrawWindow.this.validMachine(n, LTSDrawWindow.this.prevEvent), LTSDrawWindow.this.validMachine(n, LTSDrawWindow.this.lastEvent), LTSDrawWindow.this.lastName);
                    LTSDrawWindow.this.machineToDrawSet[n] = true;
                } else {
                    LTSDrawWindow.this.output.clear(n);
                    LTSDrawWindow.this.machineToDrawSet[n] = false;
                }
                LTSDrawWindow.this.list.clearSelection();
            }
        }
    }

    class VStretchAction
    implements ActionListener {
        int increment;

        VStretchAction(int n) {
            this.increment = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LTSDrawWindow.this.output != null) {
                LTSDrawWindow.this.output.stretchVertical(this.increment);
            }
        }
    }

    class HStretchAction
    implements ActionListener {
        int increment;

        HStretchAction(int n) {
            this.increment = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LTSDrawWindow.this.output != null) {
                LTSDrawWindow.this.output.stretchHorizontal(this.increment);
            }
        }
    }
}

