/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Range;
import ic.doc.ltsa.lts.Symbol;
import java.util.Stack;

class ActionRange
extends ActionLabels {
    Stack rlow;
    Stack rhigh;
    protected int current;
    protected int high;
    protected int low;

    public ActionRange(Stack stack, Stack stack2) {
        this.rlow = stack;
        this.rhigh = stack2;
    }

    public ActionRange(Range range) {
        this.rlow = range.low;
        this.rhigh = range.high;
    }

    protected String computeName() {
        return String.valueOf(this.current);
    }

    protected void initialise() {
        this.low = Expression.evaluate(this.rlow, this.locals, this.globals);
        this.high = Expression.evaluate(this.rhigh, this.locals, this.globals);
        if (this.low > this.high) {
            Diagnostics.fatal("Range not defined", (Symbol)this.rlow.peek());
        }
        this.current = this.low;
    }

    protected void next() {
        ++this.current;
    }

    public boolean hasMoreNames() {
        return this.current <= this.high;
    }

    protected ActionLabels make() {
        return new ActionRange(this.rlow, this.rhigh);
    }
}

