/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.Symbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class AutCompactState
extends CompactState {
    public AutCompactState(Symbol symbol, File file) {
        this.name = symbol.toString();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            Diagnostics.fatal("Error opening file" + exception, symbol);
        }
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                Diagnostics.fatal("file is empty", symbol);
            }
            this.maxStates = this.statesAUTheader(string);
            this.states = new EventState[this.maxStates];
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Counter counter = new Counter(0);
            hashtable.put("tau", counter.label());
            String string2 = null;
            int n = this.transitionsAUTheader(string);
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.parseAUTtransition(string2, hashtable, counter);
                ++n2;
            }
            if (n2 != n) {
                Diagnostics.fatal("transitions read different from .aut header", symbol);
            }
            this.alphabet = new String[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                int n3 = (Integer)hashtable.get(string3);
                this.alphabet[n3] = string3;
            }
        }
        catch (Exception exception) {
            Diagnostics.fatal("Error reading/translating file" + exception, symbol);
        }
    }

    protected int statesAUTheader(String string) {
        int n = string.lastIndexOf(44);
        String string2 = string.substring(n + 1, string.indexOf(41)).trim();
        return Integer.parseInt(string2);
    }

    protected int transitionsAUTheader(String string) {
        int n = string.indexOf(44);
        int n2 = string.lastIndexOf(44);
        String string2 = string.substring(n + 1, n2).trim();
        return Integer.parseInt(string2);
    }

    protected void parseAUTtransition(String string, Hashtable hashtable, Counter counter) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(44);
        String string2 = string.substring(n + 1, n2).trim();
        int n3 = Integer.parseInt(string2);
        int n4 = string.indexOf(44, n2 + 1);
        String string3 = string.substring(n2 + 1, n4).trim();
        if (string3.charAt(0) == '\"') {
            string3 = string3.substring(1, string3.length() - 1).trim();
        }
        int n5 = string.indexOf(41);
        string2 = string.substring(n4 + 1, n5).trim();
        int n6 = Integer.parseInt(string2);
        Integer n7 = (Integer)hashtable.get(string3);
        if (n7 == null) {
            n7 = counter.label();
            hashtable.put(string3, n7);
        }
        this.states[n3] = EventState.add(this.states[n3], new EventState(n7, n6));
    }
}

