/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionExpr;
import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.ActionName;
import ic.doc.ltsa.lts.ActionRange;
import ic.doc.ltsa.lts.ActionSet;
import ic.doc.ltsa.lts.ActionSetExpr;
import ic.doc.ltsa.lts.ActionVarRange;
import ic.doc.ltsa.lts.ActionVarSet;
import ic.doc.ltsa.lts.AutCompactState;
import ic.doc.ltsa.lts.ChoiceElement;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeBody;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.CompositionExpression;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.Lex;
import ic.doc.ltsa.lts.MenuDefinition;
import ic.doc.ltsa.lts.ProcessRef;
import ic.doc.ltsa.lts.ProcessSpec;
import ic.doc.ltsa.lts.ProgressDefinition;
import ic.doc.ltsa.lts.Range;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.SeqProcessRef;
import ic.doc.ltsa.lts.StateDefn;
import ic.doc.ltsa.lts.StateExpr;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.LTLparser;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class LTSCompiler {
    private Lex lex;
    private LTSOutput output;
    private String currentDirectory;
    private Symbol current;
    static Hashtable processes;
    static Hashtable compiled;
    static Hashtable composites;

    public LTSCompiler(LTSInput lTSInput, LTSOutput lTSOutput, String string) {
        this.lex = new Lex(lTSInput);
        this.output = lTSOutput;
        this.currentDirectory = string;
        Diagnostics.init(lTSOutput);
        SeqProcessRef.output = lTSOutput;
        StateMachine.output = lTSOutput;
        Expression.constants = new Hashtable();
        Range.ranges = new Hashtable();
        LabelSet.constants = new Hashtable();
        ProgressDefinition.definitions = new Hashtable();
        MenuDefinition.definitions = new Hashtable();
        PredicateDefinition.init();
        AssertDefinition.init();
    }

    private Symbol next_symbol() {
        this.current = this.lex.next_symbol();
        return this.current;
    }

    private void push_symbol() {
        this.lex.push_symbol();
    }

    private void error(String string) {
        Diagnostics.fatal(string, this.current);
    }

    private void current_is(int n, String string) {
        if (this.current.kind != n) {
            this.error(string);
        }
    }

    public CompositeState compile(String string) {
        processes = new Hashtable();
        composites = new Hashtable();
        compiled = new Hashtable();
        this.doparse(composites, processes, compiled);
        ProgressDefinition.compile();
        MenuDefinition.compile();
        CompositionExpression compositionExpression = (CompositionExpression)composites.get(string);
        if (compositionExpression == null && composites.size() > 0) {
            Enumeration enumeration = composites.elements();
            compositionExpression = (CompositionExpression)enumeration.nextElement();
        }
        if (compositionExpression != null) {
            return compositionExpression.compose(null);
        }
        this.compileProcesses(processes, compiled);
        return this.noCompositionExpression(compiled);
    }

    private void compileProcesses(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            ProcessSpec processSpec = (ProcessSpec)enumeration.nextElement();
            if (!processSpec.imported()) {
                object = new StateMachine(processSpec);
                CompactState compactState = ((StateMachine)object).makeCompactState();
                this.output.outln("Compiled: " + compactState.name);
                hashtable2.put(compactState.name, compactState);
                continue;
            }
            object = new AutCompactState(processSpec.name, processSpec.importFile);
            this.output.outln("Imported: " + ((CompactState)object).name);
            hashtable2.put(((CompactState)object).name, object);
        }
    }

    public void parse(Hashtable hashtable, Hashtable hashtable2) {
        this.doparse(hashtable, hashtable2, null);
    }

    private void doparse(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        this.next_symbol();
        while (this.current.kind != 99) {
            ProcessSpec processSpec;
            if (this.current.kind == 1) {
                this.next_symbol();
                this.constantDefinition(Expression.constants);
            } else if (this.current.kind == 3) {
                this.next_symbol();
                this.rangeDefinition();
            } else if (this.current.kind == 9) {
                this.next_symbol();
                this.setDefinition();
            } else if (this.current.kind == 10) {
                this.next_symbol();
                this.progressDefinition();
            } else if (this.current.kind == 11) {
                this.next_symbol();
                this.menuDefinition();
            } else if (this.current.kind == 12) {
                this.next_symbol();
                this.animationDefinition();
            } else if (this.current.kind == 21) {
                this.next_symbol();
                this.assertDefinition();
            } else if (this.current.kind == 22) {
                this.next_symbol();
                this.predicateDefinition();
            } else if (this.current.kind == 19) {
                this.next_symbol();
                processSpec = this.importDefinition();
                if (hashtable2.put(processSpec.name.toString(), processSpec) != null) {
                    Diagnostics.fatal("duplicate process definition: " + processSpec.name, processSpec.name);
                }
            } else if (this.current.kind == 40 || this.current.kind == 15 || this.current.kind == 16 || this.current.kind == 2 || this.current.kind == 17) {
                Object object;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (this.current.kind == 15) {
                    bl = true;
                    this.next_symbol();
                }
                if (this.current.kind == 16) {
                    bl2 = true;
                    this.next_symbol();
                }
                if (this.current.kind == 17) {
                    bl4 = true;
                    this.next_symbol();
                }
                if (this.current.kind == 2) {
                    bl3 = true;
                    this.next_symbol();
                }
                if (this.current.kind != 40) {
                    object = this.stateDefns();
                    if (hashtable2.put(((ProcessSpec)object).name.toString(), object) != null) {
                        Diagnostics.fatal("duplicate process definition: " + ((ProcessSpec)object).name, ((ProcessSpec)object).name);
                    }
                    ((ProcessSpec)object).isProperty = bl3;
                    ((ProcessSpec)object).isMinimal = bl2;
                    ((ProcessSpec)object).isDeterministic = bl;
                } else if (this.current.kind == 40) {
                    object = this.composition();
                    ((CompositionExpression)object).composites = hashtable;
                    ((CompositionExpression)object).processes = hashtable2;
                    ((CompositionExpression)object).compiledProcesses = hashtable3;
                    ((CompositionExpression)object).output = this.output;
                    ((CompositionExpression)object).makeDeterministic = bl;
                    ((CompositionExpression)object).makeProperty = bl3;
                    ((CompositionExpression)object).makeMinimal = bl2;
                    ((CompositionExpression)object).makeCompose = bl4;
                    if (hashtable.put(((CompositionExpression)object).name.toString(), object) != null) {
                        Diagnostics.fatal("duplicate composite definition: " + ((CompositionExpression)object).name, ((CompositionExpression)object).name);
                    }
                }
            } else {
                processSpec = this.stateDefns();
                if (hashtable2.put(processSpec.name.toString(), processSpec) != null) {
                    Diagnostics.fatal("duplicate process definition: " + processSpec.name, processSpec.name);
                }
            }
            this.next_symbol();
        }
    }

    private CompositeState noCompositionExpression(Hashtable hashtable) {
        Vector vector = new Vector(16);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return new CompositeState(vector);
    }

    private CompositionExpression composition() {
        this.current_is(40, "|| expected");
        this.next_symbol();
        CompositionExpression compositionExpression = new CompositionExpression();
        this.current_is(123, "process identifier expected");
        compositionExpression.name = this.current;
        this.next_symbol();
        this.paramDefns(compositionExpression.init_constants, compositionExpression.parameters);
        this.current_is(64, "= expected");
        this.next_symbol();
        compositionExpression.body = this.compositebody();
        compositionExpression.priorityActions = this.priorityDefn(compositionExpression);
        if (this.current.kind == 70 || this.current.kind == 68) {
            compositionExpression.exposeNotHide = this.current.kind == 68;
            this.next_symbol();
            compositionExpression.alphaHidden = this.labelSet();
        }
        this.current_is(66, "dot expected");
        return compositionExpression;
    }

    private CompositeBody compositebody() {
        CompositeBody compositeBody = new CompositeBody();
        if (this.current.kind == 4) {
            this.next_symbol();
            compositeBody.boolexpr = new Stack();
            this.expression(compositeBody.boolexpr);
            this.current_is(5, "keyword then expected");
            this.next_symbol();
            compositeBody.thenpart = this.compositebody();
            if (this.current.kind == 6) {
                this.next_symbol();
                compositeBody.elsepart = this.compositebody();
            }
        } else if (this.current.kind == 7) {
            this.next_symbol();
            compositeBody.range = this.forallRanges();
            compositeBody.thenpart = this.compositebody();
        } else {
            if (this.isLabel()) {
                ActionLabels actionLabels = this.labelElement();
                if (this.current.kind == 71) {
                    compositeBody.accessSet = actionLabels;
                    this.next_symbol();
                    if (this.isLabel()) {
                        compositeBody.prefix = this.labelElement();
                        this.current_is(38, " : expected");
                        this.next_symbol();
                    }
                } else if (this.current.kind == 38) {
                    compositeBody.prefix = actionLabels;
                    this.next_symbol();
                } else {
                    this.error(" : or :: expected");
                }
            }
            if (this.current.kind == 53) {
                compositeBody.procRefs = this.processRefs();
                compositeBody.relabelDefns = this.relabelDefns();
            } else {
                compositeBody.singleton = this.processRef();
                compositeBody.relabelDefns = this.relabelDefns();
            }
        }
        return compositeBody;
    }

    private ActionLabels forallRanges() {
        ActionLabels actionLabels;
        this.current_is(62, "range expected");
        ActionLabels actionLabels2 = actionLabels = this.range();
        while (this.current.kind == 62) {
            ActionLabels actionLabels3 = this.range();
            actionLabels2.addFollower(actionLabels3);
            actionLabels2 = actionLabels3;
        }
        return actionLabels;
    }

    private Vector processRefs() {
        Vector<CompositeBody> vector = new Vector<CompositeBody>();
        this.current_is(53, "( expected");
        this.next_symbol();
        if (this.current.kind != 54) {
            vector.addElement(this.compositebody());
            while (this.current.kind == 40) {
                this.next_symbol();
                vector.addElement(this.compositebody());
            }
            this.current_is(54, ") expected");
        }
        this.next_symbol();
        return vector;
    }

    private Vector relabelDefns() {
        if (this.current.kind != 33) {
            return null;
        }
        this.next_symbol();
        return this.relabelSet();
    }

    private LabelSet priorityDefn(CompositionExpression compositionExpression) {
        if (this.current.kind != 51 && this.current.kind != 48) {
            return null;
        }
        if (this.current.kind == 48) {
            compositionExpression.priorityIsLow = false;
        }
        this.next_symbol();
        return this.labelSet();
    }

    private Vector relabelSet() {
        this.current_is(60, "{ expected");
        this.next_symbol();
        Vector<RelabelDefn> vector = new Vector<RelabelDefn>();
        vector.addElement(this.relabelDefn());
        while (this.current.kind == 39) {
            this.next_symbol();
            vector.addElement(this.relabelDefn());
        }
        this.current_is(61, "} expected");
        this.next_symbol();
        return vector;
    }

    private RelabelDefn relabelDefn() {
        RelabelDefn relabelDefn = new RelabelDefn();
        if (this.current.kind == 7) {
            this.next_symbol();
            relabelDefn.range = this.forallRanges();
            relabelDefn.defns = this.relabelSet();
        } else {
            relabelDefn.newlabel = this.labelElement();
            this.current_is(33, "/ expected");
            this.next_symbol();
            relabelDefn.oldlabel = this.labelElement();
        }
        return relabelDefn;
    }

    private ProcessRef processRef() {
        ProcessRef processRef = new ProcessRef();
        this.current_is(123, "process identifier expected");
        processRef.name = this.current;
        this.next_symbol();
        processRef.actualParams = this.actualParameters();
        return processRef;
    }

    private Vector actualParameters() {
        if (this.current.kind != 53) {
            return null;
        }
        Vector vector = new Vector();
        this.next_symbol();
        Stack stack = new Stack();
        this.expression(stack);
        vector.addElement(stack);
        while (this.current.kind == 39) {
            this.next_symbol();
            stack = new Stack();
            this.expression(stack);
            vector.addElement(stack);
        }
        this.current_is(54, ") - expected");
        this.next_symbol();
        return vector;
    }

    private ProcessSpec stateDefns() {
        ProcessSpec processSpec = new ProcessSpec();
        this.current_is(123, "process identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.paramDefns(processSpec.init_constants, processSpec.parameters);
        this.push_symbol();
        this.current = symbol;
        processSpec.stateDefns.addElement(this.stateDefn());
        while (this.current.kind == 39) {
            this.next_symbol();
            processSpec.stateDefns.addElement(this.stateDefn());
        }
        if (this.current.kind == 30) {
            this.next_symbol();
            processSpec.alphaAdditions = this.labelSet();
        }
        processSpec.alphaRelabel = this.relabelDefns();
        if (this.current.kind == 70 || this.current.kind == 68) {
            processSpec.exposeNotHide = this.current.kind == 68;
            this.next_symbol();
            processSpec.alphaHidden = this.labelSet();
        }
        processSpec.getname();
        this.current_is(66, "dot expected");
        return processSpec;
    }

    private boolean isLabelSet() {
        if (this.current.kind == 60) {
            return true;
        }
        if (this.current.kind != 123) {
            return false;
        }
        return LabelSet.constants.containsKey(this.current.toString());
    }

    private boolean isLabel() {
        return this.isLabelSet() || this.current.kind == 124 || this.current.kind == 62;
    }

    private ProcessSpec importDefinition() {
        this.current_is(123, "imported process identifier expected");
        ProcessSpec processSpec = new ProcessSpec();
        processSpec.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(27, " - imported file name expected");
        processSpec.importFile = new File(this.currentDirectory, this.current.toString());
        return processSpec;
    }

    private void animationDefinition() {
        this.current_is(123, "animation identifier expected");
        MenuDefinition menuDefinition = new MenuDefinition();
        menuDefinition.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(27, " - XML file name expected");
        menuDefinition.params = this.current;
        this.next_symbol();
        if (this.current.kind == 18) {
            this.next_symbol();
            this.current_is(123, " - target composition name expected");
            menuDefinition.target = this.current;
            this.next_symbol();
        }
        if (this.current.kind == 17) {
            this.next_symbol();
            this.current_is(60, "{ expected");
            this.next_symbol();
            this.current_is(123, "animation name expected");
            Symbol symbol = this.current;
            this.next_symbol();
            menuDefinition.addAnimationPart(symbol, this.relabelDefns());
            while (this.current.kind == 40) {
                this.next_symbol();
                this.current_is(123, "animation name expected");
                symbol = this.current;
                this.next_symbol();
                menuDefinition.addAnimationPart(symbol, this.relabelDefns());
            }
            this.current_is(61, "} expected");
            this.next_symbol();
        }
        if (this.current.kind == 13) {
            this.next_symbol();
            menuDefinition.actionMapDefn = this.relabelSet();
        }
        if (this.current.kind == 14) {
            this.next_symbol();
            menuDefinition.controlMapDefn = this.relabelSet();
        }
        this.push_symbol();
        if (MenuDefinition.definitions.put(menuDefinition.name.toString(), menuDefinition) != null) {
            Diagnostics.fatal("duplicate menu/animation definition: " + menuDefinition.name, menuDefinition.name);
        }
    }

    private void menuDefinition() {
        this.current_is(123, "menu identifier expected");
        MenuDefinition menuDefinition = new MenuDefinition();
        menuDefinition.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        menuDefinition.actions = this.labelElement();
        this.push_symbol();
        if (MenuDefinition.definitions.put(menuDefinition.name.toString(), menuDefinition) != null) {
            Diagnostics.fatal("duplicate menu/animation definition: " + menuDefinition.name, menuDefinition.name);
        }
    }

    private void progressDefinition() {
        this.current_is(123, "progress test identifier expected");
        ProgressDefinition progressDefinition = new ProgressDefinition();
        progressDefinition.name = this.current;
        this.next_symbol();
        if (this.current.kind == 62) {
            progressDefinition.range = this.forallRanges();
        }
        this.current_is(64, "= expected");
        this.next_symbol();
        if (this.current.kind == 4) {
            this.next_symbol();
            progressDefinition.pactions = this.labelElement();
            this.current_is(5, "then expected");
            this.next_symbol();
            progressDefinition.cactions = this.labelElement();
        } else {
            progressDefinition.pactions = this.labelElement();
        }
        if (ProgressDefinition.definitions.put(progressDefinition.name.toString(), progressDefinition) != null) {
            Diagnostics.fatal("duplicate progress test: " + progressDefinition.name, progressDefinition.name);
        }
        this.push_symbol();
    }

    private void setDefinition() {
        this.current_is(123, "set identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        LabelSet labelSet = new LabelSet(symbol, this.setValue());
        this.push_symbol();
    }

    private LabelSet labelSet() {
        if (this.current.kind == 60) {
            return new LabelSet(this.setValue());
        }
        if (this.current.kind == 123) {
            LabelSet labelSet = (LabelSet)LabelSet.constants.get(this.current.toString());
            if (labelSet == null) {
                this.error("set definition not found for: " + this.current);
            }
            this.next_symbol();
            return labelSet;
        }
        this.error("{ or set identifier expected");
        return null;
    }

    private Vector setValue() {
        this.current_is(60, "{ expected");
        this.next_symbol();
        Vector<ActionLabels> vector = new Vector<ActionLabels>();
        vector.addElement(this.labelElement());
        while (this.current.kind == 39) {
            this.next_symbol();
            vector.addElement(this.labelElement());
        }
        this.current_is(61, "} expected");
        this.next_symbol();
        return vector;
    }

    private ActionLabels labelElement() {
        if (this.current.kind != 124 && !this.isLabelSet() && this.current.kind != 62) {
            this.error("identifier, label set or range expected");
        }
        ActionLabels actionLabels = null;
        if (this.current.kind == 124) {
            if ("tau".equals(this.current.toString())) {
                this.error("'tau' cannot be used as an action label");
            }
            actionLabels = new ActionName(this.current);
            this.next_symbol();
        } else if (this.isLabelSet()) {
            LabelSet labelSet = this.labelSet();
            if (this.current.kind == 70) {
                this.next_symbol();
                LabelSet labelSet2 = this.labelSet();
                actionLabels = new ActionSetExpr(labelSet, labelSet2);
            } else {
                actionLabels = new ActionSet(labelSet);
            }
        } else if (this.current.kind == 62) {
            actionLabels = this.range();
        }
        if (this.current.kind == 66 || this.current.kind == 62) {
            if (this.current.kind == 66) {
                this.next_symbol();
            }
            if (actionLabels != null) {
                actionLabels.addFollower(this.labelElement());
            }
        }
        return actionLabels;
    }

    private void constantDefinition(Hashtable hashtable) {
        this.current_is(123, "constant, upper case identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Stack stack = new Stack();
        this.simpleExpression(stack);
        this.push_symbol();
        if (hashtable.put(symbol.toString(), Expression.getValue(stack, null, null)) != null) {
            Diagnostics.fatal("duplicate constant definition: " + symbol, symbol);
        }
    }

    private void paramDefns(Hashtable hashtable, Vector vector) {
        if (this.current.kind == 53) {
            this.next_symbol();
            this.parameterDefinition(hashtable, vector);
            while (this.current.kind == 39) {
                this.next_symbol();
                this.parameterDefinition(hashtable, vector);
            }
            this.current_is(54, ") expected");
            this.next_symbol();
        }
    }

    private void parameterDefinition(Hashtable hashtable, Vector vector) {
        this.current_is(123, "parameter, upper case identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Stack stack = new Stack();
        this.expression(stack);
        this.push_symbol();
        if (hashtable.put(symbol.toString(), Expression.getValue(stack, null, null)) != null) {
            Diagnostics.fatal("duplicate parameter definition: " + symbol, symbol);
        }
        if (vector != null) {
            vector.addElement(symbol.toString());
            this.next_symbol();
        }
    }

    private StateDefn stateDefn() {
        StateDefn stateDefn = new StateDefn();
        this.current_is(123, "process identifier expected");
        stateDefn.name = this.current;
        this.next_symbol();
        if (this.current.kind == 68) {
            stateDefn.accept = true;
            this.next_symbol();
        }
        if (this.current.kind == 66 || this.current.kind == 62) {
            if (this.current.kind == 66) {
                this.next_symbol();
            }
            stateDefn.range = this.labelElement();
        }
        this.current_is(64, "= expected");
        this.next_symbol();
        stateDefn.stateExpr = this.stateExpr();
        return stateDefn;
    }

    private Stack getEvaluatedExpression() {
        Stack<Symbol> stack = new Stack<Symbol>();
        this.simpleExpression(stack);
        int n = Expression.evaluate(stack, null, null);
        stack = new Stack();
        stack.push(new Symbol(25, n));
        return stack;
    }

    private void rangeDefinition() {
        this.current_is(123, "range name, upper case identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Range range = new Range();
        range.low = this.getEvaluatedExpression();
        this.current_is(67, "..  expected");
        this.next_symbol();
        range.high = this.getEvaluatedExpression();
        if (Range.ranges.put(symbol.toString(), range) != null) {
            Diagnostics.fatal("duplicate range definition: " + symbol, symbol);
        }
        this.push_symbol();
    }

    private ActionLabels range() {
        if (this.current.kind == 62) {
            ActionLabels actionLabels;
            this.next_symbol();
            Stack stack = null;
            Stack stack2 = null;
            if (this.current.kind != 124) {
                if (this.isLabelSet()) {
                    actionLabels = new ActionSet(this.labelSet());
                } else if (this.current.kind == 123 && Range.ranges.containsKey(this.current.toString())) {
                    actionLabels = new ActionRange((Range)Range.ranges.get(this.current.toString()));
                    this.next_symbol();
                } else {
                    stack = new Stack();
                    this.expression(stack);
                    actionLabels = new ActionExpr(stack);
                }
                if (this.current.kind == 67) {
                    this.next_symbol();
                    stack2 = new Stack();
                    this.expression(stack2);
                    actionLabels = new ActionRange(stack, stack2);
                }
            } else {
                Symbol symbol = this.current;
                this.next_symbol();
                if (this.current.kind == 38) {
                    this.next_symbol();
                    if (this.isLabelSet()) {
                        actionLabels = new ActionVarSet(symbol, this.labelSet());
                    } else if (this.current.kind == 123 && Range.ranges.containsKey(this.current.toString())) {
                        actionLabels = new ActionVarRange(symbol, (Range)Range.ranges.get(this.current.toString()));
                        this.next_symbol();
                    } else {
                        stack = new Stack();
                        this.expression(stack);
                        this.current_is(67, "..  expected");
                        this.next_symbol();
                        stack2 = new Stack();
                        this.expression(stack2);
                        actionLabels = new ActionVarRange(symbol, stack, stack2);
                    }
                } else {
                    this.push_symbol();
                    this.current = symbol;
                    stack = new Stack();
                    this.expression(stack);
                    if (this.current.kind == 67) {
                        this.next_symbol();
                        stack2 = new Stack();
                        this.expression(stack2);
                        actionLabels = new ActionRange(stack, stack2);
                    } else {
                        actionLabels = new ActionExpr(stack);
                    }
                }
            }
            this.current_is(63, "] expected");
            this.next_symbol();
            return actionLabels;
        }
        return null;
    }

    private StateExpr stateExpr() {
        StateExpr stateExpr = new StateExpr();
        if (this.current.kind == 123) {
            this.stateRef(stateExpr);
        } else if (this.current.kind == 4) {
            this.next_symbol();
            stateExpr.boolexpr = new Stack();
            this.expression(stateExpr.boolexpr);
            this.current_is(5, "keyword then expected");
            this.next_symbol();
            stateExpr.thenpart = this.stateExpr();
            if (this.current.kind == 6) {
                this.next_symbol();
                stateExpr.elsepart = this.stateExpr();
            } else {
                Symbol symbol = new Symbol(123, "STOP");
                StateExpr stateExpr2 = new StateExpr();
                stateExpr2.name = symbol;
                stateExpr.elsepart = stateExpr2;
            }
        } else if (this.current.kind == 53) {
            this.next_symbol();
            this.choiceExpr(stateExpr);
            this.current_is(54, ") expected");
            this.next_symbol();
        } else {
            this.error(" (, if or process identifier expected");
        }
        return stateExpr;
    }

    private void stateRef(StateExpr stateExpr) {
        this.current_is(123, "process identifier expected");
        stateExpr.name = this.current;
        this.next_symbol();
        while (this.current.kind == 65 || this.current.kind == 53) {
            stateExpr.addSeqProcessRef(new SeqProcessRef(stateExpr.name, this.actualParameters()));
            this.next_symbol();
            this.current_is(123, "process identifier expected");
            stateExpr.name = this.current;
            this.next_symbol();
        }
        if (this.current.kind == 62) {
            stateExpr.expr = new Vector();
            while (this.current.kind == 62) {
                this.next_symbol();
                Stack stack = new Stack();
                this.expression(stack);
                stateExpr.expr.addElement(stack);
                this.current_is(63, "] expected");
                this.next_symbol();
            }
        }
    }

    private void choiceExpr(StateExpr stateExpr) {
        stateExpr.choices = new Vector();
        stateExpr.choices.addElement(this.choiceElement());
        while (this.current.kind == 41) {
            this.next_symbol();
            stateExpr.choices.addElement(this.choiceElement());
        }
    }

    private ChoiceElement choiceElement() {
        ChoiceElement choiceElement = new ChoiceElement();
        if (this.current.kind == 8) {
            this.next_symbol();
            choiceElement.guard = new Stack();
            this.expression(choiceElement.guard);
        }
        choiceElement.action = this.labelElement();
        this.current_is(69, "-> expected");
        ChoiceElement choiceElement2 = choiceElement;
        ChoiceElement choiceElement3 = choiceElement;
        this.next_symbol();
        while (this.current.kind == 124 || this.current.kind == 62 || this.isLabelSet()) {
            StateExpr stateExpr = new StateExpr();
            choiceElement2 = new ChoiceElement();
            choiceElement2.action = this.labelElement();
            stateExpr.choices = new Vector();
            stateExpr.choices.addElement(choiceElement2);
            choiceElement3.stateExpr = stateExpr;
            choiceElement3 = choiceElement2;
            this.current_is(69, "-> expected");
            this.next_symbol();
        }
        choiceElement2.stateExpr = this.stateExpr();
        return choiceElement;
    }

    private Symbol event() {
        this.current_is(124, "event identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        return symbol;
    }

    private ActionLabels labelConstant() {
        this.next_symbol();
        ActionLabels actionLabels = this.labelElement();
        if (actionLabels != null) {
            return actionLabels;
        }
        this.error("label definition expected");
        return null;
    }

    private void set_select(Stack stack) {
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(53, "( expected to start set index selection");
        Symbol symbol2 = this.current;
        symbol2.setAny(this.labelConstant());
        symbol2.kind = 98;
        stack.push(symbol2);
        this.current_is(39, ", expected before set index expression");
        this.next_symbol();
        this.expression(stack);
        this.current_is(54, ") expected to end set index selection");
        this.next_symbol();
        stack.push(symbol);
    }

    private void unary(Stack stack) {
        Symbol symbol;
        switch (this.current.kind) {
            case 30: {
                symbol = this.current;
                symbol.kind = 29;
                this.next_symbol();
                break;
            }
            case 31: {
                symbol = this.current;
                symbol.kind = 28;
                this.next_symbol();
                break;
            }
            case 45: {
                symbol = this.current;
                this.next_symbol();
                break;
            }
            default: {
                symbol = null;
            }
        }
        switch (this.current.kind) {
            case 25: 
            case 123: 
            case 124: {
                stack.push(this.current);
                this.next_symbol();
                break;
            }
            case 53: {
                this.next_symbol();
                this.expression(stack);
                this.current_is(54, ") expected to end expression");
                this.next_symbol();
                break;
            }
            case 73: {
                symbol = new Symbol(this.current);
            }
            case 72: {
                Symbol symbol2 = this.current;
                symbol2.setAny(this.labelConstant());
                symbol2.kind = 98;
                stack.push(symbol2);
                break;
            }
            case 68: {
                this.set_select(stack);
                break;
            }
            default: {
                this.error("syntax error in expression");
            }
        }
        if (symbol != null) {
            stack.push(symbol);
        }
    }

    private void multiplicative(Stack stack) {
        this.unary(stack);
        while (this.current.kind == 32 || this.current.kind == 33 || this.current.kind == 34) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.unary(stack);
            stack.push(symbol);
        }
    }

    private void additive(Stack stack) {
        this.multiplicative(stack);
        while (this.current.kind == 30 || this.current.kind == 31) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.multiplicative(stack);
            stack.push(symbol);
        }
    }

    private void shift(Stack stack) {
        this.additive(stack);
        while (this.current.kind == 48 || this.current.kind == 51) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.additive(stack);
            stack.push(symbol);
        }
    }

    private void relational(Stack stack) {
        this.shift(stack);
        while (this.current.kind == 47 || this.current.kind == 46 || this.current.kind == 50 || this.current.kind == 49) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.shift(stack);
            stack.push(symbol);
        }
    }

    private void equality(Stack stack) {
        this.relational(stack);
        while (this.current.kind == 52 || this.current.kind == 44) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.relational(stack);
            stack.push(symbol);
        }
    }

    private void and(Stack stack) {
        this.equality(stack);
        while (this.current.kind == 43) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.equality(stack);
            stack.push(symbol);
        }
    }

    private void exclusive_or(Stack stack) {
        this.and(stack);
        while (this.current.kind == 35) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.and(stack);
            stack.push(symbol);
        }
    }

    private void inclusive_or(Stack stack) {
        this.exclusive_or(stack);
        while (this.current.kind == 41) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.exclusive_or(stack);
            stack.push(symbol);
        }
    }

    private void logical_and(Stack stack) {
        this.inclusive_or(stack);
        while (this.current.kind == 42) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.inclusive_or(stack);
            stack.push(symbol);
        }
    }

    private void logical_or(Stack stack) {
        this.logical_and(stack);
        while (this.current.kind == 40) {
            Symbol symbol = this.current;
            this.next_symbol();
            this.logical_and(stack);
            stack.push(symbol);
        }
    }

    private void expression(Stack stack) {
        this.logical_or(stack);
    }

    private void simpleExpression(Stack stack) {
        this.additive(stack);
    }

    private void assertDefinition() {
        this.current_is(123, "LTL property identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        FormulaFactory formulaFactory = new LTLparser(this.lex).parse();
        this.push_symbol();
        if (processes != null && processes.get(symbol.toString()) != null || composites != null && composites.get(symbol.toString()) != null) {
            Diagnostics.fatal("name already defined  " + symbol, symbol);
        }
        AssertDefinition.put(symbol, formulaFactory);
    }

    private void predicateDefinition() {
        this.current_is(123, "predicate identifier expected");
        Symbol symbol = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(47, "< expected");
        this.next_symbol();
        ActionLabels actionLabels = this.labelElement();
        this.current_is(39, ", expected");
        this.next_symbol();
        ActionLabels actionLabels2 = this.labelElement();
        this.current_is(50, "> expected");
        this.next_symbol();
        if (this.current.kind == 24) {
            this.next_symbol();
            Stack stack = new Stack();
            this.simpleExpression(stack);
            this.push_symbol();
            PredicateDefinition.put(symbol, actionLabels, actionLabels2, stack);
        } else {
            this.push_symbol();
            PredicateDefinition.put(symbol, actionLabels, actionLabels2, null);
        }
    }
}

