/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.SymbolTable;

public class Lex {
    private LTSInput input;
    private Symbol symbol;
    private char ch;
    private boolean eoln;
    private boolean newSymbols = true;
    private Symbol current = null;
    private Symbol buffer = null;

    public Lex(LTSInput lTSInput) {
        this(lTSInput, true);
    }

    public Lex(LTSInput lTSInput, boolean bl) {
        this.input = lTSInput;
        this.newSymbols = bl;
        if (!bl) {
            this.symbol = new Symbol();
        }
    }

    private void error(String string) {
        Diagnostics.fatal(string, new Integer(this.input.getMarker()));
    }

    private void next_ch() {
        this.ch = this.input.nextChar();
        this.eoln = this.ch == '\n' || this.ch == '\u0000';
    }

    private void back_ch() {
        this.ch = this.input.backChar();
        this.eoln = this.ch == '\n' || this.ch == '\u0000';
    }

    private void in_comment() {
        if (this.ch == '/') {
            do {
                this.next_ch();
            } while (!this.eoln);
        } else {
            while (true) {
                this.next_ch();
                if (this.ch != '*' && this.ch != '\u0000') continue;
                do {
                    this.next_ch();
                } while (this.ch == '*' && this.ch != '\u0000');
                if (this.ch == '/' || this.ch == '\u0000') break;
            }
            this.next_ch();
        }
        if (!this.newSymbols) {
            this.symbol.kind = 100;
            this.back_ch();
        }
    }

    private boolean isodigit(char c) {
        return c >= '0' && c <= '7';
    }

    private boolean isxdigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private boolean isbase(char c, int n) {
        switch (n) {
            case 10: {
                return Character.isDigit(c);
            }
            case 16: {
                return this.isxdigit(c);
            }
            case 8: {
                return this.isodigit(c);
            }
        }
        return true;
    }

    private void in_number() {
        long l = 0L;
        int n = 0;
        int n2 = 10;
        this.symbol.kind = 25;
        if (this.ch == '0') {
            this.next_ch();
            if (this.ch == 'x' || this.ch == 'X') {
                n2 = 16;
                this.next_ch();
            } else {
                n2 = 8;
            }
        } else {
            n2 = 10;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.isbase(this.ch, n2)) {
            stringBuffer.append(this.ch);
            switch (n2) {
                case 8: 
                case 10: {
                    n = this.ch - 48;
                    break;
                }
                case 16: {
                    n = Character.isUpperCase(this.ch) ? this.ch - 65 + 10 : (Character.isLowerCase(this.ch) ? this.ch - 97 + 10 : this.ch - 48);
                }
            }
            if (l * (long)n2 > (long)(Integer.MAX_VALUE - n)) {
                this.error("Integer Overflow");
                l = Integer.MAX_VALUE;
                break;
            }
            l = l * (long)n2 + (long)n;
            this.next_ch();
        }
        this.symbol.setValue((int)l);
        this.back_ch();
    }

    private void in_escseq() {
        while (this.ch == '\\') {
            this.next_ch();
            switch (this.ch) {
                case 'a': {
                    this.ch = (char)97;
                    break;
                }
                case 'b': {
                    this.ch = (char)8;
                    break;
                }
                case 'f': {
                    this.ch = (char)12;
                    break;
                }
                case 'n': {
                    this.ch = (char)10;
                    break;
                }
                case 'r': {
                    this.ch = (char)13;
                    break;
                }
                case 't': {
                    this.ch = (char)9;
                    break;
                }
                case 'v': {
                    break;
                }
                case '\\': {
                    this.ch = (char)92;
                    break;
                }
                case '\'': {
                    this.ch = (char)39;
                    break;
                }
                case '\"': {
                    this.ch = (char)34;
                    break;
                }
                case '?': {
                    this.ch = (char)63;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int n = this.ch - 48;
                    this.next_ch();
                    if (this.isodigit(this.ch)) {
                        n = n * 8 + this.ch - 48;
                        this.next_ch();
                        if (this.isodigit(this.ch)) {
                            n = n * 8 + this.ch - 48;
                        }
                    }
                    this.ch = (char)n;
                    break;
                }
                case 'X': 
                case 'x': {
                    int n = 0;
                    this.next_ch();
                    if (!this.isxdigit(this.ch)) {
                        this.error("hex digit expected after \\x");
                    } else {
                        int n2 = 0;
                        while (this.isxdigit(this.ch) && n2 < 2) {
                            ++n2;
                            n = Character.isDigit(this.ch) ? n * 16 + this.ch - 48 : (Character.isUpperCase(this.ch) ? n * 16 + this.ch - 65 : n * 16 + this.ch - 97);
                            this.next_ch();
                        }
                    }
                    this.ch = (char)n;
                }
            }
        }
    }

    private void in_string() {
        boolean bl;
        char c = this.ch;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            this.next_ch();
            bl = this.ch != c && !this.eoln;
            if (!bl) continue;
            stringBuffer.append(this.ch);
        } while (bl);
        this.symbol.setString(stringBuffer.toString());
        if (this.eoln) {
            this.error("No closing character for string constant");
        }
        this.symbol.kind = 27;
    }

    private void in_identifier() {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(this.ch);
            this.next_ch();
        } while (Character.isLetterOrDigit(this.ch) || this.ch == '_');
        String string = stringBuffer.toString();
        this.symbol.setString(string);
        Object object = SymbolTable.get(string);
        this.symbol.kind = object == null ? (Character.isUpperCase(string.charAt(0)) ? 123 : 124) : (Integer)object;
        this.back_ch();
    }

    public Symbol in_sym() {
        this.next_ch();
        if (this.newSymbols) {
            this.symbol = new Symbol();
        }
        boolean bl = true;
        block35: while (bl) {
            bl = false;
            this.symbol.startPos = this.input.getMarker();
            switch (this.ch) {
                case '\u0000': {
                    this.symbol.kind = 99;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    while (Character.isWhitespace(this.ch)) {
                        this.next_ch();
                    }
                    bl = true;
                    break;
                }
                case '/': {
                    this.next_ch();
                    if (this.ch == '/' || this.ch == '*') {
                        this.in_comment();
                        if (!this.newSymbols) continue block35;
                        bl = true;
                        break;
                    }
                    this.symbol.kind = 33;
                    this.back_ch();
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.in_identifier();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.in_number();
                    break;
                }
                case '#': {
                    this.symbol.kind = 73;
                    break;
                }
                case '\'': {
                    this.symbol.kind = 72;
                    break;
                }
                case '\"': {
                    this.in_string();
                    break;
                }
                case '+': {
                    this.symbol.kind = 30;
                    break;
                }
                case '*': {
                    this.symbol.kind = 32;
                    break;
                }
                case '%': {
                    this.symbol.kind = 34;
                    break;
                }
                case '^': {
                    this.symbol.kind = 35;
                    break;
                }
                case '~': {
                    this.symbol.kind = 36;
                    break;
                }
                case '?': {
                    this.symbol.kind = 37;
                    break;
                }
                case ',': {
                    this.symbol.kind = 39;
                    break;
                }
                case '(': {
                    this.symbol.kind = 53;
                    break;
                }
                case ')': {
                    this.symbol.kind = 54;
                    break;
                }
                case '{': {
                    this.symbol.kind = 60;
                    break;
                }
                case '}': {
                    this.symbol.kind = 61;
                    break;
                }
                case ']': {
                    this.symbol.kind = 63;
                    break;
                }
                case ';': {
                    this.symbol.kind = 65;
                    break;
                }
                case '@': {
                    this.symbol.kind = 68;
                    break;
                }
                case '\\': {
                    this.symbol.kind = 70;
                    break;
                }
                case '[': {
                    this.next_ch();
                    if (this.ch == ']') {
                        this.symbol.kind = 75;
                        break;
                    }
                    this.symbol.kind = 62;
                    this.back_ch();
                    break;
                }
                case '|': {
                    this.next_ch();
                    if (this.ch == '|') {
                        this.symbol.kind = 40;
                        break;
                    }
                    this.symbol.kind = 41;
                    this.back_ch();
                    break;
                }
                case '&': {
                    this.next_ch();
                    if (this.ch == '&') {
                        this.symbol.kind = 42;
                        break;
                    }
                    this.symbol.kind = 43;
                    this.back_ch();
                    break;
                }
                case '!': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 44;
                        break;
                    }
                    this.symbol.kind = 45;
                    this.back_ch();
                    break;
                }
                case '<': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 46;
                        break;
                    }
                    if (this.ch == '<') {
                        this.symbol.kind = 48;
                        break;
                    }
                    if (this.ch == '>') {
                        this.symbol.kind = 74;
                        break;
                    }
                    if (this.ch == '-') {
                        this.next_ch();
                        if (this.ch == '>') {
                            this.symbol.kind = 76;
                            break;
                        }
                        this.symbol.kind = 47;
                        this.back_ch();
                        this.back_ch();
                        break;
                    }
                    this.symbol.kind = 47;
                    this.back_ch();
                    break;
                }
                case '>': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 49;
                        break;
                    }
                    if (this.ch == '>') {
                        this.symbol.kind = 51;
                        break;
                    }
                    this.symbol.kind = 50;
                    this.back_ch();
                    break;
                }
                case '=': {
                    this.next_ch();
                    if (this.ch == '=') {
                        this.symbol.kind = 52;
                        break;
                    }
                    this.symbol.kind = 64;
                    this.back_ch();
                    break;
                }
                case '.': {
                    this.next_ch();
                    if (this.ch == '.') {
                        this.symbol.kind = 67;
                        break;
                    }
                    this.symbol.kind = 66;
                    this.back_ch();
                    break;
                }
                case '-': {
                    this.next_ch();
                    if (this.ch == '>') {
                        this.symbol.kind = 69;
                        break;
                    }
                    this.symbol.kind = 31;
                    this.back_ch();
                    break;
                }
                case ':': {
                    this.next_ch();
                    if (this.ch == ':') {
                        this.symbol.kind = 71;
                        break;
                    }
                    this.symbol.kind = 38;
                    this.back_ch();
                    break;
                }
                default: {
                    this.error("unexpected character encountered");
                }
            }
        }
        this.symbol.endPos = this.input.getMarker();
        return this.symbol;
    }

    public Symbol next_symbol() {
        if (this.buffer == null) {
            this.current = this.in_sym();
        } else {
            this.current = this.buffer;
            this.buffer = null;
        }
        return this.current;
    }

    public void push_symbol() {
        this.buffer = this.current;
    }

    public Symbol current() {
        return this.current;
    }
}

