/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.RunMenu;
import ic.doc.ltsa.lts.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MenuDefinition {
    Symbol name;
    ActionLabels actions;
    Symbol params;
    Symbol target;
    Vector actionMapDefn;
    Vector controlMapDefn;
    Vector animations;
    public static Hashtable definitions;

    public static void compile() {
        RunMenu.init();
        Enumeration enumeration = definitions.elements();
        while (enumeration.hasMoreElements()) {
            MenuDefinition menuDefinition = (MenuDefinition)enumeration.nextElement();
            RunMenu.add(menuDefinition.makeRunMenu());
        }
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Enumeration enumeration = definitions.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static boolean[] enabled(String string) {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        boolean[] blArray = new boolean[n];
        Enumeration enumeration = definitions.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            MenuDefinition menuDefinition = (MenuDefinition)definitions.get((String)enumeration.nextElement());
            boolean bl = blArray[n2++] = menuDefinition.target == null ? true : string.equals(menuDefinition.target.toString());
        }
        return blArray;
    }

    public RunMenu makeRunMenu() {
        String string = this.name.toString();
        if (this.params == null) {
            Vector vector = null;
            vector = this.actions.getActions(null, null);
            return new RunMenu(string, vector);
        }
        Relation relation = RelabelDefn.getRelabels(this.actionMapDefn);
        Relation relation2 = RelabelDefn.getRelabels(this.controlMapDefn);
        relation = relation == null ? new Relation() : relation.inverse();
        relation2 = relation2 == null ? new Relation() : relation2.inverse();
        this.includeParts(relation, relation2);
        return new RunMenu(string, this.params == null ? null : this.params.toString(), relation, relation2);
    }

    protected void includeParts(Relation relation, Relation relation2) {
        if (this.animations == null) {
            return;
        }
        Enumeration enumeration = this.animations.elements();
        while (enumeration.hasMoreElements()) {
            AnimationPart animationPart = (AnimationPart)enumeration.nextElement();
            animationPart.makePart();
            relation.union(animationPart.getActions());
            relation2.union(animationPart.getControls());
        }
    }

    public void addAnimationPart(Symbol symbol, Vector vector) {
        if (this.animations == null) {
            this.animations = new Vector();
        }
        this.animations.addElement(new AnimationPart(symbol, vector));
    }

    class AnimationPart {
        Symbol name;
        Vector relabels;
        RunMenu compiled;

        AnimationPart(Symbol symbol, Vector vector) {
            this.name = symbol;
            this.relabels = vector;
        }

        void makePart() {
            MenuDefinition menuDefinition = (MenuDefinition)definitions.get(this.name.toString());
            if (menuDefinition == null) {
                Diagnostics.fatal("Animation not found: " + this.name, this.name);
                return;
            }
            if (menuDefinition.params == null) {
                Diagnostics.fatal("Not an animation: " + this.name, this.name);
                return;
            }
            this.compiled = menuDefinition.makeRunMenu();
            if (this.relabels != null) {
                Relation relation = RelabelDefn.getRelabels(this.relabels);
                if (this.compiled.actions != null) {
                    this.compiled.actions.relabel(relation);
                }
                if (this.compiled.controls != null) {
                    this.compiled.controls.relabel(relation);
                }
            }
        }

        Relation getActions() {
            if (this.compiled != null) {
                return this.compiled.actions;
            }
            return null;
        }

        Relation getControls() {
            if (this.compiled != null) {
                return this.compiled.controls;
            }
            return null;
        }
    }
}

